/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.unit;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.jmc.common.unit.DecimalPrefix;
import org.openjdk.jmc.common.unit.DecimalScaleFactor;
import org.openjdk.jmc.common.unit.IFormatter;
import org.openjdk.jmc.common.unit.IIncrementalFormatter;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.TimestampUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.FormatThreadLocal;

class TimestampKind
extends KindOfQuantity<TimestampUnit> {
    private static final Pattern NUMBER_UNIT_PATTERN = Pattern.compile("^(-?\\d+)\\s*([a-zA-Z%]*)$");
    private static final FormatThreadLocal<DateFormat> DATE_TIME_FORMATTER_HOLDER;
    static TimestampUnit NANOS_UNIT;
    static TimestampUnit MICROS_UNIT;
    static TimestampUnit MILLIS_UNIT;
    static TimestampUnit SECONDS_UNIT;
    static TimestampKind INSTANCE;
    private static IFormatter<IQuantity> YEAR_TO_DAY_FORMATTER;
    private static IFormatter<IQuantity> YEAR_TO_SECONDS_FORMATTER;
    private static IFormatter<IQuantity> YEAR_TO_MILLIS_FORMATTER;
    private static IFormatter<IQuantity> YEAR_TO_MICROS_FORMATTER;
    private static IFormatter<IQuantity> YEAR_TO_NANOS_FORMATTER;
    private static IFormatter<IQuantity> HOUR_TO_SECONDS_FORMATTER;
    private static IFormatter<IQuantity> HOUR_TO_MILLIS_FORMATTER;
    private static IFormatter<IQuantity> HOUR_TO_MICROS_FORMATTER;
    private static IFormatter<IQuantity> HOUR_TO_NANOS_FORMATTER;
    private static IFormatter<IQuantity> MILLIS_FORMATTER;
    private static IFormatter<IQuantity> MICROS_FORMATTER;
    private static IFormatter<IQuantity> NANOS_FORMATTER;

    private static DateFormat patchYear(DateFormat df) {
        if (df instanceof SimpleDateFormat) {
            SimpleDateFormat sdf = (SimpleDateFormat)df;
            String pattern = sdf.toPattern();
            String newPattern = pattern.replaceFirst("y{2,4}", "yyyy");
            sdf.applyPattern(newPattern);
        }
        return df;
    }

    static DateFormat getDateTimeFormatter() {
        return (DateFormat)DATE_TIME_FORMATTER_HOLDER.get();
    }

    public static TimestampKind buildContentType(LinearKindOfQuantity timespan) {
        NANOS_UNIT = new TimestampUnit(timespan.getUnit(DecimalPrefix.NANO));
        MICROS_UNIT = new TimestampUnit(timespan.getUnit(DecimalPrefix.MICRO));
        MILLIS_UNIT = new TimestampUnit(timespan.getUnit(DecimalPrefix.MILLI));
        SECONDS_UNIT = new TimestampUnit(timespan.getUnit(DecimalPrefix.NONE));
        INSTANCE = new TimestampKind();
        INSTANCE.addUnit(NANOS_UNIT);
        INSTANCE.addUnit(MICROS_UNIT);
        INSTANCE.addUnit(MILLIS_UNIT);
        INSTANCE.addUnit(SECONDS_UNIT);
        YEAR_TO_DAY_FORMATTER = new LegacyFormatter(TimestampKind.patchYear(DateFormat.getDateInstance(3)));
        YEAR_TO_SECONDS_FORMATTER = new LegacyFormatter(DATE_TIME_FORMATTER_HOLDER);
        YEAR_TO_MILLIS_FORMATTER = new LegacyAndFractionFormatter(DATE_TIME_FORMATTER_HOLDER, MILLIS_UNIT);
        YEAR_TO_MICROS_FORMATTER = new LegacyAndFractionFormatter(DATE_TIME_FORMATTER_HOLDER, MICROS_UNIT);
        YEAR_TO_NANOS_FORMATTER = new LegacyAndFractionFormatter(DATE_TIME_FORMATTER_HOLDER, NANOS_UNIT);
        FormatThreadLocal<DateFormat> timeHolder = new FormatThreadLocal<DateFormat>(DateFormat.getTimeInstance(2));
        HOUR_TO_SECONDS_FORMATTER = new LegacyFormatter(timeHolder);
        HOUR_TO_MILLIS_FORMATTER = new LegacyAndFractionFormatter(timeHolder, MILLIS_UNIT);
        HOUR_TO_MICROS_FORMATTER = new LegacyAndFractionFormatter(timeHolder, MICROS_UNIT);
        HOUR_TO_NANOS_FORMATTER = new LegacyAndFractionFormatter(timeHolder, NANOS_UNIT);
        MILLIS_FORMATTER = new FractionFormatter(MILLIS_UNIT);
        MICROS_FORMATTER = new FractionFormatter(MICROS_UNIT);
        NANOS_FORMATTER = new FractionFormatter(NANOS_UNIT);
        return INSTANCE;
    }

    private TimestampKind() {
        super("timestamp");
    }

    @Override
    public TimestampUnit getPreferredUnit(IQuantity value, double minNumericalValue, double maxNumericalValue) {
        LinearUnit timeOffsetUnit = value.getUnit().getDeltaUnit();
        IQuantity asTimeSpan = timeOffsetUnit.quantity(value.longValue());
        return new TimestampUnit(timeOffsetUnit.getContentType().getPreferredUnit(asTimeSpan, minNumericalValue, maxNumericalValue));
    }

    @Override
    public TimestampUnit getLargestExactUnit(IQuantity value) {
        LinearUnit timeOffsetUnit = value.getUnit().getDeltaUnit();
        IQuantity asTimeSpan = timeOffsetUnit.quantity(value.longValue());
        return new TimestampUnit(timeOffsetUnit.getContentType().getLargestExactUnit(asTimeSpan));
    }

    @Override
    public IFormatter<IQuantity> getFormatterResolving(IRange<IQuantity> range) {
        IFormatter<IQuantity> minimalFormat;
        IFormatter<IQuantity> middleFormat;
        IFormatter<IQuantity> fullFormat;
        LinearUnit resolutionUnit = (LinearUnit)((KindOfQuantity)range.getExtent().getType()).getPreferredUnit(range.getExtent(), 1.0, 1000.0);
        if (resolutionUnit.compareTo(UnitLookup.DAY) >= 0) {
            return YEAR_TO_DAY_FORMATTER;
        }
        if (resolutionUnit.compareTo(UnitLookup.SECOND) >= 0) {
            return new IIncrementalFormatter(){

                @Override
                public String format(IQuantity q) {
                    return YEAR_TO_SECONDS_FORMATTER.format(q);
                }

                @Override
                public String formatContext(IQuantity firstShown) {
                    return YEAR_TO_DAY_FORMATTER.format(firstShown);
                }

                @Override
                public String formatAdjacent(IQuantity previous, IQuantity current) {
                    if (previous == null) {
                        return YEAR_TO_SECONDS_FORMATTER.format(current);
                    }
                    if (YEAR_TO_DAY_FORMATTER.format(previous).equals(YEAR_TO_DAY_FORMATTER.format(current))) {
                        return HOUR_TO_SECONDS_FORMATTER.format(current);
                    }
                    return YEAR_TO_SECONDS_FORMATTER.format(current);
                }
            };
        }
        if (resolutionUnit.compareTo(UnitLookup.MILLISECOND) >= 0) {
            fullFormat = YEAR_TO_MILLIS_FORMATTER;
            middleFormat = HOUR_TO_MILLIS_FORMATTER;
            minimalFormat = MILLIS_FORMATTER;
        } else if (resolutionUnit.compareTo(UnitLookup.MICROSECOND) >= 0) {
            fullFormat = YEAR_TO_MICROS_FORMATTER;
            middleFormat = HOUR_TO_MICROS_FORMATTER;
            minimalFormat = MICROS_FORMATTER;
        } else {
            fullFormat = YEAR_TO_NANOS_FORMATTER;
            middleFormat = HOUR_TO_NANOS_FORMATTER;
            minimalFormat = NANOS_FORMATTER;
        }
        return new IIncrementalFormatter(){

            @Override
            public String format(IQuantity q) {
                return fullFormat.format(q);
            }

            @Override
            public String formatContext(IQuantity firstShown) {
                return YEAR_TO_SECONDS_FORMATTER.format(firstShown);
            }

            @Override
            public String formatAdjacent(IQuantity previous, IQuantity current) {
                if (previous == null) {
                    return fullFormat.format(current);
                }
                if (YEAR_TO_SECONDS_FORMATTER.format(previous).equals(YEAR_TO_SECONDS_FORMATTER.format(current))) {
                    return minimalFormat.format(current);
                }
                if (YEAR_TO_DAY_FORMATTER.format(previous).equals(YEAR_TO_DAY_FORMATTER.format(current))) {
                    return middleFormat.format(current);
                }
                return fullFormat.format(current);
            }
        };
    }

    @Override
    public KindOfQuantity<LinearUnit> getDeltaKind() {
        return UnitLookup.TIMESPAN;
    }

    @Override
    public TimestampUnit getDefaultUnit() {
        return NANOS_UNIT;
    }

    @Override
    public ITypedQuantity<TimestampUnit> parsePersisted(String persistedQuantity) throws QuantityConversionException {
        Matcher m4 = NUMBER_UNIT_PATTERN.matcher(persistedQuantity.trim());
        if (m4.matches()) {
            TimestampUnit unit = (TimestampUnit)this.getUnit(m4.group(2));
            if (unit != null) {
                try {
                    return unit.quantity(Long.parseLong(m4.group(1)));
                }
                catch (RuntimeException runtimeException) {
                }
            } else {
                if (m4.group(2).length() == 0) {
                    throw QuantityConversionException.noUnit(persistedQuantity, this.getDefaultUnit().quantity(1234.0));
                }
                throw QuantityConversionException.unknownUnit(persistedQuantity, this.getDefaultUnit().quantity(1234.0));
            }
        }
        throw QuantityConversionException.unparsable(persistedQuantity, this.getDefaultUnit().quantity(1234.0));
    }

    @Override
    public ITypedQuantity<TimestampUnit> parseInteractive(String interactiveQuantity) throws QuantityConversionException {
        try {
            DateFormat df = DateFormat.getDateTimeInstance(3, 2);
            ParsePosition pos = new ParsePosition(0);
            Date date = df.parse(interactiveQuantity, pos);
            if (date != null) {
                long time = date.getTime();
                String rest = interactiveQuantity.substring(pos.getIndex()).trim();
                if (!rest.isEmpty()) {
                    DecimalFormat format = new DecimalFormat();
                    format.setParseBigDecimal(true);
                    pos.setIndex(0);
                    BigDecimal bd = (BigDecimal)format.parse(rest, pos);
                    if (pos.getIndex() < rest.length()) {
                        throw QuantityConversionException.unparsable(interactiveQuantity, MILLIS_UNIT.quantity(System.currentTimeMillis()));
                    }
                    if (rest.length() > 10) {
                        throw new QuantityConversionException.Quantity(QuantityConversionException.Problem.TOO_SMALL_MAGNITUDE, interactiveQuantity, NANOS_UNIT.quantity(1L));
                    }
                    if (rest.length() > 7) {
                        return NANOS_UNIT.quantity(time * 1000000L + bd.multiply(BigDecimal.valueOf(1000000000L)).longValueExact());
                    }
                    if (rest.length() > 4) {
                        return MICROS_UNIT.quantity(time * 1000L + bd.multiply(BigDecimal.valueOf(1000000L)).longValueExact());
                    }
                    return MILLIS_UNIT.quantity(time + bd.multiply(BigDecimal.valueOf(1000L)).longValueExact());
                }
                return SECONDS_UNIT.quantity(time / 1000L);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        throw QuantityConversionException.unparsable(interactiveQuantity, MILLIS_UNIT.quantity(System.currentTimeMillis()));
    }

    static {
        DateFormat df = TimestampKind.patchYear(DateFormat.getDateTimeInstance(3, 2));
        DATE_TIME_FORMATTER_HOLDER = new FormatThreadLocal<DateFormat>(df);
    }

    private static class FractionFormatter
    implements IFormatter<IQuantity> {
        private final LinearUnit fractionUnit;
        private final int numDigits;

        public FractionFormatter(IUnit resolutionUnit) {
            this.fractionUnit = resolutionUnit.getDeltaUnit();
            this.numDigits = ((DecimalScaleFactor)TimestampKind.SECONDS_UNIT.valueTransformTo((IUnit)resolutionUnit)).powerOf10;
        }

        @Override
        public String format(IQuantity q) {
            long rest = q.subtract(SECONDS_UNIT.quantity(q.clampedFloorIn(SECONDS_UNIT))).clampedFloorIn(this.fractionUnit);
            StringBuffer out = new StringBuffer(this.numDigits + 1);
            out.append(DecimalFormatSymbols.getInstance().getDecimalSeparator());
            String restStr = Long.toString(rest);
            out.append("000000000000000000000000", restStr.length(), this.numDigits);
            out.append(restStr);
            return out.toString();
        }
    }

    private static class LegacyAndFractionFormatter
    extends LegacyFormatter {
        private final LinearUnit fractionUnit;
        private final int numDigits;

        public LegacyAndFractionFormatter(FormatThreadLocal<DateFormat> dfHolder, IUnit resolutionUnit) {
            super(dfHolder);
            this.fractionUnit = resolutionUnit.getDeltaUnit();
            this.numDigits = ((DecimalScaleFactor)TimestampKind.SECONDS_UNIT.valueTransformTo((IUnit)resolutionUnit)).powerOf10;
        }

        @Override
        public String format(IQuantity q) {
            Date date = this.dateFor(q);
            StringBuffer out = new StringBuffer();
            FieldPosition secondPos = new FieldPosition(7);
            ((DateFormat)this.dfHolder.get()).format(date, out, secondPos);
            int fractionPos = secondPos.getEndIndex();
            long rest = q.subtract(MILLIS_UNIT.quantity(date.getTime())).clampedFloorIn(this.fractionUnit);
            out.insert(fractionPos++, DecimalFormatSymbols.getInstance().getDecimalSeparator());
            String restStr = Long.toString(rest);
            out.insert(fractionPos, restStr);
            out.insert(fractionPos, "000000000000000000000000", restStr.length(), this.numDigits);
            return out.toString();
        }
    }

    private static class LegacyFormatter
    implements IFormatter<IQuantity> {
        protected final FormatThreadLocal<DateFormat> dfHolder;

        public LegacyFormatter(DateFormat df) {
            this(new FormatThreadLocal<DateFormat>(df));
        }

        public LegacyFormatter(FormatThreadLocal<DateFormat> dfHolder) {
            this.dfHolder = dfHolder;
        }

        protected final Date dateFor(IQuantity q) {
            return new Date(q.clampedFloorIn(SECONDS_UNIT) * 1000L);
        }

        @Override
        public String format(IQuantity q) {
            return ((DateFormat)this.dfHolder.get()).format(this.dateFor(q));
        }
    }
}

