/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quicktheories.QuickTheory;
import org.quicktheories.core.Gen;
import org.quicktheories.generators.SourceDSL;

public final class Tester {
    public static final int DEFAULT_NUM_ROWS = 200;
    @NotNull
    private final List<CassandraVersion> versions;
    @Nullable
    private final TestSchema.Builder schemaBuilder;
    @Nullable
    private final Function<String, TestSchema.Builder> schemaBuilderFunc;
    private final int numRandomRows;
    private final int expectedRowCount;
    @NotNull
    private final List<Consumer<TestSchema.TestRow>> writeListeners;
    @NotNull
    private final List<Consumer<TestSchema.TestRow>> readListeners;
    @NotNull
    private final List<Writer> writers;
    @NotNull
    private final List<Consumer<Dataset<Row>>> checks;
    @NotNull
    private final List<Integer> numSSTables;
    @Nullable
    private final Runnable reset;
    @Nullable
    private final String filterExpression;
    @Nullable
    private final String[] columns;
    @NotNull
    private final Set<String> sumFields;
    private final boolean shouldCheckNumSSTables;
    private final boolean addLastModifiedTimestamp;
    private final int delayBetweenSSTablesInSecs;
    private final String statsClass;
    private final boolean upsert;
    private final boolean nullifyValueColumn;

    private Tester(Builder builder) {
        this.versions = builder.versions;
        this.schemaBuilder = builder.schemaBuilder;
        this.schemaBuilderFunc = builder.schemaBuilderFunc;
        this.numSSTables = builder.numSSTables;
        this.writeListeners = builder.writeListeners;
        this.readListeners = builder.readListeners;
        this.writers = builder.writers;
        this.checks = builder.checks;
        this.sumFields = builder.sumFields;
        this.reset = builder.reset;
        this.filterExpression = builder.filterExpression;
        this.numRandomRows = builder.numRandomRows;
        this.expectedRowCount = builder.expectedRowCount;
        this.shouldCheckNumSSTables = builder.shouldCheckNumSSTables;
        this.columns = builder.columns;
        this.addLastModifiedTimestamp = builder.addLastModifiedTimestamp;
        this.delayBetweenSSTablesInSecs = builder.delayBetweenSSTablesInSecs;
        this.statsClass = builder.statsClass;
        this.upsert = builder.upsert;
        this.nullifyValueColumn = builder.nullRegularColumns;
    }

    public static Builder builder(@NotNull TestSchema.Builder schemaBuilder) {
        return new Builder(schemaBuilder);
    }

    public static Builder builder(@NotNull Function<String, TestSchema.Builder> schemaBuilderFunc) {
        return new Builder(schemaBuilderFunc);
    }

    private void run() {
        QuickTheory.qt().forAll(this.versions(), this.numSSTables()).checkAssert(this::run);
    }

    private void run(CassandraVersion ... versions) {
        QuickTheory.qt().forAll(SourceDSL.arbitrary().pick(Arrays.asList(versions)), this.numSSTables()).checkAssert(this::run);
    }

    private Gen<CassandraVersion> versions() {
        return SourceDSL.arbitrary().pick(this.versions);
    }

    private Gen<Integer> numSSTables() {
        return SourceDSL.arbitrary().pick(this.numSSTables);
    }

    private void run(CassandraVersion version, int numSSTables) {
        TestUtils.runTest(version, (partitioner, directory, bridge) -> {
            String keyspace = "keyspace_" + UUID.randomUUID().toString().replaceAll("-", "");
            TestSchema schema = this.schemaBuilder != null ? this.schemaBuilder.withKeyspace(keyspace).build() : this.schemaBuilderFunc.apply(keyspace).build();
            schema.setCassandraVersion(version);
            Map sum = this.sumFields.stream().collect(Collectors.toMap(Function.identity(), ignore -> new MutableLong()));
            HashMap rows = new HashMap(this.numRandomRows);
            IntStream.range(0, numSSTables).forEach(ssTable -> schema.writeSSTable(directory, bridge, partitioner, this.upsert, writer -> IntStream.range(0, this.numRandomRows).forEach(row -> {
                TestSchema.TestRow testRow;
                while (rows.containsKey((testRow = schema.randomRow(this.nullifyValueColumn)).getPrimaryHexKey())) {
                }
                for (Consumer<TestSchema.TestRow> writeListener : this.writeListeners) {
                    writeListener.accept(testRow);
                }
                for (String sumField : this.sumFields) {
                    ((MutableLong)sum.get(sumField)).add((Number)testRow.get(sumField));
                }
                rows.put(testRow.getPrimaryHexKey(), testRow);
                Object[] values = testRow.allValues();
                if (this.upsert) {
                    this.rotate(values, schema.partitionKeys.size() + schema.clusteringKeys.size());
                }
                writer.write(values);
            })));
            int sstableCount = numSSTables;
            for (Writer writer : this.writers) {
                if (sstableCount != 0) {
                    try {
                        TimeUnit.SECONDS.sleep(this.delayBetweenSSTablesInSecs);
                    }
                    catch (InterruptedException exception) {
                        throw new RuntimeException(exception.getMessage());
                    }
                }
                if (writer.isTombstoneWriter) {
                    schema.writeTombstoneSSTable(directory, bridge, partitioner, writer.consumer);
                } else {
                    schema.writeSSTable(directory, bridge, partitioner, false, writer.consumer);
                }
                ++sstableCount;
            }
            if (this.shouldCheckNumSSTables) {
                ((AbstractLongAssert)Assertions.assertThat((long)TestUtils.countSSTables(directory)).as("Number of SSTables written does not match expected", new Object[0])).isEqualTo((long)sstableCount);
            }
            Dataset<Row> dataset = TestUtils.openLocalDataset(bridge, partitioner, directory, schema.keyspace, schema.createStatement, version, schema.udts, this.addLastModifiedTimestamp, this.statsClass, this.filterExpression, this.columns);
            int rowCount = 0;
            HashSet<String> requiredColumns = this.columns != null ? new HashSet<String>(Arrays.asList(this.columns)) : null;
            for (Row row : dataset.collectAsList()) {
                if (requiredColumns != null) {
                    HashSet<String> actualColumns = new HashSet<String>(Arrays.asList(row.schema().fieldNames()));
                    ((AbstractCollectionAssert)Assertions.assertThat(actualColumns).as("Actual Columns and Required Columns should be the same", new Object[0])).isEqualTo(requiredColumns);
                }
                TestSchema.TestRow actualRow = schema.toTestRow(row, requiredColumns, CassandraBridgeFactory.getSparkSql((CassandraVersion)version));
                if (this.numRandomRows > 0) {
                    String key = actualRow.getPrimaryHexKey();
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)rows.containsKey(key)).as("Unexpected row read in Spark", new Object[0])).isTrue();
                    ((ObjectAssert)Assertions.assertThat((Object)((TestSchema.TestRow)rows.get(key)).withColumns(requiredColumns)).as("Row read in Spark does not match expected", new Object[0])).isEqualTo((Object)actualRow);
                }
                for (Consumer<TestSchema.TestRow> readListener : this.readListeners) {
                    readListener.accept(actualRow);
                }
                ++rowCount;
            }
            if (this.expectedRowCount >= 0) {
                ((AbstractIntegerAssert)Assertions.assertThat((int)rowCount).as("Number of rows read does not match expected", new Object[0])).isEqualTo(this.expectedRowCount * sstableCount);
            }
            for (String string : this.sumFields) {
                ((AbstractLongAssert)Assertions.assertThat((long)((Row)dataset.groupBy(new Column[0]).sum(new String[]{string}).first()).getLong(0)).as("Field '%s' does not sum to expected amount", new Object[]{string})).isEqualTo(sum.get(string).getValue().longValue());
            }
            for (Consumer consumer : this.checks) {
                consumer.accept(dataset);
            }
            if (this.reset != null) {
                this.reset.run();
            }
        });
    }

    public static TestSchema.TestRow newUniqueRow(TestSchema schema, Map<String, TestSchema.TestRow> rows) {
        return Tester.newUniqueRow(() -> ((TestSchema)schema).randomRow(), rows);
    }

    private static TestSchema.TestRow newUniqueRow(Supplier<TestSchema.TestRow> rowProvider, Map<String, TestSchema.TestRow> rows) {
        TestSchema.TestRow testRow;
        while (rows.containsKey((testRow = rowProvider.get()).getPrimaryHexKey())) {
        }
        return testRow;
    }

    private void rotate(Object[] array, int shift) {
        ArrayUtils.reverse((Object[])array, (int)0, (int)shift);
        ArrayUtils.reverse((Object[])array, (int)shift, (int)array.length);
        ArrayUtils.reverse((Object[])array, (int)0, (int)array.length);
    }

    public static final class Builder {
        @NotNull
        private List<CassandraVersion> versions = TestUtils.testableVersions();
        @Nullable
        private TestSchema.Builder schemaBuilder;
        @Nullable
        private Function<String, TestSchema.Builder> schemaBuilderFunc;
        private int numRandomRows = 200;
        private int expectedRowCount = -1;
        @NotNull
        private final List<Consumer<TestSchema.TestRow>> writeListeners = new ArrayList<Consumer<TestSchema.TestRow>>();
        @NotNull
        private final List<Consumer<TestSchema.TestRow>> readListeners = new ArrayList<Consumer<TestSchema.TestRow>>();
        @NotNull
        private final List<Writer> writers = new ArrayList<Writer>();
        @NotNull
        private final List<Consumer<Dataset<Row>>> checks = new ArrayList<Consumer<Dataset<Row>>>();
        @Nullable
        private Runnable reset = null;
        @NotNull
        private List<Integer> numSSTables = ImmutableList.of((Object)1, (Object)2, (Object)5);
        @NotNull
        private Set<String> sumFields = Collections.emptySet();
        @Nullable
        private String filterExpression;
        @Nullable
        private String[] columns = null;
        private boolean shouldCheckNumSSTables = true;
        private boolean addLastModifiedTimestamp = false;
        private int delayBetweenSSTablesInSecs = 0;
        private String statsClass = null;
        private boolean upsert = false;
        private boolean nullRegularColumns = false;

        private Builder(@NotNull TestSchema.Builder schemaBuilder) {
            this.schemaBuilder = schemaBuilder;
        }

        private Builder(@NotNull Function<String, TestSchema.Builder> schemaBuilderFunc) {
            this.schemaBuilderFunc = schemaBuilderFunc;
        }

        public Builder withVersions(@NotNull Collection<CassandraVersion> versions) {
            this.versions = ImmutableList.copyOf(versions);
            return this;
        }

        public Builder withNumRandomSSTables(Integer ... numSSTables) {
            this.numSSTables = ImmutableList.copyOf((Object[])numSSTables);
            return this;
        }

        public Builder withSumField(String ... fields) {
            this.sumFields = ImmutableSet.copyOf((Object[])fields);
            return this;
        }

        public Builder withNumRandomRows(int numRow) {
            this.numRandomRows = numRow;
            return this;
        }

        public Builder dontWriteRandomData() {
            this.numSSTables = ImmutableList.of((Object)0);
            this.numRandomRows = 0;
            return this;
        }

        public Builder withWriteListener(@Nullable Consumer<TestSchema.TestRow> writeListener) {
            if (writeListener != null) {
                this.writeListeners.add(writeListener);
            }
            return this;
        }

        public Builder withReadListener(@Nullable Consumer<TestSchema.TestRow> readListener) {
            if (readListener != null) {
                this.readListeners.add(readListener);
            }
            return this;
        }

        public Builder withSSTableWriter(@Nullable Consumer<CassandraBridge.Writer> consumer) {
            if (consumer != null) {
                this.writers.add(new Writer(consumer));
            }
            return this;
        }

        public Builder withTombstoneWriter(@Nullable Consumer<CassandraBridge.Writer> consumer) {
            if (consumer != null) {
                this.writers.add(new Writer(consumer, true));
            }
            return this;
        }

        public Builder withCheck(@Nullable Consumer<Dataset<Row>> check) {
            if (check != null) {
                this.checks.add(check);
            }
            return this;
        }

        public Builder withExpectedRowCountPerSSTable(int expectedRowCount) {
            this.expectedRowCount = expectedRowCount;
            return this;
        }

        public Builder withReset(Runnable reset) {
            this.reset = reset;
            return this;
        }

        public Builder withFilter(@NotNull String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public Builder withColumns(String ... columns) {
            this.columns = columns;
            return this;
        }

        public Builder dontCheckNumSSTables() {
            this.shouldCheckNumSSTables = false;
            return this;
        }

        public Builder withLastModifiedTimestampColumn() {
            this.addLastModifiedTimestamp = true;
            return this;
        }

        public Builder withDelayBetweenSSTablesInSecs(int delay) {
            this.delayBetweenSSTablesInSecs = delay;
            return this;
        }

        public Builder withStatsClass(String statsClass) {
            this.statsClass = statsClass;
            return this;
        }

        public Builder withUpsert() {
            this.upsert = true;
            return this;
        }

        public Builder withNullRegularColumns() {
            this.nullRegularColumns = true;
            return this;
        }

        public void run() {
            Preconditions.checkArgument((this.schemaBuilder != null || this.schemaBuilderFunc != null ? 1 : 0) != 0);
            new Tester(this).run();
        }

        public void run(CassandraVersion ... versions) {
            Preconditions.checkArgument((this.schemaBuilder != null || this.schemaBuilderFunc != null ? 1 : 0) != 0);
            new Tester(this).run(versions);
        }
    }

    static class Writer {
        final Consumer<CassandraBridge.Writer> consumer;
        final boolean isTombstoneWriter;

        Writer(Consumer<CassandraBridge.Writer> consumer) {
            this(consumer, false);
        }

        Writer(Consumer<CassandraBridge.Writer> consumer, boolean isTombstoneWriter) {
            this.consumer = consumer;
            this.isTombstoneWriter = isTombstoneWriter;
        }
    }
}

