/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.spark.data.ClientConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;

class ClientConfigTests {
    public static final Map<String, String> REQUIRED_CLIENT_CONFIG_OPTIONS = ImmutableMap.of((Object)"keyspace", (Object)"big-data", (Object)"table", (Object)"customers", (Object)"sidecar_contact_points", (Object)"localhost");

    ClientConfigTests() {
    }

    @ParameterizedTest
    @ValueSource(strings={"2h", "200s", "4d", "60m", "  60m", "50s ", " 32d "})
    void testPositiveSnapshotTTLPatterns(String input) {
        Assertions.assertThat((String)input.trim()).matches((CharSequence)"\\d+(d|h|m|s)");
    }

    @ParameterizedTest
    @ValueSource(strings={"", " ", "2 h", "200", "d", "6 0m", " h", "3.5h", ".8m", "4.d", "1e+7m"})
    void testNegativeSnapshotTTLPatterns(String input) {
        Assertions.assertThat((String)input).doesNotMatch((CharSequence)"\\d+(d|h|m|s)");
    }

    @ParameterizedTest
    @CsvSource(value={"false,false,noop", "true,false,NoOp", "true,true,  Noop ", "false,false,noop 50m"})
    void testValidNoOpClearSnapshotStrategyParsing(boolean hasDeprecatedSnapshotOption, boolean clearSnapshot, String option) {
        ClientConfig.ClearSnapshotStrategy clearSnapshotStrategy = this.getClearSnapshotStrategy(option, hasDeprecatedSnapshotOption, clearSnapshot);
        Assertions.assertThat((Object)clearSnapshotStrategy).isInstanceOf(ClientConfig.ClearSnapshotStrategy.NoOp.class);
        Assertions.assertThat((boolean)clearSnapshotStrategy.shouldClearOnCompletion()).isFalse();
        Assertions.assertThat((boolean)clearSnapshotStrategy.hasTTL()).isFalse();
        Assertions.assertThat((String)clearSnapshotStrategy.ttl()).isNull();
    }

    @ParameterizedTest
    @CsvSource(value={"false,false,tTL 10h,10h", "true,false,  TTL   5d  ,5d", "true,true,  Ttl 2m  ,2m"})
    void testValidTTLClearSnapshotStrategyParsing(boolean hasDeprecatedSnapshotOption, boolean clearSnapshot, String option, String expectedSnapshotTTL) {
        ClientConfig.ClearSnapshotStrategy clearSnapshotStrategy = this.getClearSnapshotStrategy(option, hasDeprecatedSnapshotOption, clearSnapshot);
        Assertions.assertThat((Object)clearSnapshotStrategy).isInstanceOf(ClientConfig.ClearSnapshotStrategy.TTL.class);
        Assertions.assertThat((boolean)clearSnapshotStrategy.shouldClearOnCompletion()).isFalse();
        Assertions.assertThat((boolean)clearSnapshotStrategy.hasTTL()).isTrue();
        Assertions.assertThat((String)clearSnapshotStrategy.ttl()).isEqualTo(expectedSnapshotTTL);
    }

    @ParameterizedTest
    @CsvSource(value={"false,false,onCompletion", "true,false,OnCoMpLeTiOn", "true,true,  ONCOMPLETION ", "false,false,OnCoMpLeTiOn 5h"})
    void testValidOnCompletionClearSnapshotStrategyParsing(boolean hasDeprecatedSnapshotOption, boolean clearSnapshot, String option) {
        ClientConfig.ClearSnapshotStrategy clearSnapshotStrategy = this.getClearSnapshotStrategy(option, hasDeprecatedSnapshotOption, clearSnapshot);
        Assertions.assertThat((Object)clearSnapshotStrategy).isInstanceOf(ClientConfig.ClearSnapshotStrategy.OnCompletion.class);
        Assertions.assertThat((boolean)clearSnapshotStrategy.shouldClearOnCompletion()).isTrue();
        Assertions.assertThat((boolean)clearSnapshotStrategy.hasTTL()).isFalse();
        Assertions.assertThat((String)clearSnapshotStrategy.ttl()).isNull();
    }

    @ParameterizedTest
    @CsvSource(value={"false,false,onCompletionOrTTL 200m, 200m", "true,false,oNcOmPlEtIoNoRtTL   0560m,0560m", "true,true,  ONCOMPLETIONORTTL  3d, 3d"})
    void testValidOnCompletionOrTTLClearSnapshotStrategyParsing(boolean hasDeprecatedSnapshotOption, boolean clearSnapshot, String option, String expectedSnapshotTTL) {
        ClientConfig.ClearSnapshotStrategy clearSnapshotStrategy = this.getClearSnapshotStrategy(option, hasDeprecatedSnapshotOption, clearSnapshot);
        Assertions.assertThat((Object)clearSnapshotStrategy).isInstanceOf(ClientConfig.ClearSnapshotStrategy.OnCompletionOrTTL.class);
        Assertions.assertThat((boolean)clearSnapshotStrategy.shouldClearOnCompletion()).isTrue();
        Assertions.assertThat((boolean)clearSnapshotStrategy.hasTTL()).isTrue();
        Assertions.assertThat((String)clearSnapshotStrategy.ttl()).isEqualTo(expectedSnapshotTTL);
    }

    @ParameterizedTest
    @CsvSource(value={"delete 10h", "ttl5d", "Ttl 2ms", "TTL", "tTL", "No Op", "on Completion", "ON COMPLETION 3d", "onCompletionOrTTL ", "oN cOmPlEtIoNoRtTL 560m"})
    void testInValidClearSnapshotStrategyParsing(String option) {
        HashMap<String, String> options = new HashMap<String, String>(REQUIRED_CLIENT_CONFIG_OPTIONS);
        options.put("clearsnapshotstrategy", option);
        Assertions.assertThatThrownBy(() -> {
            ClientConfig clientConfig = ClientConfig.create((Map)options);
            clientConfig.parseClearSnapshotStrategy(false, false, option);
        }).isInstanceOf(IllegalArgumentException.class);
    }

    private ClientConfig.ClearSnapshotStrategy getClearSnapshotStrategy(String clearSnapshotStrategyOption, boolean hasDeprecatedSnapshotOption, boolean clearSnapshot) {
        HashMap<String, String> options = new HashMap<String, String>(REQUIRED_CLIENT_CONFIG_OPTIONS);
        options.put("clearsnapshotstrategy", clearSnapshotStrategyOption);
        ClientConfig clientConfig = ClientConfig.create(options);
        return clientConfig.parseClearSnapshotStrategy(hasDeprecatedSnapshotOption, clearSnapshot, clearSnapshotStrategyOption);
    }
}

