/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.partitioner;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.data.PartitionedDataLayer;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.data.partitioner.CassandraRing;
import org.apache.cassandra.spark.data.partitioner.MultipleReplicas;
import org.apache.cassandra.spark.data.partitioner.SingleReplica;
import org.apache.cassandra.spark.data.partitioner.SingleReplicaTests;
import org.apache.cassandra.spark.reader.SparkSSTableReader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.quicktheories.QuickTheory;

public class MultipleReplicasTests {
    private static final int[] NUM_SSTABLES = new int[]{3, 5, 7, 11, 13, 17, 19, 23};

    @Test
    public void testRF1AllUp() {
        MultipleReplicasTests.runTest(3, 1, 0, 0);
    }

    @Test
    public void testRF1BackupsDown() {
        MultipleReplicasTests.runTest(3, 1, 0, 2);
    }

    @Test
    public void testRF1SomeDown() {
        MultipleReplicasTests.runTest(3, 1, 1, 1);
    }

    @Test
    public void testRF3QuorumAllUp() {
        MultipleReplicasTests.runTest(3, 2, 0, 0);
    }

    @Test
    public void testRF3QuorumBackupInstanceDown() {
        MultipleReplicasTests.runTest(3, 2, 0, 1);
    }

    @Test
    public void testRF3QuorumPrimaryInstanceDown() {
        MultipleReplicasTests.runTest(3, 2, 1, 0);
    }

    @Test
    public void testRF5QuorumTwoPrimaryInstanceDown() {
        MultipleReplicasTests.runTest(5, 3, 2, 0);
    }

    @Test
    public void testRF1NotEnoughReplicas() {
        Assertions.assertThatThrownBy(() -> MultipleReplicasTests.runTest(1, 1, 1, 0)).isInstanceOf(AssertionError.class);
    }

    @Test
    public void testRF3QuorumNotEnoughReplicas() {
        Assertions.assertThatThrownBy(() -> MultipleReplicasTests.runTest(3, 2, 1, 1)).isInstanceOf(AssertionError.class);
    }

    @Test
    public void testRFAllNotEnoughReplicas() {
        Assertions.assertThatThrownBy(() -> MultipleReplicasTests.runTest(3, 3, 1, 0)).isInstanceOf(AssertionError.class);
    }

    private static void runTest(int numInstances, int rfFactor, int numDownPrimaryInstances, int numDownBackupInstances) {
        QuickTheory.qt().forAll(TestUtils.partitioners()).checkAssert(partitioner -> {
            int numSSTables;
            boolean isDown;
            int position;
            CassandraRing ring = TestUtils.createRing(partitioner, numInstances);
            ArrayList instances = new ArrayList(ring.instances());
            PartitionedDataLayer dataLayer = (PartitionedDataLayer)Mockito.mock(PartitionedDataLayer.class);
            Range range = Range.closed((Comparable)partitioner.minToken(), (Comparable)partitioner.maxToken());
            HashSet<SingleReplica> primaryReplicas = new HashSet<SingleReplica>(rfFactor);
            HashSet<SingleReplica> backupReplicas = new HashSet<SingleReplica>(numInstances - rfFactor);
            int expectedSSTables = 0;
            int upInstances = 0;
            ArrayList<CassandraInstance> requestedInstances = new ArrayList<CassandraInstance>();
            for (position = 0; position < rfFactor; ++position) {
                isDown = position < numDownPrimaryInstances;
                numSSTables = NUM_SSTABLES[position];
                requestedInstances.add((CassandraInstance)instances.get(position));
                if (!isDown) {
                    ++upInstances;
                    expectedSSTables += numSSTables;
                }
                primaryReplicas.add(MultipleReplicasTests.mockReplica((CassandraInstance)instances.get(position), dataLayer, (Range<BigInteger>)range, numSSTables, isDown));
            }
            for (position = rfFactor; position < numInstances; ++position) {
                isDown = position - rfFactor < numDownBackupInstances;
                numSSTables = NUM_SSTABLES[position];
                SingleReplica replica = MultipleReplicasTests.mockReplica((CassandraInstance)instances.get(position), dataLayer, (Range<BigInteger>)range, numSSTables, isDown);
                if (!isDown && upInstances < rfFactor) {
                    ++upInstances;
                    expectedSSTables += numSSTables;
                    requestedInstances.add((CassandraInstance)instances.get(position));
                }
                backupReplicas.add(replica);
            }
            MultipleReplicas replicas = new MultipleReplicas(primaryReplicas, backupReplicas, (Stats)Stats.DoNothingStats.INSTANCE);
            Set readers = replicas.openAll((ssTable, isRepairPrimary) -> new TestSSTableReader(ssTable));
            Assertions.assertThat((Collection)readers).hasSize(expectedSSTables);
            for (CassandraInstance instance : requestedInstances) {
                ((PartitionedDataLayer)Mockito.verify((Object)dataLayer, (VerificationMode)Mockito.times((int)1))).listInstance(ArgumentMatchers.eq((int)0), (Range)ArgumentMatchers.eq((Object)range), (CassandraInstance)ArgumentMatchers.eq((Object)instance));
            }
        });
    }

    private static SingleReplica mockReplica(CassandraInstance instance, PartitionedDataLayer dataLayer, Range<BigInteger> range, int numSSTables, boolean shouldFail) {
        Mockito.when((Object)dataLayer.listInstance(ArgumentMatchers.eq((int)0), (Range)ArgumentMatchers.eq(range), (CassandraInstance)ArgumentMatchers.eq((Object)instance))).thenAnswer(invocation -> {
            if (shouldFail) {
                CompletableFuture exceptionally = new CompletableFuture();
                exceptionally.completeExceptionally(new RuntimeException("Something went wrong"));
                return exceptionally;
            }
            return CompletableFuture.completedFuture(IntStream.range(0, numSSTables).mapToObj(ssTable -> SingleReplicaTests.mockSSTable()));
        });
        return new SingleReplica(instance, dataLayer, range, 0, SingleReplicaTests.EXECUTOR, true);
    }

    public static class TestSSTableReader
    implements SparkSSTableReader {
        public TestSSTableReader(SSTable ssTable) {
        }

        public BigInteger firstToken() {
            return BigInteger.valueOf(-4099276460824344804L);
        }

        public BigInteger lastToken() {
            return BigInteger.valueOf(0x1C71C71C71C71C71L);
        }

        public boolean ignore() {
            return false;
        }
    }
}

