/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.data.CassandraTypes;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.VersionRunner;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.utils.MapUtils;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.quicktheories.QuickTheory;

public class SchemaTests
extends VersionRunner {
    public static final String SCHEMA = "CREATE TABLE backup_test.sbr_test (\n    account_id uuid,\n    balance bigint,\n    name text,\n    PRIMARY KEY(account_id)\n) WITH bloom_filter_fp_chance = 0.1\n    AND caching = {'keys': 'ALL', 'rows_per_partition': 'NONE'}\n    AND comment = 'Created by: jberragan'\n    AND compaction = {'class': 'org.apache.cassandra.db.compaction.LeveledCompactionStrategy'}\n    AND compression = {'chunk_length_in_kb': '64', 'class': 'org.apache.cassandra.io.compress.LZ4Compressor'}\n    AND crc_check_chance = 1.0\n    AND default_time_to_live = 0\n    AND gc_grace_seconds = 864000\n    AND max_index_interval = 2048\n    AND memtable_flush_period_in_ms = 0\n    AND min_index_interval = 128\n;";

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testBuild(CassandraBridge bridge) {
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        CqlTable table = bridge.buildSchema(SCHEMA, "backup_test", replicationFactor);
        List fields = table.fields();
        Assertions.assertThat((List)fields).isNotNull();
        Assertions.assertThat((List)fields).hasSize(3);
        Assertions.assertThat((String)((CqlField)fields.get(0)).name()).isEqualTo("account_id");
        Assertions.assertThat((String)((CqlField)fields.get(1)).name()).isEqualTo("balance");
        Assertions.assertThat((String)((CqlField)fields.get(2)).name()).isEqualTo("name");
        Assertions.assertThat((String)table.createStatement()).isEqualTo(SCHEMA);
        Assertions.assertThat((Integer)((Integer)table.replicationFactor().getOptions().get("DC1"))).isEqualTo(3);
        Assertions.assertThat((Integer)((Integer)table.replicationFactor().getOptions().get("DC2"))).isEqualTo(3);
        Assertions.assertThat((Integer)((Integer)table.replicationFactor().getOptions().get("DC3"))).isNull();
        Assertions.assertThat((int)table.numPartitionKeys()).isEqualTo(1);
        Assertions.assertThat((int)table.numClusteringKeys()).isEqualTo(0);
        Assertions.assertThat((int)table.numStaticColumns()).isEqualTo(0);
        Assertions.assertThat((int)table.numValueColumns()).isEqualTo(2);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testEquality(CassandraBridge bridge) {
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        CqlTable table1 = bridge.buildSchema(SCHEMA, "backup_test", replicationFactor);
        CqlTable table2 = bridge.buildSchema(SCHEMA, "backup_test", replicationFactor);
        Assertions.assertThat((Object)table1).isNotSameAs((Object)table2);
        Assertions.assertThat((Object)table2).isNotEqualTo(null);
        Assertions.assertThat((Object)table1).isNotEqualTo(null);
        Assertions.assertThat((Object)table1).isNotEqualTo(new ArrayList());
        Assertions.assertThat((Object)table1).isEqualTo((Object)table1);
        Assertions.assertThat((Object)table1).isEqualTo((Object)table2);
        Assertions.assertThat((int)table1.hashCode()).isEqualTo(table2.hashCode());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testSameKeyspace(CassandraBridge bridge) {
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        CqlTable table1 = bridge.buildSchema(SCHEMA, "backup_test", replicationFactor);
        CqlTable table2 = bridge.buildSchema(SCHEMA.replace("sbr_test", "sbr_test2"), "backup_test", replicationFactor);
        Assertions.assertThat((Object)table1).isNotSameAs((Object)table2);
        Assertions.assertThat((String)table2.table()).isEqualTo("sbr_test2");
        Assertions.assertThat((String)table1.table()).isEqualTo("sbr_test");
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testHasher(CassandraBridge bridge) {
        Assertions.assertThat((BigInteger)bridge.hash(Partitioner.Murmur3Partitioner, ByteBuffer.allocate(8).putLong(992393994949L).flip())).isEqualTo((Object)BigInteger.valueOf(6747049197585865300L));
        Assertions.assertThat((BigInteger)bridge.hash(Partitioner.Murmur3Partitioner, ByteBuffer.allocate(4).putInt(999).flip())).isEqualTo((Object)BigInteger.valueOf(7071430368280192841L));
        Assertions.assertThat((BigInteger)bridge.hash(Partitioner.RandomPartitioner, ByteBuffer.allocate(8).putLong(34828288292L).flip())).isEqualTo((Object)new BigInteger("28812675363873787366858706534556752548"));
        Assertions.assertThat((BigInteger)bridge.hash(Partitioner.RandomPartitioner, ByteBuffer.allocate(4).putInt(1929239).flip())).isEqualTo((Object)new BigInteger("154860613751552680515987154638148676974"));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testUUID(CassandraBridge bridge) {
        Assertions.assertThat((int)bridge.getTimeUUID().version()).isEqualTo(1);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testCollections(CassandraBridge bridge) {
        String createStatement = "CREATE TABLE backup_test.collection_test (account_id uuid PRIMARY KEY, balance bigint, names set<text>);";
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        CqlTable table = bridge.buildSchema(createStatement, "backup_test", replicationFactor);
        Assertions.assertThat((Comparable)table.getField("names").type().internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Set);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testSetClusteringKey(CassandraBridge bridge) {
        String createStatement = "CREATE TABLE backup_test.sbr_test_set_ck (pk uuid, ck frozen<set<text>>, PRIMARY KEY (pk, ck));";
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        bridge.buildSchema(createStatement, "backup_test", replicationFactor);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testListClusteringKey(CassandraBridge bridge) {
        String createStatement = "CREATE TABLE backup_test.sbr_test_list_ck (pk uuid, ck frozen<list<bigint>>, PRIMARY KEY (pk, ck));";
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        bridge.buildSchema(createStatement, "backup_test", replicationFactor);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testMapClusteringKey(CassandraBridge bridge) {
        String createStatement = "CREATE TABLE backup_test.sbr_test_map_ck (pk uuid, ck frozen<map<uuid, timestamp>>, PRIMARY KEY (pk, ck));";
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        bridge.buildSchema(createStatement, "backup_test", replicationFactor);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testNativeUnsupportedColumnMetaData(CassandraBridge bridge) {
        String createStatement = "CREATE TABLE backup_test.sbr_test (account_id uuid, transactions counter, PRIMARY KEY(account_id));";
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        Assertions.assertThatThrownBy(() -> bridge.buildSchema(createStatement, "backup_test", replicationFactor)).isInstanceOf(UnsupportedOperationException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testUnsupportedInnerType(CassandraBridge bridge) {
        String createStatement = "CREATE TABLE backup_test.sbr_test (account_id uuid, transactions counter, PRIMARY KEY(account_id));";
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        Assertions.assertThatThrownBy(() -> bridge.buildSchema(createStatement, "backup_test", replicationFactor)).isInstanceOf(UnsupportedOperationException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testUnsupportedUdt(CassandraBridge bridge) {
        String createStatement = "CREATE TABLE backup_test.sbr_test (account_id uuid, transactions frozen<testudt>, PRIMARY KEY (account_id));";
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        Assertions.assertThatThrownBy(() -> bridge.buildSchema(createStatement, "backup_test", replicationFactor, Partitioner.Murmur3Partitioner, (Set)ImmutableSet.of((Object)"CREATE TYPE backup_test.testudt(birthday timestamp, count bigint, length counter);"))).isInstanceOf(UnsupportedOperationException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testCollectionMatcher(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> this.testMatcher("set<%s>", "set", (CqlField.NativeType)type, bridge));
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> this.testMatcher("list<%s>", "list", (CqlField.NativeType)type, bridge));
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert((first, second) -> {
            this.testMatcher("map<%s,%s>", "map", (CqlField.NativeType)first, (CqlField.NativeType)second, bridge);
            this.testMatcher("map<%s , %s>", "map", (CqlField.NativeType)first, (CqlField.NativeType)second, bridge);
        });
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> this.testMatcher(type.cqlName(), null, null, bridge));
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert((first, second) -> {
            this.testMatcher("tuple<%s,%s>", "tuple", (CqlField.NativeType)first, (CqlField.NativeType)second, bridge);
            this.testMatcher("tuple<%s , %s>", "tuple", (CqlField.NativeType)first, (CqlField.NativeType)second, bridge);
        });
    }

    private void testMatcher(String pattern, String collection, CqlField.NativeType type, CassandraBridge bridge) {
        this.testMatcher(pattern, collection, type, null, bridge);
    }

    private void testMatcher(String pattern, String collection, CqlField.NativeType first, CqlField.NativeType second, CassandraBridge bridge) {
        boolean isMap;
        boolean bl = isMap = second != null;
        String string = first == null && second == null ? pattern : (second == null ? String.format(pattern, first) : String.format(pattern, first, second));
        Matcher matcher = CassandraTypes.COLLECTION_PATTERN.matcher(string);
        Assertions.assertThat((collection != null && first != null ? 1 : 0) != 0).isEqualTo(matcher.matches());
        if (matcher.matches()) {
            Assertions.assertThat((String)collection).isNotNull();
            Assertions.assertThat((Object)first).isNotNull();
            Assertions.assertThat((String)matcher.group(1)).isEqualTo(collection);
            String[] types = CassandraTypes.splitInnerTypes((String)matcher.group(2));
            Assertions.assertThat((Object)bridge.nativeType(types[0].toUpperCase())).isEqualTo((Object)first);
            if (isMap) {
                Assertions.assertThat((Object)bridge.nativeType(types[1].toUpperCase())).isEqualTo((Object)second);
            }
        } else {
            bridge.nativeType(pattern.toUpperCase());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testFrozenMatcher(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> this.testFrozen("frozen<set<%s>>", CqlField.CqlSet.class, (CqlField.CqlType)type, bridge));
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> this.testFrozen("frozen<list<%s>>", CqlField.CqlList.class, (CqlField.CqlType)type, bridge));
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert((first, second) -> {
            this.testFrozen("frozen<map<%s,%s>>", CqlField.CqlMap.class, (CqlField.CqlType)first, (CqlField.CqlType)second, bridge);
            this.testFrozen("frozen<map<%s , %s>>", CqlField.CqlMap.class, (CqlField.CqlType)first, (CqlField.CqlType)second, bridge);
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testNestedFrozenSet(CassandraBridge bridge) {
        String pattern = "map<text, frozen<set<bigint>>>";
        CqlField.CqlType type = bridge.parseType(pattern);
        Assertions.assertThat((Object)type).isNotNull();
        Assertions.assertThat((Object)type).isInstanceOf(CqlField.CqlMap.class);
        CqlField.CqlMap map = (CqlField.CqlMap)type;
        Assertions.assertThat((Object)map.keyType()).isInstanceOf(CqlField.NativeType.class);
        Assertions.assertThat((Object)map.valueType()).isInstanceOf(CqlField.CqlFrozen.class);
        CqlField.NativeType key = (CqlField.NativeType)map.keyType();
        Assertions.assertThat((Object)key).isSameAs((Object)bridge.text());
        CqlField.CqlFrozen value = (CqlField.CqlFrozen)map.valueType();
        CqlField.CqlSet inner = (CqlField.CqlSet)value.inner();
        Assertions.assertThat((Object)inner.type()).isSameAs((Object)bridge.bigint());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testNestedFrozenMap(CassandraBridge bridge) {
        String pattern = "map<text, frozen<map<bigint, text>>>";
        CqlField.CqlType type = bridge.parseType(pattern);
        Assertions.assertThat((Object)type).isNotNull();
        Assertions.assertThat((Object)type).isInstanceOf(CqlField.CqlMap.class);
        CqlField.CqlMap map = (CqlField.CqlMap)type;
        Assertions.assertThat((Object)map.keyType()).isInstanceOf(CqlField.NativeType.class);
        Assertions.assertThat((Object)map.valueType()).isInstanceOf(CqlField.CqlFrozen.class);
        CqlField.NativeType key = (CqlField.NativeType)map.keyType();
        Assertions.assertThat((Object)key).isSameAs((Object)bridge.text());
        CqlField.CqlFrozen value = (CqlField.CqlFrozen)map.valueType();
        CqlField.CqlMap inner = (CqlField.CqlMap)value.inner();
        Assertions.assertThat((Object)inner.keyType()).isSameAs((Object)bridge.bigint());
        Assertions.assertThat((Object)inner.valueType()).isSameAs((Object)bridge.text());
    }

    private void testFrozen(String pattern, Class<? extends CqlField.CqlCollection> collectionType, CqlField.CqlType innerType, CassandraBridge bridge) {
        this.testFrozen(pattern, collectionType, innerType, null, bridge);
    }

    private void testFrozen(String pattern, Class<? extends CqlField.CqlCollection> collectionType, CqlField.CqlType first, @Nullable CqlField.CqlType second, CassandraBridge bridge) {
        pattern = second != null ? String.format(pattern, first, second) : String.format(pattern, first);
        CqlField.CqlType type = bridge.parseType(pattern);
        Assertions.assertThat((Object)type).isNotNull();
        Assertions.assertThat((Object)type).isInstanceOf(CqlField.CqlFrozen.class);
        CqlField.CqlFrozen frozen = (CqlField.CqlFrozen)type;
        CqlField.CqlCollection inner = (CqlField.CqlCollection)frozen.inner();
        Assertions.assertThat((Object)inner).isNotNull();
        Assertions.assertThat((boolean)collectionType.isInstance(inner)).isTrue();
        Assertions.assertThat((Object)inner.type()).isEqualTo((Object)first);
        if (second != null) {
            CqlField.CqlMap map = (CqlField.CqlMap)inner;
            Assertions.assertThat((Object)map.valueType()).isEqualTo((Object)second);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testUdts(CassandraBridge bridge) {
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        String keyspace = "udt_keyspace";
        String udtName = "udt_name";
        CqlTable table = bridge.buildSchema("CREATE TABLE " + keyspace + ".udt_test (\n    account_id uuid PRIMARY KEY,\n    balance bigint,\n    info frozen<" + udtName + ">,\n    name text\n);", keyspace, replicationFactor, Partitioner.Murmur3Partitioner, (Set)ImmutableSet.of((Object)("CREATE TYPE " + keyspace + "." + udtName + " (\n  birthday timestamp,\n  nationality text,\n  weight float,\n  height int\n);")));
        Assertions.assertThat((Collection)table.udts()).hasSize(1);
        CqlField.CqlUdt udt = (CqlField.CqlUdt)table.udts().stream().findFirst().get();
        Assertions.assertThat((String)udt.name()).isEqualTo(udtName);
        List udtFields = udt.fields();
        Assertions.assertThat((List)udtFields).hasSize(4);
        Assertions.assertThat((Object)((CqlField)udtFields.get(0)).type()).isEqualTo((Object)bridge.timestamp());
        Assertions.assertThat((Object)((CqlField)udtFields.get(1)).type()).isEqualTo((Object)bridge.text());
        Assertions.assertThat((Object)((CqlField)udtFields.get(2)).type()).isEqualTo((Object)bridge.aFloat());
        Assertions.assertThat((Object)((CqlField)udtFields.get(3)).type()).isEqualTo((Object)bridge.aInt());
        List fields = table.fields();
        Assertions.assertThat((Object)((CqlField)fields.get(0)).type()).isEqualTo((Object)bridge.uuid());
        Assertions.assertThat((Object)((CqlField)fields.get(1)).type()).isEqualTo((Object)bridge.bigint());
        Assertions.assertThat((Comparable)((CqlField)fields.get(2)).type().internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Frozen);
        Assertions.assertThat((Object)((CqlField)fields.get(3)).type()).isEqualTo((Object)bridge.text());
        CqlField.CqlFrozen frozenField = (CqlField.CqlFrozen)((CqlField)fields.get(2)).type();
        Assertions.assertThat((Comparable)frozenField.inner().internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Udt);
        CqlField.CqlUdt udtField = (CqlField.CqlUdt)frozenField.inner();
        Assertions.assertThat((Object)udtField.field(0).type()).isEqualTo((Object)bridge.timestamp());
        Assertions.assertThat((Object)udtField.field(1).type()).isEqualTo((Object)bridge.text());
        Assertions.assertThat((Object)udtField.field(2).type()).isEqualTo((Object)bridge.aFloat());
        Assertions.assertThat((Object)udtField.field(3).type()).isEqualTo((Object)bridge.aInt());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testCollectionUdts(CassandraBridge bridge) {
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        String keyspace = "collection_keyspace";
        String udtName = "basic_info";
        CqlTable table = bridge.buildSchema("CREATE TABLE " + keyspace + "." + udtName + " (\n    account_id uuid PRIMARY KEY,\n    balance bigint,\n    info frozen<map<text, " + udtName + ">>,\n    name text\n);", "collection_keyspace", replicationFactor, Partitioner.Murmur3Partitioner, (Set)ImmutableSet.of((Object)("CREATE TYPE " + keyspace + "." + udtName + " (\n  birthday timestamp,\n  nationality text,\n  weight float,\n  height int\n);")));
        List fields = table.fields();
        Assertions.assertThat((Object)((CqlField)fields.get(0)).type()).isEqualTo((Object)bridge.uuid());
        Assertions.assertThat((Object)((CqlField)fields.get(1)).type()).isEqualTo((Object)bridge.bigint());
        Assertions.assertThat((Comparable)((CqlField)fields.get(2)).type().internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Frozen);
        Assertions.assertThat((Object)((CqlField)fields.get(3)).type()).isEqualTo((Object)bridge.text());
        CqlField.CqlMap mapField = (CqlField.CqlMap)((CqlField.CqlFrozen)((CqlField)fields.get(2)).type()).inner();
        Assertions.assertThat((Object)mapField.keyType()).isEqualTo((Object)bridge.text());
        CqlField.CqlFrozen valueType = (CqlField.CqlFrozen)mapField.valueType();
        CqlField.CqlUdt udtField = (CqlField.CqlUdt)valueType.inner();
        Assertions.assertThat((Object)udtField.field(0).type()).isEqualTo((Object)bridge.timestamp());
        Assertions.assertThat((Object)udtField.field(1).type()).isEqualTo((Object)bridge.text());
        Assertions.assertThat((Object)udtField.field(2).type()).isEqualTo((Object)bridge.aFloat());
        Assertions.assertThat((Object)udtField.field(3).type()).isEqualTo((Object)bridge.aInt());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testParseUdt(CassandraBridge bridge) {
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        CqlTable table = bridge.buildSchema(SCHEMA, "backup_test", replicationFactor, Partitioner.Murmur3Partitioner, (Set)ImmutableSet.of((Object)"CREATE TYPE backup_test.tuple_test (a int, b bigint, c blob, d text)"));
        Assertions.assertThat((Collection)table.udts()).hasSize(1);
        CqlField.CqlUdt udt = (CqlField.CqlUdt)table.udts().stream().findFirst().get();
        Assertions.assertThat((String)udt.name()).isEqualTo("tuple_test");
        List fields = udt.fields();
        Assertions.assertThat((List)fields).hasSize(4);
        Assertions.assertThat((Object)((CqlField)fields.get(0)).type()).isEqualTo((Object)bridge.aInt());
        Assertions.assertThat((Object)((CqlField)fields.get(1)).type()).isEqualTo((Object)bridge.bigint());
        Assertions.assertThat((Object)((CqlField)fields.get(2)).type()).isEqualTo((Object)bridge.blob());
        Assertions.assertThat((Object)((CqlField)fields.get(3)).type()).isEqualTo((Object)bridge.text());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testParseTuple(CassandraBridge bridge) {
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        CqlTable table = bridge.buildSchema("CREATE TABLE tuple_keyspace.tuple_test (\n    account_id uuid PRIMARY KEY,\n    balance bigint,\n    info tuple<bigint, text, float, boolean>,    name text\n)", "tuple_keyspace", replicationFactor, Partitioner.Murmur3Partitioner);
        List fields = table.fields();
        Assertions.assertThat((List)fields).hasSize(4);
        Assertions.assertThat((Object)((CqlField)fields.get(0)).type()).isEqualTo((Object)bridge.uuid());
        Assertions.assertThat((Object)((CqlField)fields.get(1)).type()).isEqualTo((Object)bridge.bigint());
        Assertions.assertThat((Object)((CqlField)fields.get(3)).type()).isEqualTo((Object)bridge.text());
        Assertions.assertThat((Comparable)((CqlField)fields.get(2)).type().internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Frozen);
        CqlField.CqlTuple tuple = (CqlField.CqlTuple)((CqlField.CqlFrozen)((CqlField)fields.get(2)).type()).inner();
        Assertions.assertThat((Object)tuple.type(0)).isEqualTo((Object)bridge.bigint());
        Assertions.assertThat((Object)tuple.type(1)).isEqualTo((Object)bridge.text());
        Assertions.assertThat((Object)tuple.type(2)).isEqualTo((Object)bridge.aFloat());
        Assertions.assertThat((Object)tuple.type(3)).isEqualTo((Object)bridge.bool());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testComplexSchema(CassandraBridge bridge) {
        String keyspace = "complex_schema1";
        String type1 = "CREATE TYPE " + keyspace + ".field_with_timestamp (\n    field text,\n    \"timeWithZone\" frozen<" + keyspace + ".analytics_time_with_zone>\n);";
        String type2 = "CREATE TYPE " + keyspace + ".first_last_seen_fields_v1 (\n    \"firstSeen\" frozen<" + keyspace + ".field_with_timestamp>,\n    \"lastSeen\" frozen<" + keyspace + ".field_with_timestamp>,\n    \"firstTransaction\" frozen<" + keyspace + ".field_with_timestamp>,\n    \"lastTransaction\" frozen<" + keyspace + ".field_with_timestamp>,\n    \"firstListening\" frozen<" + keyspace + ".field_with_timestamp>,\n    \"lastListening\" frozen<" + keyspace + ".field_with_timestamp>,\n    \"firstReading\" frozen<" + keyspace + ".field_with_timestamp>,\n    \"lastReading\" frozen<" + keyspace + ".field_with_timestamp>,\n    \"outputEvent\" text,\n    \"eventHistory\" frozen<map<bigint, frozen<map<text, boolean>>>>\n);";
        String type3 = "CREATE TYPE " + keyspace + ".analytics_time_with_zone (\n    time bigint,\n    \"timezoneOffsetMinutes\" int\n);";
        String type4 = "CREATE TYPE " + keyspace + ".first_last_seen_dimensions_v1 (\n    \"osMajorVersion\" text,\n    \"storeFrontId\" text,\n    platform text,\n    time_range text\n);";
        String tableStr = "CREATE TABLE " + keyspace + ".books_ltd_v3 (\n    \"consumerId\" text,\n    dimensions frozen<" + keyspace + ".first_last_seen_dimensions_v1>,\n    fields frozen<" + keyspace + ".first_last_seen_fields_v1>,\n    first_transition_time frozen<" + keyspace + ".analytics_time_with_zone>,\n    last_transition_time frozen<" + keyspace + ".analytics_time_with_zone>,\n    prev_state_id text,\n    state_id text,\n    PRIMARY KEY (\"consumerId\", dimensions)\n) WITH CLUSTERING ORDER BY (dimensions ASC);";
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        CqlTable table = bridge.buildSchema(tableStr, keyspace, replicationFactor, Partitioner.Murmur3Partitioner, (Set)ImmutableSet.of((Object)type1, (Object)type2, (Object)type3, (Object)type4));
        Assertions.assertThat((String)table.table()).isEqualTo("books_ltd_v3");
        Assertions.assertThat((String)table.keyspace()).isEqualTo(keyspace);
        Assertions.assertThat((List)table.fields()).hasSize(7);
        Assertions.assertThat((List)table.partitionKeys()).hasSize(1);
        Assertions.assertThat((List)table.clusteringKeys()).hasSize(1);
        List fields = table.fields();
        Assertions.assertThat((List)fields).hasSize(7);
        Assertions.assertThat((String)((CqlField)fields.get(0)).name()).isEqualTo("consumerId");
        Assertions.assertThat((Object)((CqlField)fields.get(0)).type()).isEqualTo((Object)bridge.text());
        CqlField clusteringKey = (CqlField)fields.get(1);
        Assertions.assertThat((String)clusteringKey.name()).isEqualTo("dimensions");
        Assertions.assertThat((Comparable)clusteringKey.type().internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Frozen);
        CqlField.CqlUdt clusteringUDT = (CqlField.CqlUdt)((CqlField.CqlFrozen)clusteringKey.type()).inner();
        Assertions.assertThat((String)clusteringUDT.name()).isEqualTo("first_last_seen_dimensions_v1");
        Assertions.assertThat((String)clusteringUDT.keyspace()).isEqualTo(keyspace);
        Assertions.assertThat((String)clusteringUDT.field(0).name()).isEqualTo("osMajorVersion");
        Assertions.assertThat((Object)clusteringUDT.field(0).type()).isEqualTo((Object)bridge.text());
        Assertions.assertThat((String)clusteringUDT.field(1).name()).isEqualTo("storeFrontId");
        Assertions.assertThat((Object)clusteringUDT.field(1).type()).isEqualTo((Object)bridge.text());
        Assertions.assertThat((String)clusteringUDT.field(2).name()).isEqualTo("platform");
        Assertions.assertThat((Object)clusteringUDT.field(2).type()).isEqualTo((Object)bridge.text());
        Assertions.assertThat((String)clusteringUDT.field(3).name()).isEqualTo("time_range");
        Assertions.assertThat((Object)clusteringUDT.field(3).type()).isEqualTo((Object)bridge.text());
        CqlField.CqlUdt fieldsUDT = (CqlField.CqlUdt)((CqlField.CqlFrozen)((CqlField)fields.get(2)).type()).inner();
        Assertions.assertThat((String)fieldsUDT.name()).isEqualTo("first_last_seen_fields_v1");
        Assertions.assertThat((String)fieldsUDT.field(0).name()).isEqualTo("firstSeen");
        Assertions.assertThat((String)((CqlField.CqlFrozen)fieldsUDT.field(0).type()).inner().name()).isEqualTo("field_with_timestamp");
        Assertions.assertThat((String)fieldsUDT.field(1).name()).isEqualTo("lastSeen");
        Assertions.assertThat((String)((CqlField.CqlFrozen)fieldsUDT.field(1).type()).inner().name()).isEqualTo("field_with_timestamp");
        Assertions.assertThat((String)fieldsUDT.field(2).name()).isEqualTo("firstTransaction");
        Assertions.assertThat((String)((CqlField.CqlFrozen)fieldsUDT.field(2).type()).inner().name()).isEqualTo("field_with_timestamp");
        Assertions.assertThat((String)fieldsUDT.field(3).name()).isEqualTo("lastTransaction");
        Assertions.assertThat((String)((CqlField.CqlFrozen)fieldsUDT.field(3).type()).inner().name()).isEqualTo("field_with_timestamp");
        Assertions.assertThat((String)fieldsUDT.field(4).name()).isEqualTo("firstListening");
        Assertions.assertThat((String)((CqlField.CqlFrozen)fieldsUDT.field(4).type()).inner().name()).isEqualTo("field_with_timestamp");
        Assertions.assertThat((String)fieldsUDT.field(5).name()).isEqualTo("lastListening");
        Assertions.assertThat((String)((CqlField.CqlFrozen)fieldsUDT.field(5).type()).inner().name()).isEqualTo("field_with_timestamp");
        Assertions.assertThat((String)fieldsUDT.field(6).name()).isEqualTo("firstReading");
        Assertions.assertThat((String)((CqlField.CqlFrozen)fieldsUDT.field(6).type()).inner().name()).isEqualTo("field_with_timestamp");
        Assertions.assertThat((String)fieldsUDT.field(7).name()).isEqualTo("lastReading");
        Assertions.assertThat((String)((CqlField.CqlFrozen)fieldsUDT.field(7).type()).inner().name()).isEqualTo("field_with_timestamp");
        Assertions.assertThat((String)fieldsUDT.field(8).name()).isEqualTo("outputEvent");
        Assertions.assertThat((Object)fieldsUDT.field(8).type()).isEqualTo((Object)bridge.text());
        Assertions.assertThat((String)fieldsUDT.field(9).name()).isEqualTo("eventHistory");
        Assertions.assertThat((Object)((CqlField.CqlMap)((CqlField.CqlFrozen)fieldsUDT.field(9).type()).inner()).keyType()).isEqualTo((Object)bridge.bigint());
        Assertions.assertThat((Comparable)((CqlField.CqlMap)((CqlField.CqlFrozen)fieldsUDT.field(9).type()).inner()).valueType().internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Frozen);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testNestedUDTs(CassandraBridge bridge) {
        ReplicationFactor replicationFactor = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)3));
        String keyspace = "nested_udt_schema";
        CqlTable table = bridge.buildSchema("CREATE TABLE " + keyspace + ".udt_test (\n    a uuid,\n    b bigint,\n    c frozen<a_udt>,\n    PRIMARY KEY(a));", keyspace, replicationFactor, Partitioner.Murmur3Partitioner, (Set)ImmutableSet.of((Object)("CREATE TYPE " + keyspace + ".a_udt (col1 bigint, col2 text, col3 frozen<map<uuid, b_udt>>);"), (Object)("CREATE TYPE " + keyspace + ".b_udt (col1 timeuuid, col2 text, col3 frozen<set<c_udt>>);"), (Object)("CREATE TYPE " + keyspace + ".c_udt (col1 float, col2 uuid, col3 int);")));
        Assertions.assertThat((Collection)table.udts()).hasSize(3);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testSchemaOfTableChanges(CassandraBridge bridge) {
        ReplicationFactor rf = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, MapUtils.mapOf((Object[])new Object[]{"DC1", 3}));
        String createStatement1 = "CREATE TABLE test_ks.test_tbl1 (a int PRIMARY KEY, b int);";
        CqlTable schema1 = bridge.buildSchema(createStatement1, "test_ks", rf, Partitioner.Murmur3Partitioner);
        Assertions.assertThat((List)schema1.fields()).hasSize(2);
        String createStatement2 = "CREATE TABLE test_ks.test_tbl2 (a int PRIMARY KEY, b int, c int);";
        CqlTable schema2 = bridge.buildSchema(createStatement2, "test_ks", rf, Partitioner.Murmur3Partitioner);
        Assertions.assertThat((List)schema2.fields()).hasSize(3);
        Assertions.assertThat((Object)schema1).isNotEqualTo((Object)schema2);
    }
}

