/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.cassandra.spark.common.Digest;
import org.apache.cassandra.spark.common.XXHash32Digest;
import org.apache.cassandra.spark.utils.MD5DigestAlgorithmTest;
import org.apache.cassandra.spark.utils.ResourceUtils;
import org.apache.cassandra.spark.utils.XXHash32DigestAlgorithm;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class XXHash32DigestAlgorithmTest {
    @TempDir
    private Path tempPath;

    XXHash32DigestAlgorithmTest() {
    }

    @ParameterizedTest(name="{index} fileName={0} expectedDigest={1}")
    @CsvSource(value={"file1.txt,d76a44a5", "file2.txt,ef976cbe", "file3.txt,8321e1e"})
    void testXXHash32Provider(String fileName, String expectedXXHash32) throws IOException {
        ClassLoader classLoader = MD5DigestAlgorithmTest.class.getClassLoader();
        Path path = ResourceUtils.writeResourceToPath(classLoader, this.tempPath, "digest/" + fileName);
        Assertions.assertThat((Path)path).exists();
        Digest digest = new XXHash32DigestAlgorithm().calculateFileDigest(path);
        Assertions.assertThat((Object)digest).isInstanceOf(XXHash32Digest.class);
        XXHash32Digest xxHash32Digest = (XXHash32Digest)digest;
        Assertions.assertThat((String)xxHash32Digest.value()).isEqualTo(expectedXXHash32);
        Assertions.assertThat((String)xxHash32Digest.seedHex()).isEqualTo("0");
    }
}

