/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.fasterxml.jackson.core.util.BufferRecyclers;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.serializers.MarshalException;

public class Json {
    public static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    public static final ColumnIdentifier JSON_COLUMN_ID = new ColumnIdentifier("[json]", true);

    public static String quoteAsJsonString(String s2) {
        return new String(BufferRecyclers.getJsonStringEncoder().quoteAsString(s2));
    }

    public static Object decodeJson(String json) {
        try {
            return JSON_OBJECT_MAPPER.readValue(json, Object.class);
        }
        catch (IOException exc) {
            throw new MarshalException("Error decoding JSON string: " + exc.getMessage());
        }
    }

    public static Map<ColumnIdentifier, Term> parseJson(String jsonString, Collection<ColumnMetadata> expectedReceivers) {
        try {
            Map valueMap = (Map)JSON_OBJECT_MAPPER.readValue(jsonString, Map.class);
            if (valueMap == null) {
                throw new InvalidRequestException("Got null for INSERT JSON values");
            }
            Json.handleCaseSensitivity(valueMap);
            HashMap<ColumnIdentifier, Term> columnMap = new HashMap<ColumnIdentifier, Term>(expectedReceivers.size());
            for (ColumnSpecification columnSpecification : expectedReceivers) {
                if (!valueMap.containsKey(columnSpecification.name.toString())) continue;
                Object parsedJsonObject = valueMap.remove(columnSpecification.name.toString());
                if (parsedJsonObject == null) {
                    columnMap.put(columnSpecification.name, Constants.NULL_VALUE);
                    continue;
                }
                try {
                    columnMap.put(columnSpecification.name, columnSpecification.type.fromJSONObject(parsedJsonObject));
                }
                catch (MarshalException exc) {
                    throw new InvalidRequestException(String.format("Error decoding JSON value for %s: %s", columnSpecification.name, exc.getMessage()));
                }
            }
            if (!valueMap.isEmpty()) {
                throw new InvalidRequestException(String.format("JSON values map contains unrecognized column: %s", valueMap.keySet().iterator().next()));
            }
            return columnMap;
        }
        catch (IOException exc) {
            throw new InvalidRequestException(String.format("Could not decode JSON string as a map: %s. (String was: %s)", exc.toString(), jsonString));
        }
        catch (MarshalException exc) {
            throw new InvalidRequestException(exc.getMessage());
        }
    }

    public static void handleCaseSensitivity(Map<String, Object> valueMap) {
        for (String mapKey : new ArrayList<String>(valueMap.keySet())) {
            if (mapKey.startsWith("\"") && mapKey.endsWith("\"")) {
                valueMap.put(mapKey.substring(1, mapKey.length() - 1), valueMap.remove(mapKey));
                continue;
            }
            String lowered = mapKey.toLowerCase(Locale.US);
            if (mapKey.equals(lowered)) continue;
            valueMap.put(lowered, valueMap.remove(mapKey));
        }
    }

    private static class DelayedColumnValue
    extends Term.NonTerminal {
        private final PreparedMarker marker;
        private final ColumnMetadata column;
        private final boolean defaultUnset;

        public DelayedColumnValue(PreparedMarker prepared, ColumnMetadata column, boolean defaultUnset) {
            this.marker = prepared;
            this.column = column;
            this.defaultUnset = defaultUnset;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
        }

        @Override
        public boolean containsBindMarker() {
            return true;
        }

        @Override
        public Term.Terminal bind(QueryOptions options) throws InvalidRequestException {
            Term term = options.getJsonColumnValue(this.marker.bindIndex, this.column.name, this.marker.columns);
            return term == null ? (this.defaultUnset ? Constants.UNSET_VALUE : null) : term.bind(options);
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
        }
    }

    private static class RawDelayedColumnValue
    extends Term.Raw {
        private final PreparedMarker marker;
        private final ColumnMetadata column;
        private final boolean defaultUnset;

        public RawDelayedColumnValue(PreparedMarker prepared, ColumnMetadata column, boolean defaultUnset) {
            this.marker = prepared;
            this.column = column;
            this.defaultUnset = defaultUnset;
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            return new DelayedColumnValue(this.marker, this.column, this.defaultUnset);
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return null;
        }

        @Override
        public String getText() {
            return this.marker.toString();
        }
    }

    private static class ColumnValue
    extends Term.Raw {
        private final Term term;

        public ColumnValue(Term term) {
            this.term = term;
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            return this.term;
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return null;
        }

        @Override
        public String getText() {
            return this.term.toString();
        }
    }

    private static class PreparedMarker
    extends Prepared {
        private final int bindIndex;
        private final Collection<ColumnMetadata> columns;

        public PreparedMarker(int bindIndex, Collection<ColumnMetadata> columns) {
            this.bindIndex = bindIndex;
            this.columns = columns;
        }

        @Override
        public RawDelayedColumnValue getRawTermForColumn(ColumnMetadata def, boolean defaultUnset) {
            return new RawDelayedColumnValue(this, def, defaultUnset);
        }
    }

    private static class PreparedLiteral
    extends Prepared {
        private final Map<ColumnIdentifier, Term> columnMap;

        public PreparedLiteral(Map<ColumnIdentifier, Term> columnMap) {
            this.columnMap = columnMap;
        }

        @Override
        public Term.Raw getRawTermForColumn(ColumnMetadata def, boolean defaultUnset) {
            Term value = this.columnMap.get(def.name);
            return value == null ? (defaultUnset ? Constants.UNSET_LITERAL : Constants.NULL_LITERAL) : new ColumnValue(value);
        }
    }

    public static abstract class Prepared {
        public abstract Term.Raw getRawTermForColumn(ColumnMetadata var1, boolean var2);
    }

    public static class Marker
    implements Raw {
        protected final int bindIndex;

        public Marker(int bindIndex) {
            this.bindIndex = bindIndex;
        }

        @Override
        public Prepared prepareAndCollectMarkers(TableMetadata metadata, Collection<ColumnMetadata> receivers, VariableSpecifications boundNames) {
            boundNames.add(this.bindIndex, this.makeReceiver(metadata));
            return new PreparedMarker(this.bindIndex, receivers);
        }

        private ColumnSpecification makeReceiver(TableMetadata metadata) {
            return new ColumnSpecification(metadata.keyspace, metadata.name, JSON_COLUMN_ID, UTF8Type.instance);
        }
    }

    public static class Literal
    implements Raw {
        private final String text;

        public Literal(String text) {
            this.text = text;
        }

        @Override
        public Prepared prepareAndCollectMarkers(TableMetadata metadata, Collection<ColumnMetadata> receivers, VariableSpecifications boundNames) {
            return new PreparedLiteral(Json.parseJson(this.text, receivers));
        }
    }

    public static interface Raw {
        public Prepared prepareAndCollectMarkers(TableMetadata var1, Collection<ColumnMetadata> var2, VariableSpecifications var3);
    }
}

