/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.cassandra.net.BufferPoolAllocator;
import org.apache.cassandra.net.FrameDecoder;
import org.apache.cassandra.net.FrameDecoderLegacy;
import org.apache.cassandra.net.ShareableBytes;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.memory.BufferPool;
import org.apache.cassandra.utils.memory.BufferPools;

class FrameDecoderLegacyLZ4
extends FrameDecoderLegacy {
    private static final BufferPool bufferPool = BufferPools.forNetworking();

    FrameDecoderLegacyLZ4(BufferPoolAllocator allocator, int messagingVersion) {
        super(allocator, messagingVersion);
    }

    @Override
    void addLastTo(ChannelPipeline pipeline) {
        pipeline.addLast("legacyLZ4Decoder", (ChannelHandler)new LZ4Decoder(this.allocator));
        pipeline.addLast("frameDecoderNone", (ChannelHandler)this);
    }

    private static class LZ4Decoder
    extends ChannelInboundHandlerAdapter {
        private static final XXHash32 xxhash = XXHashFactory.fastestInstance().hash32();
        private static final LZ4SafeDecompressor decompressor = LZ4Factory.fastestInstance().safeDecompressor();
        private final BufferPoolAllocator allocator;
        private final Deque<ShareableBytes> frames = new ArrayDeque<ShareableBytes>(4);
        private int decodedFrameCount = 0;
        private final Header header = new Header();
        private ByteBuffer stash;

        LZ4Decoder(BufferPoolAllocator allocator) {
            this.allocator = allocator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws CorruptLZ4Frame {
            assert (msg instanceof BufferPoolAllocator.Wrapped);
            ByteBuffer buf = ((BufferPoolAllocator.Wrapped)msg).adopt();
            bufferPool.putUnusedPortion(buf);
            CorruptLZ4Frame error = null;
            try {
                this.decode(this.frames, ShareableBytes.wrap(buf));
            }
            catch (CorruptLZ4Frame e) {
                error = e;
            }
            finally {
                this.decodedFrameCount += this.frames.size();
                while (!this.frames.isEmpty()) {
                    ctx.fireChannelRead(this.frames.poll());
                }
            }
            if (null != error) {
                throw error;
            }
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext ctx) {
            if (null != this.stash && this.decodedFrameCount == 0 && !ctx.channel().config().isAutoRead()) {
                ctx.read();
            }
            this.decodedFrameCount = 0;
            ctx.fireChannelReadComplete();
        }

        private void decode(Collection<ShareableBytes> into, ShareableBytes newBytes) throws CorruptLZ4Frame {
            try {
                this.doDecode(into, newBytes);
            }
            finally {
                newBytes.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doDecode(Collection<ShareableBytes> into, ShareableBytes newBytes) throws CorruptLZ4Frame {
            int frameLength;
            ByteBuffer in = newBytes.get();
            if (null != this.stash) {
                if (!FrameDecoder.copyToSize(in, this.stash, 21)) {
                    return;
                }
                this.header.read(this.stash, 0);
                this.header.validate();
                int frameLength2 = this.header.frameLength();
                this.stash = this.ensureCapacity(this.stash, frameLength2);
                if (!FrameDecoder.copyToSize(in, this.stash, frameLength2)) {
                    return;
                }
                this.stash.flip();
                ShareableBytes stashed = ShareableBytes.wrap(this.stash);
                this.stash = null;
                try {
                    into.add(this.decompressFrame(stashed, 0, frameLength2, this.header));
                }
                finally {
                    stashed.release();
                }
            }
            int limit = in.limit();
            for (int begin = in.position(); begin < limit; begin += frameLength) {
                int remaining = limit - begin;
                if (remaining < 21) {
                    this.stash(newBytes, 21, begin, remaining);
                    return;
                }
                this.header.read(in, begin);
                this.header.validate();
                frameLength = this.header.frameLength();
                if (remaining < frameLength) {
                    this.stash(newBytes, frameLength, begin, remaining);
                    return;
                }
                into.add(this.decompressFrame(newBytes, begin, begin + frameLength, this.header));
            }
        }

        private ShareableBytes decompressFrame(ShareableBytes bytes, int begin, int end, Header header) throws CorruptLZ4Frame {
            ByteBuffer buf = bytes.get();
            if (header.uncompressedLength == 0) {
                return bytes.slice(begin + 21, end);
            }
            if (!header.isCompressed()) {
                this.validateChecksum(buf, begin + 21, header);
                return bytes.slice(begin + 21, end);
            }
            ByteBuffer out = this.allocator.get(header.uncompressedLength);
            try {
                int sourceLength = end - (begin + 21);
                decompressor.decompress(buf, begin + 21, sourceLength, out, 0, header.uncompressedLength);
                this.validateChecksum(out, 0, header);
                return ShareableBytes.wrap(out);
            }
            catch (Throwable t) {
                bufferPool.put(out);
                throw t;
            }
        }

        private void validateChecksum(ByteBuffer buf, int begin, Header header) throws CorruptLZ4Frame {
            int checksum = xxhash.hash(buf, begin, header.uncompressedLength, -1756908916) & 0xFFFFFFF;
            if (checksum != header.checksum) {
                LZ4Decoder.except("Invalid checksum detected: %d (expected: %d)", checksum, header.checksum);
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            if (null != this.stash) {
                bufferPool.put(this.stash);
                this.stash = null;
            }
            while (!this.frames.isEmpty()) {
                this.frames.poll().release();
            }
            ctx.fireChannelInactive();
        }

        private ByteBuffer ensureCapacity(ByteBuffer in, int capacity) {
            if (in.capacity() >= capacity) {
                return in;
            }
            ByteBuffer out = this.allocator.getAtLeast(capacity);
            in.flip();
            out.put(in);
            bufferPool.put(in);
            return out;
        }

        private void stash(ShareableBytes in, int stashLength, int begin, int length) {
            ByteBuffer out = this.allocator.getAtLeast(stashLength);
            ByteBufferUtil.copyBytes(in.get(), begin, out, 0, length);
            out.position(length);
            this.stash = out;
        }

        private static void except(String format, Object ... args) throws CorruptLZ4Frame {
            throw new CorruptLZ4Frame(String.format(format, args));
        }

        static final class CorruptLZ4Frame
        extends IOException {
            CorruptLZ4Frame(String message) {
                super(message);
            }
        }

        private static final class Header {
            long magicNumber;
            byte token;
            int compressedLength;
            int uncompressedLength;
            int checksum;

            private Header() {
            }

            int frameLength() {
                return 21 + this.compressedLength;
            }

            boolean isCompressed() {
                return (this.token & 0xF0) == 32;
            }

            int maxUncompressedLength() {
                return 1 << (this.token & 0xF) + 10;
            }

            void read(ByteBuffer in, int begin) {
                this.magicNumber = in.getLong(begin + 0);
                this.token = in.get(begin + 8);
                this.compressedLength = Integer.reverseBytes(in.getInt(begin + 9));
                this.uncompressedLength = Integer.reverseBytes(in.getInt(begin + 13));
                this.checksum = Integer.reverseBytes(in.getInt(begin + 17));
            }

            void validate() throws CorruptLZ4Frame {
                int blockType;
                if (this.magicNumber != 5501767354678207339L) {
                    LZ4Decoder.except("Invalid magic number at the beginning of an LZ4 block: %d", new Object[]{this.magicNumber});
                }
                if ((blockType = this.token & 0xF0) != 32 && blockType != 16) {
                    LZ4Decoder.except("Invalid block type encountered: %d", new Object[]{blockType});
                }
                if (this.compressedLength < 0 || this.compressedLength > 0x2000000) {
                    LZ4Decoder.except("Invalid compressedLength: %d (expected: 0-%d)", new Object[]{this.compressedLength, 0x2000000});
                }
                if (this.uncompressedLength < 0 || this.uncompressedLength > this.maxUncompressedLength()) {
                    LZ4Decoder.except("Invalid uncompressedLength: %d (expected: 0-%d)", new Object[]{this.uncompressedLength, this.maxUncompressedLength()});
                }
                if (this.uncompressedLength == 0 && this.compressedLength != 0 || this.uncompressedLength != 0 && this.compressedLength == 0 || !this.isCompressed() && this.uncompressedLength != this.compressedLength) {
                    LZ4Decoder.except("Stream corrupted: compressedLength(%d) and decompressedLength(%d) mismatch", new Object[]{this.compressedLength, this.uncompressedLength});
                }
            }
        }
    }
}

