/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.jfr6.parser;

import com.oracle.jmc.common.IMCFrame;
import com.oracle.jmc.common.IMCStackTrace;
import com.oracle.jmc.common.IMCThread;
import com.oracle.jmc.common.IMCType;
import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.Attribute;
import com.oracle.jmc.common.item.IAccessorFactory;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.LinearKindOfQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.internal.EventArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEventPojo;
import org.gridkit.jvmtool.codec.stacktrace.ThreadTraceEvent;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventMorpher;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.event.GenericEvent;
import org.gridkit.jvmtool.event.MorphingEventReader;
import org.gridkit.jvmtool.event.SimpleErrorEvent;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameArray;
import org.gridkit.jvmtool.stacktrace.StackFrameList;

public class JfrEventAdapter
implements EventReader<Event> {
    private static final String EXECUTION_SAMPLING = "com.oracle.jdk.ExecutionSample";
    private static final String ALLOCATION_IN_NEW_TLAB = "com.oracle.jdk.ObjectAllocationInNewTLAB";
    private static final IAccessorFactory<IMCType> ATTR_OBJECT_CLASS = Attribute.attr((String)"objectClass", (ContentType)UnitLookup.CLASS);
    private static final IAccessorFactory<IQuantity> ATTR_ALLOC_SIZE = Attribute.attr((String)"allocationSize", (ContentType)new LinearKindOfQuantity("memory", "byte"));
    private static final IAccessorFactory<IQuantity> ATTR_TLAB_SIZE = Attribute.attr((String)"tlabSize", (ContentType)new LinearKindOfQuantity("memory", "byte"));
    private static final List<String> EVENTS = Arrays.asList("com.oracle.jdk.ExecutionSample", "com.oracle.jdk.ObjectAllocationInNewTLAB");
    private final Iterator<IItem> it;
    private ThreadSnapshotEventPojo threadPojo = new ThreadSnapshotEventPojo();
    private NewTLABEventPojo allocPojo = new NewTLABEventPojo();
    private Event event = null;
    private boolean error;
    private EventAttr<IQuantity> E_TIMESTAMP = new EventAttr(JfrAttributes.EVENT_TIMESTAMP);
    private EventAttr<IMCThread> E_THREAD = new EventAttr(JfrAttributes.EVENT_THREAD);
    private EventAttr<IMCStackTrace> E_STACK_TRACE = new EventAttr(JfrAttributes.EVENT_STACKTRACE);
    private EventAttr<IMCType> E_OBJECT_CLASS = new EventAttr<IMCType>(ATTR_OBJECT_CLASS);
    private EventAttr<IQuantity> E_ALLOC_SIZE = new EventAttr<IQuantity>(ATTR_ALLOC_SIZE);
    private EventAttr<IQuantity> E_NEW_TLAB_SIZE = new EventAttr<IQuantity>(ATTR_TLAB_SIZE);

    public JfrEventAdapter(EventArray[] recording) {
        ArrayList<IItem> events = new ArrayList<IItem>();
        for (EventArray ea : recording) {
            if (!EVENTS.contains(ea.getType().getIdentifier())) continue;
            events.addAll(Arrays.asList(ea.getEvents()));
        }
        this.it = events.iterator();
    }

    @Override
    public Iterator<Event> iterator() {
        return this;
    }

    private void seek() {
        if (this.error) {
            return;
        }
        try {
            while (this.it.hasNext()) {
                IItem e = this.it.next();
                if (EXECUTION_SAMPLING.equals(e.getType().getIdentifier())) {
                    this.event = this.parseMethodSamplingEvent(e);
                    return;
                }
                if (!ALLOCATION_IN_NEW_TLAB.equals(e.getType().getIdentifier())) continue;
                this.event = this.parseAllocationEvent(e);
            }
        }
        catch (Exception e) {
            this.event = new SimpleErrorEvent(e);
            this.error = true;
        }
    }

    private Event parseMethodSamplingEvent(IItem e) {
        this.threadPojo.timestamp(this.timestamp(e));
        IMCThread thread = this.thread(e);
        if (thread != null) {
            this.threadPojo.threadId(thread.getThreadId());
            this.threadPojo.threadName(thread.getThreadName());
        } else {
            this.threadPojo.threadId(-1L);
            this.threadPojo.threadName(null);
        }
        IMCStackTrace flrStackTrace = this.stacktrace(e);
        if (flrStackTrace != null) {
            this.threadPojo.stackTrace(this.trace(flrStackTrace));
        } else {
            this.threadPojo.stackTrace(null);
        }
        return this.threadPojo;
    }

    private Event parseAllocationEvent(IItem e) {
        IMCStackTrace flrStackTrace;
        this.allocPojo.counters().clear();
        this.allocPojo.tags().clear();
        this.allocPojo.tags().put("jfr.event", "");
        this.allocPojo.tags().put("jfr.event.type", e.getType().getIdentifier());
        this.allocPojo.tags().put("jfr.event.name", e.getType().getName());
        this.allocPojo.timestamp(this.timestamp(e));
        IMCThread thread = this.thread(e);
        if (thread != null) {
            this.allocPojo.counters().set("jfr.threadId", thread.getThreadId());
            this.allocPojo.tags().put("jfr.threadName", thread.getThreadName());
        }
        if ((flrStackTrace = this.stacktrace(e)) != null) {
            this.allocPojo.stackTrace(this.trace(flrStackTrace));
        } else {
            this.allocPojo.stackTrace(null);
        }
        IMCType type = this.allocatedType(e);
        if (type != null) {
            this.allocPojo.tags().put("jfr.allocClass", type.getFullName());
        }
        this.allocPojo.counters().set("jfr.allocationSize", this.allocationSize(e));
        this.allocPojo.counters().set("jfr.tlabSize", this.newTlabSize(e));
        return this.allocPojo;
    }

    private long timestamp(IItem e) {
        IQuantity qty = this.E_TIMESTAMP.get(e);
        return TimeUnit.NANOSECONDS.toMillis(qty.longValue());
    }

    private IMCThread thread(IItem e) {
        IMCThread thread = this.E_THREAD.get(e);
        return thread;
    }

    private IMCStackTrace stacktrace(IItem e) {
        IMCStackTrace trace = this.E_STACK_TRACE.get(e);
        return trace;
    }

    private IMCType allocatedType(IItem e) {
        return this.E_OBJECT_CLASS.get(e);
    }

    private long allocationSize(IItem e) {
        return this.E_ALLOC_SIZE.get(e).longValue();
    }

    private long newTlabSize(IItem e) {
        return this.E_NEW_TLAB_SIZE.get(e).longValue();
    }

    private StackFrameList trace(IMCStackTrace trace) {
        StackFrame[] t = new StackFrame[trace.getFrames().size()];
        for (int i = 0; i != t.length; ++i) {
            t[i] = this.frame((IMCFrame)trace.getFrames().get(i));
        }
        return new StackFrameArray(t);
    }

    private StackFrame frame(IMCFrame f) {
        String src;
        int line;
        String pn = f.getMethod().getType().getPackageName();
        String cn = f.getMethod().getType().getTypeName();
        String mn = f.getMethod().getMethodName();
        int n = line = f.getFrameLineNumber() == null ? -1 : f.getFrameLineNumber();
        if (Boolean.TRUE.equals(f.getMethod().isNative())) {
            line = -2;
        }
        if ((src = null) == null && line >= 0) {
            src = "line";
        }
        return new StackFrame(pn, cn, mn, src, line);
    }

    @Override
    public boolean hasNext() {
        if (this.event == null) {
            this.seek();
        }
        return this.event != null;
    }

    @Override
    public Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Event e = this.event;
        this.event = null;
        return e;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <M extends Event> EventReader<M> morph(EventMorpher<Event, M> morpher) {
        return new MorphingEventReader<M>(this, morpher);
    }

    @Override
    public Event peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.event;
    }

    @Override
    public void dispose() {
    }

    private static class NewTLABEventPojo
    extends GenericEvent
    implements ThreadTraceEvent {
        private StackFrameList trace;

        private NewTLABEventPojo() {
        }

        @Override
        public StackFrameList stackTrace() {
            return this.trace;
        }

        public void stackTrace(StackFrameList trace) {
            this.trace = trace;
        }
    }

    private class EventAttr<T> {
        private final IAccessorFactory<T> factory;
        private IType<?> lastType;
        private IMemberAccessor<T, IItem> lastKey;

        public EventAttr(IAccessorFactory<T> factory) {
            this.factory = factory;
        }

        public T get(IItem item) {
            if (item.getType() != this.lastType) {
                this.lastKey = this.factory.getAccessor(item.getType());
            }
            return (T)this.lastKey.getMember((Object)item);
        }
    }
}

