/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder;

import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.item.Attribute;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.MemberAccessorToolkit;
import org.openjdk.jmc.flightrecorder.messages.internal.Messages;

public interface JfrAttributes {
    public static final IAttribute<IType<?>> EVENT_TYPE = Attribute.canonicalize(new Attribute<IType<?>>("(eventType)", Messages.getString("ATTR_EVENT_TYPE"), Messages.getString("ATTR_EVENT_TYPE_DESC"), (ContentType)UnitLookup.TYPE){

        @Override
        public <U> IMemberAccessor<IType<?>, U> customAccessor(IType<U> type) {
            return MemberAccessorToolkit.constant(type);
        }
    });
    public static final IAttribute<String> EVENT_TYPE_ID = Attribute.canonicalize(new Attribute<String>("(eventTypeId)", Messages.getString("ATTR_EVENT_TYPE_ID"), Messages.getString("ATTR_EVENT_TYPE_ID_DESC"), UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            return MemberAccessorToolkit.constant(type.getIdentifier());
        }
    });
    public static final IAttribute<IQuantity> END_TIME = Attribute.canonicalize(new Attribute<IQuantity>("(endTime)", Messages.getString("ATTR_END_TIME"), null, UnitLookup.TIMESTAMP){

        @Override
        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            IMemberAccessor stAccessor = type.getAccessor(START_TIME.getKey());
            IMemberAccessor durationAccessor = type.getAccessor(DURATION.getKey());
            if (stAccessor != null && durationAccessor != null) {
                return MemberAccessorToolkit.sum(stAccessor, durationAccessor);
            }
            return stAccessor;
        }
    });
    public static final IAttribute<IQuantity> START_TIME = Attribute.canonicalize(new Attribute<IQuantity>("startTime", Messages.getString("ATTR_START_TIME"), null, UnitLookup.TIMESTAMP){

        @Override
        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            IMemberAccessor etAccessor = type.getAccessor(END_TIME.getKey());
            IMemberAccessor durationAccessor = type.getAccessor(DURATION.getKey());
            if (etAccessor != null && durationAccessor != null) {
                return MemberAccessorToolkit.difference(etAccessor, durationAccessor);
            }
            return etAccessor;
        }
    });
    public static final IAttribute<IQuantity> DURATION = Attribute.canonicalize(new Attribute<IQuantity>("duration", Messages.getString("ATTR_DURATION"), null, (ContentType)UnitLookup.TIMESPAN){

        @Override
        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            IMemberAccessor etAccessor = type.getAccessor(END_TIME.getKey());
            IMemberAccessor stAccessor = type.getAccessor(START_TIME.getKey());
            if (etAccessor == null || stAccessor == null || etAccessor == stAccessor) {
                return MemberAccessorToolkit.constant(UnitLookup.SECOND.quantity(0L));
            }
            return MemberAccessorToolkit.difference(etAccessor, stAccessor);
        }
    });
    public static final IAttribute<IQuantity> CENTER_TIME = Attribute.canonicalize(new Attribute<IQuantity>("(centerTime)", Messages.getString("ATTR_CENTER_TIME"), null, UnitLookup.TIMESTAMP){

        @Override
        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            IMemberAccessor stAccessor = type.getAccessor(START_TIME.getKey());
            IMemberAccessor etAccessor = type.getAccessor(END_TIME.getKey());
            IMemberAccessor durationAccessor = type.getAccessor(DURATION.getKey());
            if (stAccessor != null) {
                if (durationAccessor != null) {
                    return MemberAccessorToolkit.addHalfDelta(stAccessor, durationAccessor);
                }
                if (etAccessor != null) {
                    return MemberAccessorToolkit.avg(stAccessor, etAccessor);
                }
                return stAccessor;
            }
            if (etAccessor != null) {
                if (durationAccessor != null) {
                    return MemberAccessorToolkit.subtractHalfDelta(etAccessor, durationAccessor);
                }
                return etAccessor;
            }
            return null;
        }
    });
    public static final IAttribute<IRange<IQuantity>> LIFETIME = Attribute.canonicalize(new Attribute<IRange<IQuantity>>("(lifetime)", Messages.getString("ATTR_LIFETIME"), null, UnitLookup.TIMERANGE){

        @Override
        public <U> IMemberAccessor<IRange<IQuantity>, U> customAccessor(IType<U> type) {
            IMemberAccessor stAccessor = type.getAccessor(START_TIME.getKey());
            IMemberAccessor etAccessor = type.getAccessor(END_TIME.getKey());
            IMemberAccessor durationAccessor = type.getAccessor(DURATION.getKey());
            if (stAccessor != null) {
                if (durationAccessor != null) {
                    return MemberAccessorToolkit.rangeWithExtent(stAccessor, durationAccessor);
                }
                if (etAccessor != null) {
                    return MemberAccessorToolkit.rangeWithEnd(stAccessor, etAccessor);
                }
                return MemberAccessorToolkit.pointRange(stAccessor);
            }
            if (etAccessor != null) {
                if (durationAccessor != null) {
                    return MemberAccessorToolkit.rangeWithExtentEnd(durationAccessor, etAccessor);
                }
                return MemberAccessorToolkit.pointRange(etAccessor);
            }
            return null;
        }
    });
    public static final IAttribute<IMCStackTrace> EVENT_STACKTRACE = Attribute.attr("stackTrace", Messages.getString("ATTR_EVENT_STACKTRACE"), UnitLookup.STACKTRACE);
    public static final IAttribute<IMCThread> EVENT_THREAD = Attribute.attr("eventThread", Messages.getString("ATTR_EVENT_THREAD"), Messages.getString("ATTR_EVENT_THREAD_DESC"), UnitLookup.THREAD);
    public static final IAttribute<IQuantity> EVENT_TIMESTAMP = Attribute.attr(END_TIME.getIdentifier(), Messages.getString("ATTR_EVENT_TIMESTAMP"), Messages.getString("ATTR_EVENT_TIMESTAMP_DESC"), END_TIME.getContentType());
    public static final IAttribute<IQuantity> FLR_DATA_LOST = Attribute.attr("amount", Messages.getString("ATTR_FLR_DATA_LOST"), Messages.getString("ATTR_FLR_DATA_LOST_DESC"), UnitLookup.MEMORY);
}

