/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.querybuilder.BuildableQuery;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTypeRenameField;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTypeRenameFieldEnd;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTypeStart;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultAlterType
implements AlterTypeStart,
AlterTypeRenameField,
AlterTypeRenameFieldEnd,
BuildableQuery {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier typeName;
    private final CqlIdentifier fieldToAdd;
    private final DataType fieldToAddType;
    private final ImmutableMap<CqlIdentifier, CqlIdentifier> fieldsToRename;
    private final CqlIdentifier fieldToAlter;
    private final DataType fieldToAlterType;

    public DefaultAlterType(@NonNull CqlIdentifier typeName) {
        this(null, typeName);
    }

    public DefaultAlterType(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier typeName) {
        this(keyspace, typeName, null, null, (ImmutableMap<CqlIdentifier, CqlIdentifier>)ImmutableMap.of(), null, null);
    }

    public DefaultAlterType(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier typeName, @Nullable CqlIdentifier fieldToAdd, @Nullable DataType fieldToAddType, @NonNull ImmutableMap<CqlIdentifier, CqlIdentifier> fieldsToRename, @Nullable CqlIdentifier fieldToAlter, @Nullable DataType fieldToAlterType) {
        this.keyspace = keyspace;
        this.typeName = typeName;
        this.fieldToAdd = fieldToAdd;
        this.fieldToAddType = fieldToAddType;
        this.fieldsToRename = fieldsToRename;
        this.fieldToAlter = fieldToAlter;
        this.fieldToAlterType = fieldToAlterType;
    }

    @Override
    @NonNull
    public BuildableQuery alterField(@NonNull CqlIdentifier fieldName, @NonNull DataType dataType) {
        return new DefaultAlterType(this.keyspace, this.typeName, this.fieldToAdd, this.fieldToAddType, this.fieldsToRename, fieldName, dataType);
    }

    @Override
    @NonNull
    public BuildableQuery addField(@NonNull CqlIdentifier fieldName, @NonNull DataType dataType) {
        return new DefaultAlterType(this.keyspace, this.typeName, fieldName, dataType, this.fieldsToRename, this.fieldToAlter, this.fieldToAlterType);
    }

    @Override
    @NonNull
    public AlterTypeRenameFieldEnd renameField(@NonNull CqlIdentifier from, @NonNull CqlIdentifier to) {
        return new DefaultAlterType(this.keyspace, this.typeName, this.fieldToAdd, this.fieldToAddType, ImmutableCollections.append(this.fieldsToRename, from, to), this.fieldToAlter, this.fieldToAlterType);
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder("ALTER TYPE ");
        CqlHelper.qualify(this.keyspace, this.typeName, builder);
        if (this.fieldToAlter != null) {
            return builder.append(" ALTER ").append(this.fieldToAlter.asCql(true)).append(" TYPE ").append(this.fieldToAlterType.asCql(true, true)).toString();
        }
        if (this.fieldToAdd != null) {
            return builder.append(" ADD ").append(this.fieldToAdd.asCql(true)).append(" ").append(this.fieldToAddType.asCql(true, true)).toString();
        }
        if (!this.fieldsToRename.isEmpty()) {
            builder.append(" RENAME ");
            boolean first = true;
            for (Map.Entry entry : this.fieldsToRename.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(" AND ");
                }
                builder.append(((CqlIdentifier)entry.getKey()).asCql(true)).append(" TO ").append(((CqlIdentifier)entry.getValue()).asCql(true));
            }
            return builder.toString();
        }
        return builder.toString();
    }

    public String toString() {
        return this.asCql();
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getType() {
        return this.typeName;
    }

    @Nullable
    public CqlIdentifier getFieldToAdd() {
        return this.fieldToAdd;
    }

    @Nullable
    public DataType getFieldToAddType() {
        return this.fieldToAddType;
    }

    @NonNull
    public ImmutableMap<CqlIdentifier, CqlIdentifier> getFieldsToRename() {
        return this.fieldsToRename;
    }

    @Nullable
    public CqlIdentifier getFieldToAlter() {
        return this.fieldToAlter;
    }

    @Nullable
    public DataType getFieldToAlterType() {
        return this.fieldToAlterType;
    }
}

