/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.IncrementalFaultList;
import org.apache.cayenne.access.MixedResultIncrementalFaultList;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.ObjectsFromDataRowsQuery;
import org.apache.cayenne.access.SimpleIdIncrementalFaultList;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.util.ListResponse;
import org.apache.cayenne.util.ObjectContextQueryAction;

class DataContextQueryAction
extends ObjectContextQueryAction {
    protected DataContext actingDataContext;

    public DataContextQueryAction(DataContext actingContext, ObjectContext targetContext, Query query) {
        super(actingContext, targetContext, query);
        this.actingDataContext = actingContext;
    }

    @Override
    protected boolean interceptInternalQuery() {
        return this.interceptObjectFromDataRowsQuery();
    }

    private boolean interceptObjectFromDataRowsQuery() {
        if (this.query instanceof ObjectsFromDataRowsQuery) {
            ObjectsFromDataRowsQuery objectsFromDataRowsQuery = (ObjectsFromDataRowsQuery)this.query;
            this.response = new ListResponse(this.actingDataContext.objectsFromDataRows(objectsFromDataRowsQuery.getDescriptor(), objectsFromDataRowsQuery.getDataRows()));
            return true;
        }
        return false;
    }

    @Override
    protected boolean interceptOIDQuery() {
        Object object;
        ObjectIdQuery oidQuery;
        if (this.query instanceof ObjectIdQuery && !(oidQuery = (ObjectIdQuery)this.query).isFetchMandatory() && (object = this.polymorphicObjectFromCache(oidQuery.getObjectId())) != null) {
            if (oidQuery.isFetchingDataRows()) {
                object = this.actingDataContext.currentSnapshot((Persistent)object);
            } else if (((Persistent)object).getPersistenceState() == 5) {
                return false;
            }
            this.response = new ListResponse(object);
            return true;
        }
        return false;
    }

    @Override
    protected boolean interceptPaginatedQuery() {
        if (this.metadata.getPageSize() > 0) {
            DbEntity dbEntity;
            Integer maxIdQualifierSize = this.actingDataContext.getParentDataDomain().getMaxIdQualifierSize();
            List<Object> rsMapping = this.metadata.getResultSetMapping();
            boolean mixedResults = false;
            if (rsMapping != null) {
                if (rsMapping.size() > 1) {
                    mixedResults = true;
                } else if (rsMapping.size() == 1) {
                    boolean bl = mixedResults = !(rsMapping.get(0) instanceof EntityResultSegment) || !this.metadata.isSingleResultSetMapping();
                }
            }
            IncrementalFaultList paginatedList = mixedResults ? new MixedResultIncrementalFaultList(this.actingDataContext, this.query, maxIdQualifierSize) : ((dbEntity = this.metadata.getDbEntity()) != null && dbEntity.getPrimaryKeys().size() == 1 ? new SimpleIdIncrementalFaultList(this.actingDataContext, this.query, maxIdQualifierSize) : new IncrementalFaultList(this.actingDataContext, this.query, maxIdQualifierSize));
            this.response = new ListResponse(paginatedList);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean interceptRefreshQuery() {
        if (this.query instanceof RefreshQuery) {
            RefreshQuery refreshQuery = (RefreshQuery)this.query;
            DataContext context = (DataContext)this.actingContext;
            if (refreshQuery.isRefreshAll()) {
                ObjectStore objectStore = context.getObjectStore();
                synchronized (objectStore) {
                    this.invalidateLocally(context.getObjectStore(), context.getObjectStore().getObjectIterator());
                    context.getQueryCache().clear();
                }
                return false;
            }
            Collection<?> objects = refreshQuery.getObjects();
            if (objects != null && !objects.isEmpty()) {
                ObjectStore objectStore = context.getObjectStore();
                synchronized (objectStore) {
                    this.invalidateLocally(context.getObjectStore(), objects.iterator());
                }
                return false;
            }
            Query cachedQuery = refreshQuery.getQuery();
            if (cachedQuery != null) {
                String cacheKey = cachedQuery.getMetaData(context.getEntityResolver()).getCacheKey();
                context.getQueryCache().remove(cacheKey);
                this.response = context.performGenericQuery(cachedQuery);
                return true;
            }
            String[] groups = refreshQuery.getGroupKeys();
            if (groups != null && groups.length > 0) {
                for (String group : groups) {
                    context.getQueryCache().removeGroup(group);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void invalidateLocally(ObjectStore objectStore, Iterator it) {
        Map<Object, ObjectDiff> diffMap = objectStore.getChangesByObjectId();
        while (it.hasNext()) {
            Persistent object = (Persistent)it.next();
            int state = object.getPersistenceState();
            if (state == 2) continue;
            if (state == 4 || state == 6) {
                diffMap.remove(object.getObjectId());
            }
            object.setPersistenceState(5);
        }
    }
}

