/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote;

import java.util.List;
import java.util.Map;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryMetadataProxy;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.reflect.ClassDescriptor;

class RangeQuery
implements Query {
    private String cacheKey;
    private int fetchOffset;
    private int fetchLimit;
    private Query originatingQuery;

    private RangeQuery() {
    }

    RangeQuery(String cacheKey, int fetchStartIndex, int fetchLimit, Query originatingQuery) {
        this.cacheKey = cacheKey;
        this.fetchOffset = fetchStartIndex;
        this.fetchLimit = fetchLimit;
        this.originatingQuery = originatingQuery;
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        QueryMetadata originatingMetadata = this.originatingQuery.getMetaData(resolver);
        return new QueryMetadataProxy(originatingMetadata){

            public Query getOriginatingQuery() {
                return RangeQuery.this.originatingQuery;
            }

            public List<Object> getResultSetMapping() {
                return null;
            }

            public boolean isSingleResultSetMapping() {
                return false;
            }

            public String getCacheKey() {
                return RangeQuery.this.cacheKey;
            }

            public String getCacheGroup() {
                return null;
            }

            public int getFetchOffset() {
                return RangeQuery.this.fetchOffset;
            }

            public int getFetchLimit() {
                return RangeQuery.this.fetchLimit;
            }

            public int getPageSize() {
                return 0;
            }

            public QueryCacheStrategy getCacheStrategy() {
                return QueryCacheStrategy.getDefaultStrategy();
            }

            public DataMap getDataMap() {
                throw new UnsupportedOperationException();
            }

            public DbEntity getDbEntity() {
                throw new UnsupportedOperationException();
            }

            public ObjEntity getObjEntity() {
                throw new UnsupportedOperationException();
            }

            public ClassDescriptor getClassDescriptor() {
                throw new UnsupportedOperationException();
            }

            public Procedure getProcedure() {
                throw new UnsupportedOperationException();
            }

            public Map<String, String> getPathSplitAliases() {
                throw new UnsupportedOperationException();
            }

            public boolean isRefreshingObjects() {
                throw new UnsupportedOperationException();
            }

            public int getStatementFetchSize() {
                return 0;
            }
        };
    }

    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        throw new UnsupportedOperationException();
    }

    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        throw new UnsupportedOperationException();
    }
}

