/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEndpoint;
import org.apache.celeborn.common.rpc.RpcMetricsTracker;
import org.apache.celeborn.common.rpc.ThreadSafeRpcEndpoint;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.InboxMessage;
import org.apache.celeborn.common.rpc.netty.NettyRpcCallContext;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.OnStart$;
import org.apache.celeborn.common.rpc.netty.OnStop$;
import org.apache.celeborn.common.rpc.netty.OneWayMessage;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnected;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnectionError;
import org.apache.celeborn.common.rpc.netty.RemoteProcessDisconnected;
import org.apache.celeborn.common.rpc.netty.RpcMessage;
import org.apache.celeborn.common.rpc.netty.RpcTimeMetrics$;
import org.apache.celeborn.common.rpc.netty.RpcTimeMetrics$Dequeue$;
import org.apache.celeborn.common.rpc.netty.RpcTimeMetrics$Enqueue$;
import org.apache.celeborn.common.rpc.netty.RpcTimeMetrics$Process$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005eg!\u0002\u0015*\u0001=*\u0004\u0002\u0003\"\u0001\u0005\u000b\u0007I\u0011\u0001#\t\u0011%\u0003!\u0011!Q\u0001\n\u0015C\u0001B\u0013\u0001\u0003\u0006\u0004%\ta\u0013\u0005\t!\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0011\u000b\u0001BC\u0002\u0013\u0005!\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003T\u0011!A\u0006A!b\u0001\n\u0003I\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u000by\u0003A\u0011A0\t\u0011\u0015\u0004!\u0019!C\u0001S\u0019DaA\u001b\u0001!\u0002\u00139\u0007\u0002C6\u0001\u0005\u0004%\t!\u000b7\t\re\u0004\u0001\u0015!\u0003n\u0011!Q\bA1A\u0005\u0002%Z\bBB@\u0001A\u0003%A\u0010C\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0005\u0002\u0004!A\u00111\u0003\u0001!\u0002\u0013\t)\u0001C\u0005\u00020\u0001\u0011\r\u0011\"\u0003\u00022!A\u0011q\b\u0001!\u0002\u0013\t\u0019\u0004C\u0005\u0002B\u0001\u0001\r\u0011\"\u0003\u0002D!I\u00111\n\u0001A\u0002\u0013%\u0011Q\n\u0005\t\u00033\u0002\u0001\u0015)\u0003\u0002F!I\u0011Q\f\u0001A\u0002\u0013%\u00111\t\u0005\n\u0003?\u0002\u0001\u0019!C\u0005\u0003CB\u0001\"!\u001a\u0001A\u0003&\u0011Q\t\u0005\t\u0003S\u0002\u0001\u0019!C\u0005M\"I\u00111\u000e\u0001A\u0002\u0013%\u0011Q\u000e\u0005\b\u0003c\u0002\u0001\u0015)\u0003h\u0011\u001d\t)\b\u0001C\u0001\u0003oBq!! \u0001\t\u0013\ty\b\u0003\u0005\u0002\u000e\u0002!\t!KAH\u0011\u001d\t\t\n\u0001C\u0005\u0003\u001fCq!a%\u0001\t\u0003\t)\nC\u0004\u0002\u001a\u0002!\t!a'\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\u0010\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0003bBAR\u0001\u0011E\u0011Q\u0015\u0005\b\u0003S\u0003A\u0011BAV\u0011\u0019\t9\u000e\u0001C\u0001M\n)\u0011J\u001c2pq*\u0011!fK\u0001\u0006]\u0016$H/\u001f\u0006\u0003Y5\n1A\u001d9d\u0015\tqs&\u0001\u0004d_6lwN\u001c\u0006\u0003aE\n\u0001bY3mK\n|'O\u001c\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014xmE\u0002\u0001mq\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012a!\u00118z%\u00164\u0007CA\u001fA\u001b\u0005q$BA .\u0003!Ig\u000e^3s]\u0006d\u0017BA!?\u0005\u001daunZ4j]\u001e\f1\"\u001a8ea>Lg\u000e\u001e*fM\u000e\u0001Q#A#\u0011\u0005\u0019;U\"A\u0015\n\u0005!K#a\u0005(fiRL(\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0017\u0001D3oIB|\u0017N\u001c;SK\u001a\u0004\u0013\u0001C3oIB|\u0017N\u001c;\u0016\u00031\u0003\"!\u0014(\u000e\u0003-J!aT\u0016\u0003\u0017I\u00038-\u00128ea>Lg\u000e^\u0001\nK:$\u0007o\\5oi\u0002\nAaY8oMV\t1\u000b\u0005\u0002U+6\tQ&\u0003\u0002W[\ta1)\u001a7fE>\u0014hnQ8oM\u0006)1m\u001c8gA\u00059Q.\u001a;sS\u000e\u001cX#\u0001.\u0011\u00055[\u0016B\u0001/,\u0005E\u0011\u0006oY'fiJL7m\u001d+sC\u000e\\WM]\u0001\t[\u0016$(/[2tA\u00051A(\u001b8jiz\"R\u0001Y1cG\u0012\u0004\"A\u0012\u0001\t\u000b\tK\u0001\u0019A#\t\u000b)K\u0001\u0019\u0001'\t\u000bEK\u0001\u0019A*\t\u000baK\u0001\u0019\u0001.\u0002\u0011\r\f\u0007/Y2jif,\u0012a\u001a\t\u0003o!L!!\u001b\u001d\u0003\u0007%sG/A\u0005dCB\f7-\u001b;zA\u0005I\u0011N\u001c2pq2{7m[\u000b\u0002[B\u0011an^\u0007\u0002_*\u0011\u0001/]\u0001\u0006Y>\u001c7n\u001d\u0006\u0003eN\f!bY8oGV\u0014(/\u001a8u\u0015\t!X/\u0001\u0003vi&d'\"\u0001<\u0002\t)\fg/Y\u0005\u0003q>\u0014QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0017AC5oE>DHj\\2lA\u00051\u0011n\u001d$vY2,\u0012\u0001 \t\u0003]vL!A`8\u0003\u0013\r{g\u000eZ5uS>t\u0017aB5t\rVdG\u000eI\u0001\t[\u0016\u001c8/Y4fgV\u0011\u0011Q\u0001\t\u0007\u0003\u000f\tI!!\u0004\u000e\u0003ML1!a\u0003t\u0005)a\u0015N\\6fI2K7\u000f\u001e\t\u0004\r\u0006=\u0011bAA\tS\ta\u0011J\u001c2pq6+7o]1hK\u0006IQ.Z:tC\u001e,7\u000f\t\u0015\b#\u0005]\u0011\u0011FA\u0016!\u0011\tI\"!\n\u000e\u0005\u0005m!b\u0001:\u0002\u001e)!\u0011qDA\u0011\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0003G\tQA[1wCbLA!a\n\u0002\u001c\tIq)^1sI\u0016$')_\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003[\tA\u0001\u001e5jg\u0006aQ.Z:tC\u001e,7i\\;oiV\u0011\u00111\u0007\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011H9\u0002\r\u0005$x.\\5d\u0013\u0011\ti$a\u000e\u0003\u0015\u0005#x.\\5d\u0019>tw-A\u0007nKN\u001c\u0018mZ3D_VtG\u000fI\u0001\bgR|\u0007\u000f]3e+\t\t)\u0005E\u00028\u0003\u000fJ1!!\u00139\u0005\u001d\u0011un\u001c7fC:\f1b\u001d;paB,Gm\u0018\u0013fcR!\u0011qJA+!\r9\u0014\u0011K\u0005\u0004\u0003'B$\u0001B+oSRD\u0011\"a\u0016\u0016\u0003\u0003\u0005\r!!\u0012\u0002\u0007a$\u0013'\u0001\u0005ti>\u0004\b/\u001a3!Q\u001d1\u0012qCA\u0015\u0003W\t\u0001#\u001a8bE2,7i\u001c8dkJ\u0014XM\u001c;\u0002)\u0015t\u0017M\u00197f\u0007>t7-\u001e:sK:$x\fJ3r)\u0011\ty%a\u0019\t\u0013\u0005]\u0003$!AA\u0002\u0005\u0015\u0013!E3oC\ndWmQ8oGV\u0014(/\u001a8uA!:\u0011$a\u0006\u0002*\u0005-\u0012\u0001\u00058v[\u0006\u001bG/\u001b<f)\"\u0014X-\u00193t\u0003QqW/\\!di&4X\r\u00165sK\u0006$7o\u0018\u0013fcR!\u0011qJA8\u0011!\t9fGA\u0001\u0002\u00049\u0017!\u00058v[\u0006\u001bG/\u001b<f)\"\u0014X-\u00193tA!:A$a\u0006\u0002*\u0005-\u0012AC1eI6+7o]1hKR!\u0011qJA=\u0011\u001d\tY(\ba\u0001\u0003\u001b\tq!\\3tg\u0006<W-A\bqe>\u001cWm]:J]R,'O\\1m)\u0019\ty%!!\u0002\f\"9\u00111\u0011\u0010A\u0002\u0005\u0015\u0015A\u00033jgB\fGo\u00195feB\u0019a)a\"\n\u0007\u0005%\u0015F\u0001\u0006ESN\u0004\u0018\r^2iKJDq!a\u001f\u001f\u0001\u0004\ti!\u0001\u0006xC&$xJ\u001c$vY2$\"!a\u0014\u0002\u001bMLwM\\1m\u001d>$h)\u001e7m\u0003\u001d\u0001(o\\2fgN$B!a\u0014\u0002\u0018\"9\u00111Q\u0011A\u0002\u0005\u0015\u0015\u0001\u00029pgR$B!a\u0014\u0002\u001e\"9\u00111\u0010\u0012A\u0002\u00055\u0011\u0001B:u_B\fq![:F[B$\u00180\u0001\u0004p]\u0012\u0013x\u000e\u001d\u000b\u0005\u0003\u001f\n9\u000bC\u0004\u0002|\u0015\u0002\r!!\u0004\u0002\u0015M\fg-\u001a7z\u0007\u0006dG\u000e\u0006\u0005\u0002.\u0006e\u00161XAk)\u0011\ty%a,\t\u0011\u0005Ef\u0005\"a\u0001\u0003g\u000ba!Y2uS>t\u0007#B\u001c\u00026\u0006=\u0013bAA\\q\tAAHY=oC6,g\bC\u0003KM\u0001\u0007A\nC\u0004\u0002>\u001a\u0002\r!a0\u0002\u001f\u0015tG\r]8j]R\u0014VM\u001a(b[\u0016\u0004B!!1\u0002P:!\u00111YAf!\r\t)\rO\u0007\u0003\u0003\u000fT1!!3D\u0003\u0019a$o\\8u}%\u0019\u0011Q\u001a\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t.a5\u0003\rM#(/\u001b8h\u0015\r\ti\r\u000f\u0005\b\u0003w2\u0003\u0019AA\u0007\u0003M9W\r\u001e(v[\u0006\u001bG/\u001b<f)\"\u0014X-\u00193t\u0001")
public class Inbox
implements Logging {
    private final NettyRpcEndpointRef endpointRef;
    private final RpcEndpoint endpoint;
    private final CelebornConf conf;
    private final RpcMetricsTracker metrics;
    private final int capacity;
    private final ReentrantLock inboxLock;
    private final Condition isFull;
    @GuardedBy(value="this")
    private final LinkedList<InboxMessage> messages;
    private final AtomicLong messageCount;
    @GuardedBy(value="this")
    private boolean stopped;
    @GuardedBy(value="this")
    private boolean enableConcurrent;
    @GuardedBy(value="this")
    private int numActiveThreads;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        Inbox inbox = this;
        synchronized (inbox) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public NettyRpcEndpointRef endpointRef() {
        return this.endpointRef;
    }

    public RpcEndpoint endpoint() {
        return this.endpoint;
    }

    public CelebornConf conf() {
        return this.conf;
    }

    public RpcMetricsTracker metrics() {
        return this.metrics;
    }

    public int capacity() {
        return this.capacity;
    }

    public ReentrantLock inboxLock() {
        return this.inboxLock;
    }

    public Condition isFull() {
        return this.isFull;
    }

    public LinkedList<InboxMessage> messages() {
        return this.messages;
    }

    private AtomicLong messageCount() {
        return this.messageCount;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private boolean enableConcurrent() {
        return this.enableConcurrent;
    }

    private void enableConcurrent_$eq(boolean x$1) {
        this.enableConcurrent = x$1;
    }

    private int numActiveThreads() {
        return this.numActiveThreads;
    }

    private void numActiveThreads_$eq(int x$1) {
        this.numActiveThreads = x$1;
    }

    public void addMessage(InboxMessage message) {
        this.messages().add(message);
        this.messageCount().incrementAndGet();
        this.signalNotFull();
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("queue length of ").append(this.messageCount().get()).append(" ").toString());
    }

    private void processInternal(Dispatcher dispatcher, InboxMessage message) {
        InboxMessage inboxMessage = message;
        if (inboxMessage instanceof RpcMessage) {
            RpcMessage rpcMessage = (RpcMessage)inboxMessage;
            RpcAddress _sender = rpcMessage.senderAddress();
            Object content = rpcMessage.content();
            NettyRpcCallContext context = rpcMessage.context();
            try {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)this.endpoint().receiveAndReply(context).applyOrElse(content, (Function1 & Serializable)msg -> {
                    throw new CelebornException(new StringBuilder(26).append("Unsupported message ").append(message).append(" from ").append(_sender).toString());
                });
            }
            catch (Throwable e) {
                context.sendFailure(e);
                throw e;
            }
            return;
        }
        if (inboxMessage instanceof OneWayMessage) {
            OneWayMessage oneWayMessage = (OneWayMessage)inboxMessage;
            RpcAddress _sender = oneWayMessage.senderAddress();
            Object content = oneWayMessage.content();
            BoxedUnit cfr_ignored_1 = (BoxedUnit)this.endpoint().receive().applyOrElse(content, (Function1 & Serializable)msg -> {
                throw new CelebornException(new StringBuilder(26).append("Unsupported message ").append(message).append(" from ").append(_sender).toString());
            });
            return;
        }
        if (OnStart$.MODULE$.equals(inboxMessage)) {
            this.endpoint().onStart();
            if (!(this.endpoint() instanceof ThreadSafeRpcEndpoint)) {
                try {
                    BoxedUnit boxedUnit;
                    this.inboxLock().lockInterruptibly();
                    if (!this.stopped()) {
                        this.enableConcurrent_$eq(true);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                finally {
                    this.inboxLock().unlock();
                }
                return;
            }
            return;
        }
        if (OnStop$.MODULE$.equals(inboxMessage)) {
            int n;
            try {
                this.inboxLock().lockInterruptibly();
                n = this.numActiveThreads();
            }
            finally {
                this.inboxLock().unlock();
            }
            int activeThreads = n;
            Predef$.MODULE$.assert(activeThreads == 1, (Function0 & Serializable)() -> new StringBuilder(63).append("There should be only a single active thread but found ").append(activeThreads).append(" threads.").toString());
            dispatcher.removeRpcEndpointRef(this.endpoint());
            this.endpoint().onStop();
            Predef$.MODULE$.assert(this.isEmpty(), (Function0 & Serializable)() -> "OnStop should be the last message");
            return;
        }
        if (inboxMessage instanceof RemoteProcessConnected) {
            RemoteProcessConnected remoteProcessConnected = (RemoteProcessConnected)inboxMessage;
            RpcAddress remoteAddress = remoteProcessConnected.remoteAddress();
            this.endpoint().onConnected(remoteAddress);
            return;
        }
        if (inboxMessage instanceof RemoteProcessDisconnected) {
            RemoteProcessDisconnected remoteProcessDisconnected = (RemoteProcessDisconnected)inboxMessage;
            RpcAddress remoteAddress = remoteProcessDisconnected.remoteAddress();
            this.endpoint().onDisconnected(remoteAddress);
            return;
        }
        if (inboxMessage instanceof RemoteProcessConnectionError) {
            RemoteProcessConnectionError remoteProcessConnectionError = (RemoteProcessConnectionError)inboxMessage;
            Throwable cause = remoteProcessConnectionError.cause();
            RpcAddress remoteAddress = remoteProcessConnectionError.remoteAddress();
            this.endpoint().onNetworkError(cause, remoteAddress);
            return;
        }
        throw new MatchError((Object)inboxMessage);
    }

    public void waitOnFull() {
        if (this.capacity() > 0 && !this.stopped()) {
            try {
                this.inboxLock().lockInterruptibly();
                while (this.messageCount().get() >= (long)this.capacity()) {
                    this.isFull().await();
                }
            }
            finally {
                this.inboxLock().unlock();
            }
            return;
        }
    }

    private void signalNotFull() {
        Predef$.MODULE$.require(this.inboxLock().isHeldByCurrentThread(), (Function0 & Serializable)() -> "cannot call signalNotFull without holding lock");
        if (this.capacity() > 0 && this.messageCount().get() < (long)this.capacity()) {
            this.isFull().signal();
            return;
        }
    }

    public void process(Dispatcher dispatcher) {
        ObjectRef message;
        block11: {
            block10: {
                message = ObjectRef.create(null);
                try {
                    this.inboxLock().lockInterruptibly();
                    if (!this.enableConcurrent() && this.numActiveThreads() != 0) {
                        break block10;
                    }
                    message.elem = this.messages().poll();
                    if ((InboxMessage)message.elem == null) break block10;
                    this.numActiveThreads_$eq(this.numActiveThreads() + 1);
                    RpcTimeMetrics$.MODULE$.updateTime((InboxMessage)message.elem, RpcTimeMetrics$Dequeue$.MODULE$);
                    this.messageCount().decrementAndGet();
                    this.signalNotFull();
                    break block11;
                }
                finally {
                    this.inboxLock().unlock();
                }
            }
            return;
        }
        while (true) {
            this.safelyCall(this.endpoint(), this.endpointRef().name(), (InboxMessage)message.elem, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.processInternal(dispatcher, (InboxMessage)message$2.elem));
            try {
                this.inboxLock().lockInterruptibly();
                if (!this.enableConcurrent() && this.numActiveThreads() != 1) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
                message.elem = this.messages().poll();
                if ((InboxMessage)message.elem == null) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
                RpcTimeMetrics$.MODULE$.updateTime((InboxMessage)message.elem, RpcTimeMetrics$Dequeue$.MODULE$);
                this.messageCount().decrementAndGet();
                this.signalNotFull();
                continue;
            }
            finally {
                this.inboxLock().unlock();
                continue;
            }
            break;
        }
    }

    public void post(InboxMessage message) {
        try {
            this.inboxLock().lockInterruptibly();
            if (this.stopped()) {
                this.onDrop(message);
            } else {
                this.addMessage(message);
                RpcTimeMetrics$.MODULE$.updateTime(message, RpcTimeMetrics$Enqueue$.MODULE$);
                this.metrics().updateMaxLength();
            }
        }
        finally {
            this.inboxLock().unlock();
        }
    }

    public void stop() {
        try {
            this.inboxLock().lockInterruptibly();
            if (!this.stopped()) {
                this.enableConcurrent_$eq(false);
                this.stopped_$eq(true);
                this.metrics().dump();
                this.addMessage(OnStop$.MODULE$);
            }
        }
        finally {
            this.metrics().close();
            this.inboxLock().unlock();
        }
    }

    public boolean isEmpty() {
        boolean bl;
        try {
            this.inboxLock().lockInterruptibly();
            bl = this.messages().isEmpty();
        }
        finally {
            this.inboxLock().unlock();
        }
        return bl;
    }

    public void onDrop(InboxMessage message) {
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("Drop ").append(message).append(" because ").append(this.endpointRef()).append(" is stopped").toString());
    }

    private void safelyCall(RpcEndpoint endpoint, String endpointRefName, InboxMessage message, Function0<BoxedUnit> action) {
        block15: {
            try {
                try {
                    action.apply$mcV$sp();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        BoxedUnit boxedUnit;
                        try {
                            endpoint.onError(throwable2);
                            boxedUnit = BoxedUnit.UNIT;
                            break block15;
                        }
                        catch (Throwable throwable4) {
                            Throwable throwable5;
                            Throwable throwable6 = throwable4;
                            if (throwable6 != null && NonFatal$.MODULE$.apply(throwable5 = throwable6)) {
                                if (this.stopped()) {
                                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Ignoring error", throwable5);
                                } else {
                                    this.logError((Function0<String>)(Function0 & Serializable)() -> "Ignoring error", throwable5);
                                }
                            } else if (throwable6 != null) {
                                Throwable throwable7 = throwable6;
                                this.dealWithFatalError$1(throwable7, endpointRefName);
                            } else {
                                throw throwable4;
                            }
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        break block15;
                    }
                    if (throwable3 != null) {
                        Throwable throwable8 = throwable3;
                        this.dealWithFatalError$1(throwable8, endpointRefName);
                        break block15;
                    }
                    throw throwable;
                }
            }
            finally {
                RpcTimeMetrics$.MODULE$.updateTime(message, RpcTimeMetrics$Process$.MODULE$);
                this.metrics().update(message);
            }
        }
    }

    public int getNumActiveThreads() {
        int n;
        try {
            this.inboxLock().lockInterruptibly();
            n = this.numActiveThreads();
        }
        finally {
            this.inboxLock().unlock();
        }
        return n;
    }

    private final void dealWithFatalError$1(Throwable fatal, String endpointRefName$1) {
        try {
            this.inboxLock().lockInterruptibly();
            Predef$.MODULE$.assert(this.numActiveThreads() > 0, (Function0 & Serializable)() -> "The number of active threads should be positive.");
            this.numActiveThreads_$eq(this.numActiveThreads() - 1);
        }
        finally {
            this.inboxLock().unlock();
        }
        this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("An error happened while processing message in the inbox for ").append(endpointRefName$1).toString(), fatal);
        throw fatal;
    }

    public Inbox(NettyRpcEndpointRef endpointRef, RpcEndpoint endpoint, CelebornConf conf, RpcMetricsTracker metrics) {
        this.endpointRef = endpointRef;
        this.endpoint = endpoint;
        this.conf = conf;
        this.metrics = metrics;
        Logging.$init$(this);
        this.capacity = BoxesRunTime.unboxToInt((Object)conf.get(CelebornConf$.MODULE$.RPC_INBOX_CAPACITY()));
        this.inboxLock = new ReentrantLock();
        this.isFull = this.inboxLock().newCondition();
        this.messages = new LinkedList();
        this.messageCount = new AtomicLong(0L);
        this.stopped = false;
        this.enableConcurrent = false;
        this.numActiveThreads = 0;
        metrics.init((Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> this.messageCount().get());
        try {
            this.inboxLock().lockInterruptibly();
            this.messages().add(OnStart$.MODULE$);
            RpcTimeMetrics$.MODULE$.updateTime(OnStart$.MODULE$, RpcTimeMetrics$Enqueue$.MODULE$);
            metrics.updateMaxLength();
            this.messageCount().incrementAndGet();
        }
        finally {
            this.inboxLock().unlock();
        }
    }
}

