/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.http.authentication;

import java.io.IOException;
import java.io.Serializable;
import javax.security.sasl.AuthenticationException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.authentication.HttpAuthSchemes$;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.internal.config.ConfigEntry;
import org.apache.celeborn.server.common.Service$;
import org.apache.celeborn.server.common.http.HttpAuthUtils$;
import org.apache.celeborn.server.common.http.RestAuditLogger$;
import org.apache.celeborn.server.common.http.authentication.AuthenticationFilter$;
import org.apache.celeborn.server.common.http.authentication.AuthenticationHandler;
import org.apache.celeborn.server.common.http.authentication.BasicAuthenticationHandler;
import org.apache.celeborn.server.common.http.authentication.BearerAuthenticationHandler;
import org.apache.celeborn.server.common.http.authentication.SpnegoAuthenticationHandler;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001B\u0011#\u0001EB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\")A\f\u0001C\u0001;\"A!\r\u0001b\u0001\n\u0003\u00113\rC\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u00023\t\u0011\u0005\u0015\u0001\u0001\"\u0001#\u0003\u000fA\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\t\u0011\u0005-\u0002\u0001)A\u0005\u00033A\u0011\"!\f\u0001\u0005\u0004%I!a\f\t\u000f\u0005E\u0002\u0001)A\u0005\u001f\"I\u00111\u0007\u0001C\u0002\u0013%\u0011Q\u0007\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u00028!9\u0011q\b\u0001\u0005\n\u0005\u0005\u0003bBA\"\u0001\u0011\u0005\u0013Q\t\u0005\t\u0003#\u0002A\u0011\u0001\u0016\u0002T!9\u0011q\f\u0001\u0005B\u0005\u0005\u0004bBAA\u0001\u0011%\u00111\u0011\u0005\b\u0003?\u0002A\u0011CAM\u0011\u001d\ti\u0010\u0001C!\u0003\u0003:q!a@#\u0011\u0003\u0011\tA\u0002\u0004\"E!\u0005!1\u0001\u0005\u00079V!\tAa\u0003\t\u0013\t5QC1A\u0005\n\t=\u0001\u0002\u0003B\u0010+\u0001\u0006IA!\u0005\t\u0013\t\u0005RC1A\u0005\u0006\t\r\u0002\u0002\u0003B\u0016+\u0001\u0006iA!\n\t\u0013\t5RC1A\u0005\u0006\t\r\u0002\u0002\u0003B\u0018+\u0001\u0006iA!\n\t\u0013\tERC1A\u0005\u0006\t\r\u0002\u0002\u0003B\u001a+\u0001\u0006iA!\n\t\u0013\tURC1A\u0005\u0006\t\r\u0002\u0002\u0003B\u001c+\u0001\u0006iA!\n\u0003)\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\u001aKG\u000e^3s\u0015\t\u0019C%\u0001\bbkRDWM\u001c;jG\u0006$\u0018n\u001c8\u000b\u0005\u00152\u0013\u0001\u00025uiBT!a\n\u0015\u0002\r\r|W.\\8o\u0015\tI#&\u0001\u0004tKJ4XM\u001d\u0006\u0003W1\n\u0001bY3mK\n|'O\u001c\u0006\u0003[9\na!\u00199bG\",'\"A\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0011$H\u0011\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\nA\u0001\\1oO*\tq'\u0001\u0003kCZ\f\u0017BA\u001d5\u0005\u0019y%M[3diB\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\bg\u0016\u0014h\u000f\\3u\u0015\u0005y\u0014!\u00026bm\u0006D\u0018BA!=\u0005\u00191\u0015\u000e\u001c;feB\u00111iR\u0007\u0002\t*\u0011QIR\u0001\tS:$XM\u001d8bY*\u0011qEK\u0005\u0003\u0011\u0012\u0013q\u0001T8hO&tw-\u0001\u0003d_:4\u0007CA&M\u001b\u00051\u0015BA'G\u00051\u0019U\r\\3c_Jt7i\u001c8g\u0003-\u0019XM\u001d<jG\u0016t\u0015-\\3\u0011\u0005AKfBA)X!\t\u0011V+D\u0001T\u0015\t!\u0006'\u0001\u0004=e>|GO\u0010\u0006\u0002-\u0006)1oY1mC&\u0011\u0001,V\u0001\u0007!J,G-\u001a4\n\u0005i[&AB*ue&twM\u0003\u0002Y+\u00061A(\u001b8jiz\"2A\u00181b!\ty\u0006!D\u0001#\u0011\u0015I5\u00011\u0001K\u0011\u0015q5\u00011\u0001P\u0003I\tW\u000f\u001e5TG\",W.\u001a%b]\u0012dWM]:\u0016\u0003\u0011\u0004B!\u001a6m}6\taM\u0003\u0002hQ\u00069Q.\u001e;bE2,'BA5V\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003W\u001a\u0014q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002nw:\u0011a\u000e\u001f\b\u0003_^t!\u0001\u001d<\u000f\u0005E,hB\u0001:u\u001d\t\u00116/C\u00010\u0013\tic&\u0003\u0002,Y%\u0011qEK\u0005\u0003G\u0019K!!\u001f>\u0002\u001f!#H\u000f]!vi\"\u001c6\r[3nKNT!a\t$\n\u0005ql(A\u0004%uiB\fU\u000f\u001e5TG\",W.\u001a\u0006\u0003sj\u0004\"aX@\n\u0007\u0005\u0005!EA\u000bBkRDWM\u001c;jG\u0006$\u0018n\u001c8IC:$G.\u001a:\u0002'\u0005,H\u000f[*dQ\u0016lW\rS1oI2,'o\u001d\u0011\u0002\u001d\u0005$G-Q;uQ\"\u000bg\u000e\u001a7feR!\u0011\u0011BA\t!\u0011\tY!!\u0004\u000e\u0003UK1!a\u0004V\u0005\u0011)f.\u001b;\t\r\u0005Ma\u00011\u0001\u007f\u0003-\tW\u000f\u001e5IC:$G.\u001a:\u0002\u0017\u0005,H\u000f[*dQ\u0016lWm]\u000b\u0003\u00033\u0001R!a\u0007\u0002&1tA!!\b\u0002\"9\u0019!+a\b\n\u0003YK1!a\tV\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\n\u0002*\t\u00191+Z9\u000b\u0007\u0005\rR+\u0001\u0007bkRD7k\u00195f[\u0016\u001c\b%A\nqe>D\u0018p\u00117jK:$\u0018\n\u001d%fC\u0012,'/F\u0001P\u0003Q\u0001(o\u001c=z\u00072LWM\u001c;Ja\"+\u0017\rZ3sA\u0005q\u0011\rZ7j]&\u001cHO]1u_J\u001cXCAA\u001c!\u0011\u0001\u0016\u0011H(\n\u0007\u0005m2LA\u0002TKR\fq\"\u00193nS:L7\u000f\u001e:bi>\u00148\u000fI\u0001\u0011S:LG/Q;uQ\"\u000bg\u000e\u001a7feN$\"!!\u0003\u0002\t%t\u0017\u000e\u001e\u000b\u0005\u0003\u0013\t9\u0005C\u0004\u0002J9\u0001\r!a\u0013\u0002\u0019\u0019LG\u000e^3s\u0007>tg-[4\u0011\u0007m\ni%C\u0002\u0002Pq\u0012ABR5mi\u0016\u00148i\u001c8gS\u001e\f\u0011cZ3u\u001b\u0006$8\r[3e\u0011\u0006tG\r\\3s)\u0011\t)&a\u0017\u0011\u000b\u0005-\u0011q\u000b@\n\u0007\u0005eSK\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003;z\u0001\u0019A(\u0002\u001b\u0005,H\u000f[8sSj\fG/[8o\u0003!!wNR5mi\u0016\u0014H\u0003CA\u0005\u0003G\ni'a\u001e\t\u000f\u0005\u0015\u0004\u00031\u0001\u0002h\u00059!/Z9vKN$\bcA\u001e\u0002j%\u0019\u00111\u000e\u001f\u0003\u001dM+'O\u001e7fiJ+\u0017/^3ti\"9\u0011q\u000e\tA\u0002\u0005E\u0014\u0001\u0003:fgB|gn]3\u0011\u0007m\n\u0019(C\u0002\u0002vq\u0012qbU3sm2,GOU3ta>t7/\u001a\u0005\b\u0003s\u0002\u0002\u0019AA>\u0003-1\u0017\u000e\u001c;fe\u000eC\u0017-\u001b8\u0011\u0007m\ni(C\u0002\u0002\u0000q\u00121BR5mi\u0016\u00148\t[1j]\u0006\t\u0012n]'vi\u0006$\u0018N^3SKF,Xm\u001d;\u0015\t\u0005\u0015\u00151\u0012\t\u0005\u0003\u0017\t9)C\u0002\u0002\nV\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002\u000eF\u0001\r!a$\u0002\u0017!$H\u000f\u001d*fcV,7\u000f\u001e\t\u0005\u0003#\u000b)*\u0004\u0002\u0002\u0014*\u0011Q\u0005P\u0005\u0005\u0003/\u000b\u0019J\u0001\nIiR\u00048+\u001a:wY\u0016$(+Z9vKN$H\u0003CA\u0005\u00037\u000bi*a(\t\u000f\u0005e$\u00031\u0001\u0002|!9\u0011Q\r\nA\u0002\u0005=\u0005bBA8%\u0001\u0007\u0011\u0011\u0015\t\u0005\u0003#\u000b\u0019+\u0003\u0003\u0002&\u0006M%a\u0005%uiB\u001cVM\u001d<mKR\u0014Vm\u001d9p]N,\u0007&\u0002\n\u0002*\u0006U\u0006CBA\u0006\u0003W\u000by+C\u0002\u0002.V\u0013a\u0001\u001e5s_^\u001c\bcA\u001e\u00022&\u0019\u00111\u0017\u001f\u0003!M+'O\u001e7fi\u0016C8-\u001a9uS>t\u0017G\u0002\u0010P\u0003o\u000b\t/M\u0005$\u0003s\u000by,a6\u0002BV!\u0011qFA^\t\u001d\ti\f\rb\u0001\u0003\u000f\u0014\u0011\u0001V\u0005\u0005\u0003\u0003\f\u0019-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003\u000b,\u0016A\u0002;ie><8/\u0005\u0003\u0002J\u0006=\u0007\u0003BA\u0006\u0003\u0017L1!!4V\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!5\u0002T:!\u00111BA\u0011\u0013\u0011\t).!\u000b\u0003\u0013QC'o\\<bE2,\u0017'C\u0012\u0002Z\u0006m\u0017Q\\Ac\u001d\u0011\tY!a7\n\u0007\u0005\u0015W+\r\u0004#\u0003\u0017)\u0016q\u001c\u0002\u0006g\u000e\fG.Y\u0019\u0004M\u0005=\u0006&\u0002\n\u0002f\u0006M\bCBA\u0006\u0003W\u000b9\u000f\u0005\u0003\u0002j\u0006=XBAAv\u0015\r\tiON\u0001\u0003S>LA!!=\u0002l\nY\u0011jT#yG\u0016\u0004H/[8oc\u0019qr*!>\u0002|FJ1%!/\u0002@\u0006]\u0018\u0011Y\u0019\nG\u0005e\u00171\\A}\u0003\u000b\fdAIA\u0006+\u0006}\u0017g\u0001\u0014\u0002h\u00069A-Z:ue>L\u0018\u0001F!vi\",g\u000e^5dCRLwN\u001c$jYR,'\u000f\u0005\u0002`+M\u0019QC!\u0002\u0011\t\u0005-!qA\u0005\u0004\u0005\u0013)&AB!osJ+g\r\u0006\u0002\u0003\u0002\u0005\u0001\")\u0017)B'N{\u0016\tU%`!\u0006#\u0006jU\u000b\u0003\u0005#\u0001bAa\u0005\u0003\u001a\tmQB\u0001B\u000b\u0015\r\u00119\u0002[\u0001\nS6lW\u000f^1cY\u0016LA!a\u000f\u0003\u0016A\u00191G!\b\n\u0005i#\u0014!\u0005\"Z!\u0006\u001b6kX!Q\u0013~\u0003\u0016\t\u0016%TA\u00051\u0002\n\u0016+Q?\u000ec\u0015*\u0012(U?&\u0003v,\u0011#E%\u0016\u001b6+\u0006\u0002\u0003&A!1Ga\nP\u0013\r\u0011I\u0003\u000e\u0002\f)\"\u0014X-\u00193M_\u000e\fG.A\fI)R\u0003vl\u0011'J\u000b:#v,\u0013)`\u0003\u0012#%+R*TA\u0005\u0019\u0003\n\u0016+Q?B\u0013v\nW-`\u0011\u0016\u000bE)\u0012*`\u00072KUI\u0014+`\u0013B{\u0016\t\u0012#S\u000bN\u001b\u0016\u0001\n%U)B{\u0006KU(Y3~CU)\u0011#F%~\u001bE*S#O)~K\u0005kX!E\tJ+5k\u0015\u0011\u0002-!#F\u000bU0D\u0019&+e\nV0J\t\u0016sE+\u0013$J\u000bJ\u000bq\u0003\u0013+U!~\u001bE*S#O)~KE)\u0012(U\u0013\u001aKUI\u0015\u0011\u0002\u001d!#F\u000bU0B+RCu\fV-Q\u000b\u0006y\u0001\n\u0016+Q?\u0006+F\u000bS0U3B+\u0005\u0005")
public class AuthenticationFilter
implements Filter,
Logging {
    private final CelebornConf conf;
    private final String serviceName;
    private final HashMap<Enumeration.Value, AuthenticationHandler> authSchemeHandlers;
    private final Seq<Enumeration.Value> authSchemes;
    private final String proxyClientIpHeader;
    private final Set<String> administrators;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public static ThreadLocal<String> HTTP_AUTH_TYPE() {
        return AuthenticationFilter$.MODULE$.HTTP_AUTH_TYPE();
    }

    public static ThreadLocal<String> HTTP_CLIENT_IDENTIFIER() {
        return AuthenticationFilter$.MODULE$.HTTP_CLIENT_IDENTIFIER();
    }

    public static ThreadLocal<String> HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS() {
        return AuthenticationFilter$.MODULE$.HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS();
    }

    public static ThreadLocal<String> HTTP_CLIENT_IP_ADDRESS() {
        return AuthenticationFilter$.MODULE$.HTTP_CLIENT_IP_ADDRESS();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        AuthenticationFilter authenticationFilter = this;
        synchronized (authenticationFilter) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public HashMap<Enumeration.Value, AuthenticationHandler> authSchemeHandlers() {
        return this.authSchemeHandlers;
    }

    public void addAuthHandler(AuthenticationHandler authHandler) {
        authHandler.init(this.conf);
        if (authHandler.authenticationSupported()) {
            if (this.authSchemeHandlers().contains((Object)authHandler.authScheme())) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Authentication handler has been defined for scheme ").append(authHandler.authScheme()).toString());
                return;
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Add authentication handler ").append(authHandler.getClass().getSimpleName()).append(" for scheme ").append(authHandler.authScheme()).toString());
            this.authSchemeHandlers().put((Object)authHandler.authScheme(), (Object)authHandler);
            return;
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("The authentication handler ").append(authHandler.getClass().getSimpleName()).append(" for scheme ").append(authHandler.authScheme()).append(" is not supported").toString());
    }

    private Seq<Enumeration.Value> authSchemes() {
        return this.authSchemes;
    }

    private String proxyClientIpHeader() {
        return this.proxyClientIpHeader;
    }

    private Set<String> administrators() {
        return this.administrators;
    }

    private void initAuthHandlers() {
        if (this.authSchemes().contains((Object)HttpAuthSchemes$.MODULE$.NEGOTIATE())) {
            String string = this.serviceName;
            String string2 = Service$.MODULE$.MASTER();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                this.addAuthHandler(new SpnegoAuthenticationHandler((String)((Option)this.conf.get((ConfigEntry)CelebornConf$.MODULE$.MASTER_HTTP_SPNEGO_KEYTAB())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (String)((Option)this.conf.get((ConfigEntry)CelebornConf$.MODULE$.MASTER_HTTP_SPNEGO_PRINCIPAL())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")));
            } else {
                String string4 = Service$.MODULE$.WORKER();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    this.addAuthHandler(new SpnegoAuthenticationHandler((String)((Option)this.conf.get((ConfigEntry)CelebornConf$.MODULE$.WORKER_HTTP_SPNEGO_KEYTAB())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (String)((Option)this.conf.get((ConfigEntry)CelebornConf$.MODULE$.WORKER_HTTP_SPNEGO_PRINCIPAL())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")));
                } else {
                    throw new MatchError((Object)string);
                }
            }
        }
        if (this.authSchemes().contains((Object)HttpAuthSchemes$.MODULE$.BASIC())) {
            String string = this.serviceName;
            String string6 = Service$.MODULE$.MASTER();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                this.addAuthHandler(new BasicAuthenticationHandler((String)this.conf.get(CelebornConf$.MODULE$.MASTER_HTTP_AUTH_BASIC_PROVIDER())));
            } else {
                String string8 = Service$.MODULE$.WORKER();
                String string9 = string;
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    this.addAuthHandler(new BasicAuthenticationHandler((String)this.conf.get(CelebornConf$.MODULE$.WORKER_HTTP_AUTH_BASIC_PROVIDER())));
                } else {
                    throw new MatchError((Object)string);
                }
            }
        }
        if (this.authSchemes().contains((Object)HttpAuthSchemes$.MODULE$.BEARER())) {
            String string = this.serviceName;
            String string10 = Service$.MODULE$.MASTER();
            String string11 = string;
            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                this.addAuthHandler(new BearerAuthenticationHandler((String)this.conf.get(CelebornConf$.MODULE$.MASTER_HTTP_AUTH_BEARER_PROVIDER())));
                return;
            }
            String string12 = Service$.MODULE$.WORKER();
            String string13 = string;
            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                this.addAuthHandler(new BearerAuthenticationHandler((String)this.conf.get(CelebornConf$.MODULE$.WORKER_HTTP_AUTH_BEARER_PROVIDER())));
                return;
            }
            throw new MatchError((Object)string);
        }
    }

    public void init(FilterConfig filterConfig) {
        this.initAuthHandlers();
    }

    public Option<AuthenticationHandler> getMatchedHandler(String authorization) {
        return this.authSchemeHandlers().values().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.matchAuthScheme(authorization)));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) {
        block11: {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            AuthenticationFilter$.MODULE$.HTTP_CLIENT_IP_ADDRESS().set(httpRequest.getRemoteAddr());
            AuthenticationFilter$.MODULE$.HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS().set(httpRequest.getHeader(this.proxyClientIpHeader()));
            if (this.authSchemeHandlers().isEmpty() || AuthenticationFilter$.MODULE$.org$apache$celeborn$server$common$http$authentication$AuthenticationFilter$$BYPASS_API_PATHS().contains((Object)httpRequest.getRequestURI())) {
                try {
                    filterChain.doFilter(request, response);
                }
                finally {
                    RestAuditLogger$.MODULE$.audit(httpRequest, httpResponse);
                    AuthenticationFilter$.MODULE$.HTTP_CLIENT_IP_ADDRESS().remove();
                    AuthenticationFilter$.MODULE$.HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS().remove();
                }
                return;
            }
            String authorization = httpRequest.getHeader(HttpAuthUtils$.MODULE$.AUTHORIZATION_HEADER());
            AuthenticationHandler matchedHandler = (AuthenticationHandler)this.getMatchedHandler(authorization).orNull(Predef$.MODULE$.$conforms());
            try {
                try {
                    if (matchedHandler == null) {
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("No auth scheme matched for url: ").append(httpRequest.getRequestURL()).toString());
                        httpResponse.setStatus(401);
                        httpResponse.sendError(401, new StringBuilder(27).append("No auth scheme matched for ").append(authorization).toString());
                        break block11;
                    }
                    AuthenticationFilter$.MODULE$.HTTP_AUTH_TYPE().set(matchedHandler.authScheme().toString());
                    AuthenticationFilter$.MODULE$.HTTP_CLIENT_IDENTIFIER().set(matchedHandler.authenticate(httpRequest, httpResponse));
                    this.doFilter(filterChain, httpRequest, httpResponse);
                }
                catch (AuthenticationException e) {
                    httpResponse.setStatus(403);
                    AuthenticationFilter$.MODULE$.HTTP_CLIENT_IDENTIFIER().remove();
                    AuthenticationFilter$.MODULE$.HTTP_CLIENT_IP_ADDRESS().remove();
                    AuthenticationFilter$.MODULE$.HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS().remove();
                    AuthenticationFilter$.MODULE$.HTTP_AUTH_TYPE().remove();
                    httpResponse.sendError(403, e.getMessage());
                }
            }
            finally {
                RestAuditLogger$.MODULE$.audit(httpRequest, httpResponse);
            }
        }
    }

    private boolean isMutativeRequest(HttpServletRequest httpRequest) {
        return "POST".equalsIgnoreCase(httpRequest.getMethod()) || "PUT".equalsIgnoreCase(httpRequest.getMethod()) || "DELETE".equalsIgnoreCase(httpRequest.getMethod()) || "PATCH".equalsIgnoreCase(httpRequest.getMethod());
    }

    public void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.isMutativeRequest(request) && !this.administrators().contains((Object)AuthenticationFilter$.MODULE$.HTTP_CLIENT_IDENTIFIER().get())) {
            response.setStatus(403);
            response.sendError(403, new StringBuilder(49).append((Object)AuthenticationFilter$.MODULE$.HTTP_CLIENT_IDENTIFIER().get()).append(" does not have admin privilege to perform ").append(request.getMethod()).append(" action").toString());
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        if (this.authSchemeHandlers().nonEmpty()) {
            this.authSchemeHandlers().values().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.destroy();
                return BoxedUnit.UNIT;
            });
            this.authSchemeHandlers().clear();
            return;
        }
    }

    public AuthenticationFilter(CelebornConf conf, String serviceName) {
        Set set;
        String string;
        Seq seq;
        this.conf = conf;
        this.serviceName = serviceName;
        Logging.$init$((Logging)this);
        this.authSchemeHandlers = new HashMap();
        String string2 = serviceName;
        String string3 = Service$.MODULE$.MASTER();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            seq = (Seq)((TraversableLike)conf.get(CelebornConf$.MODULE$.MASTER_HTTP_AUTH_SUPPORTED_SCHEMES())).map((Function1 & Serializable & scala.Serializable)s -> HttpAuthSchemes$.MODULE$.withName(s), Seq$.MODULE$.canBuildFrom());
        } else {
            String string5 = Service$.MODULE$.WORKER();
            String string6 = string2;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                seq = (Seq)((TraversableLike)conf.get(CelebornConf$.MODULE$.WORKER_HTTP_AUTH_SUPPORTED_SCHEMES())).map((Function1 & Serializable & scala.Serializable)s -> HttpAuthSchemes$.MODULE$.withName(s), Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError((Object)string2);
            }
        }
        this.authSchemes = seq;
        String string7 = serviceName;
        String string8 = Service$.MODULE$.MASTER();
        String string9 = string7;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            string = (String)conf.get(CelebornConf$.MODULE$.MASTER_HTTP_PROXY_CLIENT_IP_HEADER());
        } else {
            String string10 = Service$.MODULE$.WORKER();
            String string11 = string7;
            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                string = (String)conf.get(CelebornConf$.MODULE$.WORKER_HTTP_PROXY_CLIENT_IP_HEADER());
            } else {
                throw new MatchError((Object)string7);
            }
        }
        this.proxyClientIpHeader = string;
        String string12 = serviceName;
        String string13 = Service$.MODULE$.MASTER();
        String string14 = string12;
        if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
            set = ((TraversableOnce)conf.get(CelebornConf$.MODULE$.MASTER_HTTP_AUTH_ADMINISTERS())).toSet();
        } else {
            String string15 = Service$.MODULE$.WORKER();
            String string16 = string12;
            if (!(string15 != null ? !string15.equals(string16) : string16 != null)) {
                set = ((TraversableOnce)conf.get(CelebornConf$.MODULE$.WORKER_HTTP_AUTH_ADMINISTERS())).toSet();
            } else {
                throw new MatchError((Object)string12);
            }
        }
        this.administrators = set;
    }
}

