/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.client.listener.WorkerStatusListener;
import org.apache.celeborn.client.listener.WorkersStatus;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.message.ControlMessages;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001\u0002\f\u0018\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\ti\u0001\u0011\t\u0011)A\u0005k!)\u0011\b\u0001C\u0001u!9a\b\u0001b\u0001\n\u0013y\u0004BB\"\u0001A\u0003%\u0001\tC\u0004E\u0001\t\u0007I\u0011B#\t\r\u0001\u0004\u0001\u0015!\u0003G\u0011\u001d\t\u0007A1A\u0005\u0002\tDaa\u001e\u0001!\u0002\u0013\u0019\u0007b\u0002=\u0001\u0005\u0004%\t!\u001f\u0005\u0007}\u0002\u0001\u000b\u0011\u0002>\t\r}\u0004A\u0011AA\u0001\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!!\n\u0001\t\u0003\t9\u0003C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA/\u0001\u0011\u0005\u0011q\f\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\t\t\n\u0001C\u0001\u0003'Cq!a-\u0001\t\u0013\t)LA\nX_J\\WM]*uCR,8\u000f\u0016:bG.,'O\u0003\u0002\u00193\u000511\r\\5f]RT!AG\u000e\u0002\u0011\r,G.\u001a2pe:T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO\u000e\u00011c\u0001\u0001\"OA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\u0004\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\u0011%tG/\u001a:oC2T!\u0001L\r\u0002\r\r|W.\\8o\u0013\tq\u0013FA\u0004M_\u001e<\u0017N\\4\u0002\t\r|gN\u001a\t\u0003cIj\u0011aK\u0005\u0003g-\u0012AbQ3mK\n|'O\\\"p]\u001a\f\u0001\u0003\\5gK\u000eL8\r\\3NC:\fw-\u001a:\u0011\u0005Y:T\"A\f\n\u0005a:\"\u0001\u0005'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Q\u00191\bP\u001f\u0011\u0005Y\u0002\u0001\"B\u0018\u0004\u0001\u0004\u0001\u0004\"\u0002\u001b\u0004\u0001\u0004)\u0014aG3yG2,H-\u001a3X_J\\WM]#ya&\u0014X\rV5nK>,H/F\u0001A!\t\u0011\u0013)\u0003\u0002CG\t!Aj\u001c8h\u0003q)\u0007p\u00197vI\u0016$wk\u001c:lKJ,\u0005\u0010]5sKRKW.Z8vi\u0002\nQc^8sW\u0016\u00148\u000b^1ukNd\u0015n\u001d;f]\u0016\u00148/F\u0001G!\u00119\u0015\u000b\u0016.\u000f\u0005!{U\"A%\u000b\u0005)[\u0015AC2p]\u000e,(O]3oi*\u0011A*T\u0001\u0005kRLGNC\u0001O\u0003\u0011Q\u0017M^1\n\u0005AK\u0015!E\"p]\u000e,(O]3oi\"\u000b7\u000f['ba&\u0011!k\u0015\u0002\u000b\u0017\u0016L8+\u001a;WS\u0016<(B\u0001)J!\t)\u0006,D\u0001W\u0015\t9v#\u0001\u0005mSN$XM\\3s\u0013\tIfK\u0001\u000bX_J\\WM]*uCR,8\u000fT5ti\u0016tWM\u001d\t\u00037zk\u0011\u0001\u0018\u0006\u0003;6\u000bA\u0001\\1oO&\u0011q\f\u0018\u0002\b\u0005>|G.Z1o\u0003Y9xN]6feN#\u0018\r^;t\u0019&\u001cH/\u001a8feN\u0004\u0013aD3yG2,H-\u001a3X_J\\WM]:\u0016\u0003\r\u0004B\u0001\u00133gY&\u0011Q-\u0013\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bCA4k\u001b\u0005A'BA5,\u0003\u0011iW\r^1\n\u0005-D'AC,pe.,'/\u00138g_B!!%\\8A\u0013\tq7E\u0001\u0004UkBdWM\r\t\u0003aVl\u0011!\u001d\u0006\u0003eN\fq!\\3tg\u0006<WM\u0003\u0002uW\u0005A\u0001O]8u_\u000e|G.\u0003\u0002wc\nQ1\u000b^1ukN\u001cu\u000eZ3\u0002!\u0015D8\r\\;eK\u0012<vN]6feN\u0004\u0013aD:ikR$\u0018N\\4X_J\\WM]:\u0016\u0003i\u00042a\u001f?g\u001b\u0005Y\u0015BA?L\u0005\r\u0019V\r^\u0001\u0011g\",H\u000f^5oO^{'o[3sg\u0002\nAD]3hSN$XM],pe.,'o\u0015;biV\u001cH*[:uK:,'\u000f\u0006\u0003\u0002\u0004\u0005%\u0001c\u0001\u0012\u0002\u0006%\u0019\u0011qA\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u0017a\u0001\u0019\u0001+\u0002)]|'o[3s'R\fG/^:MSN$XM\\3s\u0003U9W\r\u001e(fK\u0012\u001c\u0005.Z2lK\u0012<vN]6feN$\"!!\u0005\u0011\u000b\u0005M\u0011\u0011\u00054\u000f\t\u0005U\u0011Q\u0004\t\u0004\u0003/\u0019SBAA\r\u0015\r\tYbH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005}1%\u0001\u0004Qe\u0016$WMZ\u0005\u0004{\u0006\r\"bAA\u0010G\u0005qqo\u001c:lKJ,\u0005p\u00197vI\u0016$G\u0003BA\u0015\u0003[\u00012AIA\u0016\u0013\ty6\u0005\u0003\u0004\u000209\u0001\rAZ\u0001\u0007o>\u00148.\u001a:\u0002\u001f]|'o[3s\u0003Z\f\u0017\u000e\\1cY\u0016$B!!\u000b\u00026!1\u0011qF\bA\u0002\u0019\f\u0011d^8sW\u0016\u0014\u0018I^1jY\u0006\u0014G.\u001a\"z\u0019>\u001c\u0017\r^5p]R!\u0011\u0011FA\u001e\u0011\u001d\ti\u0004\u0005a\u0001\u0003\u007f\t1\u0001\\8d!\u0011\t\t%a\u0011\u000e\u0003ML1!!\u0012t\u0005E\u0001\u0016M\u001d;ji&|g\u000eT8dCRLwN\\\u0001\u001bKb\u001cG.\u001e3f/>\u00148.\u001a:Ge>l\u0007+\u0019:uSRLwN\u001c\u000b\t\u0003\u0007\tY%!\u0016\u0002Z!9\u0011QJ\tA\u0002\u0005=\u0013!C:ik\u001a4G.Z%e!\r\u0011\u0013\u0011K\u0005\u0004\u0003'\u001a#aA%oi\"9\u0011qK\tA\u0002\u0005}\u0012\u0001D8mIB\u000b'\u000f^5uS>t\u0007BBA.#\u0001\u0007q.A\u0003dCV\u001cX-A\nsK\u000e|'\u000fZ,pe.,'OR1jYV\u0014X\r\u0006\u0003\u0002\u0004\u0005\u0005\u0004bBA2%\u0001\u0007\u0011QM\u0001\tM\u0006LG.\u001e:fgB!\u0011qMA?\u001d\u0011\tI'!\u001f\u000f\t\u0005-\u0014q\u000f\b\u0005\u0003[\n)H\u0004\u0003\u0002p\u0005Md\u0002BA\f\u0003cJ\u0011AH\u0005\u00039uI!AG\u000e\n\u0005aI\u0012bAA>/\u0005\u0001B*\u001b4fGf\u001cG.Z'b]\u0006<WM]\u0005\u0005\u0003\u007f\n\tI\u0001\u000bTQV4g\r\\3GC&dW\rZ,pe.,'o\u001d\u0006\u0004\u0003w:\u0012!\u0007:f[>4XM\u0012:p[\u0016C8\r\\;eK\u0012<vN]6feN$B!a\u0001\u0002\b\"9\u0011\u0011R\nA\u0002\u0005-\u0015aB<pe.,'o\u001d\t\u0005w\u00065e-C\u0002\u0002\u0010.\u0013q\u0001S1tQN+G/A\fiC:$G.\u001a%fCJ$(-Z1u%\u0016\u001c\bo\u001c8tKR!\u00111AAK\u0011\u001d\t9\n\u0006a\u0001\u00033\u000b1A]3t!\u0011\tY*!,\u000f\t\u0005u\u0015\u0011\u0016\b\u0005\u0003?\u000b9K\u0004\u0003\u0002\"\u0006\u0015f\u0002BA6\u0003GK!\u0001L\r\n\u0005Q\\\u0013B\u0001:t\u0013\r\tY+]\u0001\u0010\u0007>tGO]8m\u001b\u0016\u001c8/Y4fg&!\u0011qVAY\u0005\u0001BU-\u0019:uE\u0016\fGO\u0012:p[\u0006\u0003\b\u000f\\5dCRLwN\u001c*fgB|gn]3\u000b\u0007\u0005-\u0016/\u0001\u000bdkJ\u0014XM\u001c;GC&dW\rZ,pe.,'o]\u000b\u0003\u0003o\u0003B!a\u0005\u0002:&!\u00111XA\u0012\u0005\u0019\u0019FO]5oO\u0002")
public class WorkerStatusTracker
implements Logging {
    private final CelebornConf conf;
    private final LifecycleManager lifecycleManager;
    private final long excludedWorkerExpireTimeout;
    private final ConcurrentHashMap.KeySetView<WorkerStatusListener, Boolean> workerStatusListeners;
    private final ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>> excludedWorkers;
    private final Set<WorkerInfo> shuttingWorkers;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        WorkerStatusTracker workerStatusTracker = this;
        synchronized (workerStatusTracker) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    private long excludedWorkerExpireTimeout() {
        return this.excludedWorkerExpireTimeout;
    }

    private ConcurrentHashMap.KeySetView<WorkerStatusListener, Boolean> workerStatusListeners() {
        return this.workerStatusListeners;
    }

    public ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>> excludedWorkers() {
        return this.excludedWorkers;
    }

    public Set<WorkerInfo> shuttingWorkers() {
        return this.shuttingWorkers;
    }

    public void registerWorkerStatusListener(WorkerStatusListener workerStatusListener) {
        this.workerStatusListeners().add(workerStatusListener);
    }

    public scala.collection.immutable.Set<WorkerInfo> getNeedCheckedWorkers() {
        if (this.conf.clientCheckedUseAllocatedWorkers()) {
            return this.lifecycleManager.getAllocatedWorkers();
        }
        return (scala.collection.immutable.Set)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.excludedWorkers()).asScala()).keys().toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.shuttingWorkers()).asScala()).toSet());
    }

    public boolean workerExcluded(WorkerInfo worker) {
        return this.excludedWorkers().containsKey(worker);
    }

    public boolean workerAvailable(WorkerInfo worker) {
        return !this.excludedWorkers().containsKey(worker) && !this.shuttingWorkers().contains(worker);
    }

    public boolean workerAvailableByLocation(PartitionLocation loc) {
        if (loc == null) {
            return false;
        }
        return this.workerAvailable(loc.getWorker());
    }

    public void excludeWorkerFromPartition(int shuffleId, PartitionLocation oldPartition, StatusCode cause) {
        ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>> failedWorker = new ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>>();
        if (oldPartition != null) {
            StatusCode statusCode = cause;
            if (((Object)((Object)StatusCode.PUSH_DATA_WRITE_FAIL_PRIMARY)).equals((Object)statusCode)) {
                this.excludeWorker$1(oldPartition, StatusCode.PUSH_DATA_WRITE_FAIL_PRIMARY, shuffleId, failedWorker);
            } else if (((Object)((Object)StatusCode.PUSH_DATA_WRITE_FAIL_REPLICA)).equals((Object)statusCode) && oldPartition.hasPeer() && this.conf.clientExcludeReplicaOnFailureEnabled()) {
                this.excludeWorker$1(oldPartition.getPeer(), StatusCode.PUSH_DATA_WRITE_FAIL_REPLICA, shuffleId, failedWorker);
            } else if (((Object)((Object)StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY)).equals((Object)statusCode)) {
                this.excludeWorker$1(oldPartition, StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY, shuffleId, failedWorker);
            } else if (((Object)((Object)StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_REPLICA)).equals((Object)statusCode) && oldPartition.hasPeer() && this.conf.clientExcludeReplicaOnFailureEnabled()) {
                this.excludeWorker$1(oldPartition.getPeer(), StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_REPLICA, shuffleId, failedWorker);
            } else if (((Object)((Object)StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_PRIMARY)).equals((Object)statusCode)) {
                this.excludeWorker$1(oldPartition, StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_PRIMARY, shuffleId, failedWorker);
            } else if (((Object)((Object)StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_REPLICA)).equals((Object)statusCode) && oldPartition.hasPeer() && this.conf.clientExcludeReplicaOnFailureEnabled()) {
                this.excludeWorker$1(oldPartition.getPeer(), StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_REPLICA, shuffleId, failedWorker);
            } else if (((Object)((Object)StatusCode.PUSH_DATA_TIMEOUT_PRIMARY)).equals((Object)statusCode)) {
                this.excludeWorker$1(oldPartition, StatusCode.PUSH_DATA_TIMEOUT_PRIMARY, shuffleId, failedWorker);
            } else if (((Object)((Object)StatusCode.PUSH_DATA_TIMEOUT_REPLICA)).equals((Object)statusCode) && oldPartition.hasPeer() && this.conf.clientExcludeReplicaOnFailureEnabled()) {
                this.excludeWorker$1(oldPartition.getPeer(), StatusCode.PUSH_DATA_TIMEOUT_REPLICA, shuffleId, failedWorker);
            }
        }
        this.recordWorkerFailure(failedWorker);
    }

    public void recordWorkerFailure(ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>> failures) {
        if (!failures.isEmpty()) {
            ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>> failedWorkers = new ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>>(failures);
            String failedWorkersMsg = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(failedWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    WorkerInfo worker = (WorkerInfo)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        StatusCode status = (StatusCode)((Object)((Object)tuple22._1()));
                        long time = tuple22._2$mcJ$sp();
                        return new StringBuilder(6).append(worker.readableAddress()).append("   ").append(status.name()).append("   ").append(Utils$.MODULE$.formatTimestamp(time)).toString();
                    }
                }
                throw new MatchError((Object)tuple2);
            }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(51).append("\n           |Reporting failed workers:\n           |").append(failedWorkersMsg).append(this.currentFailedWorkers()).toString())).stripMargin());
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(failedWorkers).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                block8: {
                    StatusCode statusCode;
                    WorkerInfo worker;
                    block9: {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            StatusCode statusCode2;
                            WorkerInfo worker2 = (WorkerInfo)tuple2._1();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null && ((Object)((Object)StatusCode.WORKER_SHUTDOWN)).equals((Object)(statusCode2 = (StatusCode)((Object)((Object)tuple22._1()))))) {
                                return BoxesRunTime.boxToBoolean((boolean)this.shuttingWorkers().add(worker2));
                            }
                        }
                        if (tuple2 != null) {
                            WorkerInfo worker3 = (WorkerInfo)tuple2._1();
                            Tuple2 tuple23 = (Tuple2)tuple2._2();
                            if (tuple23 != null) {
                                StatusCode statusCode3 = (StatusCode)((Object)((Object)tuple23._1()));
                                long registerTime = tuple23._2$mcJ$sp();
                                if (!this.excludedWorkers().containsKey(worker3)) {
                                    return this.excludedWorkers().put(worker3, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode3, (Object)BoxesRunTime.boxToLong((long)registerTime)));
                                }
                            }
                        }
                        if (tuple2 == null) break block8;
                        worker = (WorkerInfo)tuple2._1();
                        Tuple2 tuple24 = (Tuple2)tuple2._2();
                        if (tuple24 == null) break block8;
                        StatusCode statusCode4 = statusCode = (StatusCode)((Object)((Object)tuple24._1()));
                        StatusCode statusCode5 = StatusCode.NO_AVAILABLE_WORKING_DIR;
                        if (!(statusCode4 == null ? statusCode5 != null : !((Object)((Object)statusCode4)).equals((Object)statusCode5))) break block9;
                        StatusCode statusCode6 = statusCode;
                        StatusCode statusCode7 = StatusCode.RESERVE_SLOTS_FAILED;
                        if (!(statusCode6 == null ? statusCode7 != null : !((Object)((Object)statusCode6)).equals((Object)statusCode7))) break block9;
                        StatusCode statusCode8 = statusCode;
                        StatusCode statusCode9 = StatusCode.WORKER_UNKNOWN;
                        if (statusCode8 != null ? !((Object)((Object)statusCode8)).equals((Object)statusCode9) : statusCode9 != null) break block8;
                    }
                    return this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)this.excludedWorkers().get(worker)._2$mcJ$sp())));
                }
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void removeFromExcludedWorkers(HashSet<WorkerInfo> workers) {
        ((ConcurrentHashMap.KeySetView)this.excludedWorkers().keySet()).removeAll(workers);
    }

    public void handleHeartbeatResponse(ControlMessages.HeartbeatFromApplicationResponse res) {
        StatusCode statusCode = res.statusCode();
        StatusCode statusCode2 = StatusCode.SUCCESS;
        if (!(statusCode != null ? !((Object)((Object)statusCode)).equals((Object)statusCode2) : statusCode2 != null)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Received Worker status from Primary, excluded workers: ").append(res.excludedWorkers()).append(" ").append("unknown workers: ").append(res.unknownWorkers()).append(", shutdown workers: ").append(res.shuttingWorkers()).toString());
            long current = System.currentTimeMillis();
            BooleanRef statusChanged = BooleanRef.create((boolean)false);
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.excludedWorkers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                WorkerStatusTracker.$anonfun$handleHeartbeatResponse$2(this, current, res, statusChanged, x0$1);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res.excludedWorkers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)worker -> {
                WorkerStatusTracker.$anonfun$handleHeartbeatResponse$3(this, current, statusChanged, worker);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res.unknownWorkers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)worker -> {
                WorkerStatusTracker.$anonfun$handleHeartbeatResponse$4(this, current, statusChanged, worker);
                return BoxedUnit.UNIT;
            });
            boolean retainShuttingWorkersResult = this.shuttingWorkers().retainAll(res.shuttingWorkers());
            boolean addShuttingWorkersResult = this.shuttingWorkers().addAll(res.shuttingWorkers());
            boolean bl = statusChanged.elem = statusChanged.elem || retainShuttingWorkersResult || addShuttingWorkersResult;
            if (!res.unknownWorkers().isEmpty() || !res.shuttingWorkers().isEmpty()) {
                WorkersStatus workerStatus = new WorkersStatus(res.unknownWorkers(), res.shuttingWorkers());
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.workerStatusListeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)listener -> {
                    WorkerStatusTracker.$anonfun$handleHeartbeatResponse$5(this, workerStatus, listener);
                    return BoxedUnit.UNIT;
                });
            }
            if (statusChanged.elem) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Worker status changed from application heartbeat response.").append(this.currentFailedWorkers()).toString());
                return;
            }
            return;
        }
    }

    private String currentFailedWorkers() {
        String failedWorkersMsg;
        block2: {
            Map excludedWorkersMsg = (Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.excludedWorkers()).asScala()).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> (StatusCode)((Object)((Object)((Tuple2)x$2._2())._1()))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    StatusCode status = (StatusCode)((Object)((Object)tuple2._1()));
                    scala.collection.mutable.Map workers = (scala.collection.mutable.Map)tuple2._2();
                    return new Tuple2((Object)status, (Object)((TraversableOnce)workers.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            WorkerInfo worker = (WorkerInfo)tuple2._1();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                long time = tuple22._2$mcJ$sp();
                                return new StringBuilder(3).append(worker.readableAddress()).append("   ").append(Utils$.MODULE$.formatTimestamp(time)).toString();
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }, Iterable$.MODULE$.canBuildFrom())).mkString("\n"));
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom());
            String shutdownWorkersMsg = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.shuttingWorkers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.readableAddress(), Set$.MODULE$.canBuildFrom())).mkString("\n");
            failedWorkersMsg = "";
            if (excludedWorkersMsg.contains((Object)StatusCode.WORKER_EXCLUDED)) {
                failedWorkersMsg = new StringBuilder(0).append(failedWorkersMsg).append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(51).append("\n           |Current excluded workers:\n           |").append(excludedWorkersMsg.apply((Object)StatusCode.WORKER_EXCLUDED)).toString())).stripMargin()).toString();
            }
            if (excludedWorkersMsg.contains((Object)StatusCode.WORKER_UNKNOWN)) {
                failedWorkersMsg = new StringBuilder(0).append(failedWorkersMsg).append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(50).append("\n           |Current unknown workers:\n           |").append(excludedWorkersMsg.apply((Object)StatusCode.WORKER_UNKNOWN)).toString())).stripMargin()).toString();
            }
            if (!new StringOps(Predef$.MODULE$.augmentString(shutdownWorkersMsg)).nonEmpty()) break block2;
            failedWorkersMsg = new StringBuilder(0).append(failedWorkersMsg).append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(51).append("\n           |Current shutdown workers:\n           |").append(shutdownWorkersMsg).toString())).stripMargin()).toString();
        }
        return failedWorkersMsg;
    }

    private final void excludeWorker$1(PartitionLocation partition, StatusCode statusCode, int shuffleId$1, ConcurrentHashMap failedWorker$1) {
        WorkerInfo tmpWorker = partition.getWorker();
        Option worker = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.lifecycleManager.workerSnapshots(shuffleId$1)).asScala()).get((Object)tmpWorker.toUniqueId()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.workerInfo());
        if (worker.isDefined()) {
            failedWorker$1.put(worker.get(), new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleHeartbeatResponse$2(WorkerStatusTracker $this, long current$1, ControlMessages.HeartbeatFromApplicationResponse res$1, BooleanRef statusChanged$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            WorkerInfo workerInfo = (WorkerInfo)tuple2._1();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (workerInfo != null) {
                WorkerInfo workerInfo2 = workerInfo;
                if (tuple22 != null) {
                    StatusCode statusCode = (StatusCode)((Object)tuple22._1());
                    long registerTime = tuple22._2$mcJ$sp();
                    StatusCode statusCode2 = statusCode;
                    if ((((Object)((Object)StatusCode.WORKER_UNKNOWN)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.WORKER_UNRESPONSIVE)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.COMMIT_FILE_EXCEPTION)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.NO_AVAILABLE_WORKING_DIR)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.RESERVE_SLOTS_FAILED)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_REPLICA)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_PRIMARY)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_REPLICA)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.PUSH_DATA_TIMEOUT_PRIMARY)).equals((Object)statusCode2) ? true : ((Object)((Object)StatusCode.PUSH_DATA_TIMEOUT_REPLICA)).equals((Object)statusCode2))))))))))) && current$1 - registerTime < $this.excludedWorkerExpireTimeout()) {
                    } else if (!(res$1.excludedWorkers().contains(workerInfo2) || res$1.shuttingWorkers().contains(workerInfo2) || res$1.unknownWorkers().contains(workerInfo2))) {
                        $this.excludedWorkers().remove(workerInfo2);
                        statusChanged$1.elem = true;
                    }
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$handleHeartbeatResponse$3(WorkerStatusTracker $this, long current$1, BooleanRef statusChanged$1, WorkerInfo worker) {
        if (!$this.excludedWorkers().containsKey(worker)) {
            $this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)StatusCode.WORKER_EXCLUDED, (Object)BoxesRunTime.boxToLong((long)current$1)));
            statusChanged$1.elem = true;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleHeartbeatResponse$4(WorkerStatusTracker $this, long current$1, BooleanRef statusChanged$1, WorkerInfo worker) {
        if (!$this.excludedWorkers().containsKey(worker)) {
            $this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)StatusCode.WORKER_UNKNOWN, (Object)BoxesRunTime.boxToLong((long)current$1)));
            statusChanged$1.elem = true;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleHeartbeatResponse$5(WorkerStatusTracker $this, WorkersStatus workerStatus$1, WorkerStatusListener listener) {
        try {
            listener.notifyChangedWorkersStatus(workerStatus$1);
        }
        catch (Throwable t) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while notify listener", t);
        }
    }

    public WorkerStatusTracker(CelebornConf conf, LifecycleManager lifecycleManager) {
        this.conf = conf;
        this.lifecycleManager = lifecycleManager;
        Logging.$init$(this);
        this.excludedWorkerExpireTimeout = conf.clientExcludedWorkerExpireTimeout();
        this.workerStatusListeners = ConcurrentHashMap.newKeySet();
        this.excludedWorkers = new ConcurrentHashMap();
        this.shuttingWorkers = new HashSet<WorkerInfo>();
    }
}

