/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.compress;

import java.io.IOException;
import org.apache.celeborn.client.compress.Lz4Decompressor;
import org.apache.celeborn.client.compress.Lz4Trait;
import org.apache.celeborn.client.compress.ZstdDecompressor;
import org.apache.celeborn.client.compress.ZstdTrait;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.protocol.CompressionCodec;
import scala.Option;

public interface Decompressor {
    public int decompress(byte[] var1, byte[] var2, int var3) throws IOException;

    public int getOriginalLen(byte[] var1);

    default public int readIntLE(byte[] buf, int i) {
        return buf[i] & 0xFF | (buf[i + 1] & 0xFF) << 8 | (buf[i + 2] & 0xFF) << 16 | (buf[i + 3] & 0xFF) << 24;
    }

    public static Decompressor getDecompressor(CelebornConf conf) {
        CompressionCodec codec = conf.shuffleCompressionCodec();
        switch (codec) {
            case LZ4: {
                Option<String> xxHashInstance = conf.shuffleDecompressionLz4XXHashInstance();
                return new Lz4Decompressor(xxHashInstance);
            }
            case ZSTD: {
                return new ZstdDecompressor();
            }
        }
        throw new IllegalArgumentException("Unknown compression codec: " + (Object)((Object)codec));
    }

    public static int getCompressionHeaderLength(CelebornConf conf) {
        CompressionCodec codec = conf.shuffleCompressionCodec();
        switch (codec) {
            case LZ4: {
                return Lz4Trait.HEADER_LENGTH;
            }
            case ZSTD: {
                return ZstdTrait.HEADER_LENGTH;
            }
        }
        throw new IllegalArgumentException("Unknown compression codec: " + (Object)((Object)codec));
    }
}

