/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Locale;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SolrCliTest {
    public static final String ZK_HOST = "localhost:9983";
    public static final String DEFAULT_CONFIG_SET = "_default";
    public static final Option OPTION_ZKHOST_DEPRECATED = Option.builder((String)"zkHost").longOpt("zkHost").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.6").setDescription("Use --zk-host instead").get()).argName("HOST").hasArg().required(false).desc("Zookeeper connection string; unnecessary if ZK_HOST is defined in solr.in.sh; otherwise, defaults to localhost:9983.").get();
    public static final Option OPTION_ZKHOST = Option.builder((String)"z").longOpt("zk-host").argName("HOST").hasArg().required(false).desc("Zookeeper connection string; unnecessary if ZK_HOST is defined in solr.in.sh; otherwise, defaults to localhost:9983.").get();
    public static final Option OPTION_SOLRURL_DEPRECATED = Option.builder((String)"solrUrl").longOpt("solrUrl").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.6").setDescription("Use --solr-url instead").get()).argName("HOST").hasArg().required(false).desc("Base Solr URL, which can be used to determine the zk-host if that's not known; defaults to: " + SolrCliTest.getDefaultSolrUrl() + '.').get();
    public static final Option OPTION_SOLRURL = Option.builder((String)"url").longOpt("solr-url").argName("HOST").hasArg().required(false).desc("Base Solr URL, which can be used to determine the zk-host if that's not known; defaults to: " + SolrCliTest.getDefaultSolrUrl() + '.').get();
    public static final Option OPTION_VERBOSE = Option.builder((String)"v").longOpt("verbose").argName("verbose").required(false).desc("Enable more verbose command output.").get();
    public static final Option OPTION_HELP = Option.builder((String)"h").longOpt("help").required(false).desc("Print this message.").get();
    public static final Option OPTION_RECURSE = Option.builder((String)"r").longOpt("recurse").argName("recurse").hasArg().required(false).desc("Recurse (true|false), default is false.").get();
    public static final Option OPTION_CREDENTIALS = Option.builder((String)"u").longOpt("credentials").argName("credentials").hasArg().required(false).desc("Credentials in the format username:password. Example: --credentials solr:SolrRocks").get();

    SolrCliTest() {
    }

    private static String getDefaultSolrUrl() {
        String scheme = "http";
        String host = "localhost";
        String port = "8983";
        return String.format(Locale.ROOT, "%s://%s:%s", StringUtils.toRootLowerCase((String)"http"), "localhost", "8983");
    }

    @Test
    void testOptions() {
        Assertions.assertNotNull((Object)DEFAULT_CONFIG_SET);
        Assertions.assertNotNull((Object)OPTION_CREDENTIALS);
        Assertions.assertNotNull((Object)OPTION_HELP);
        Assertions.assertNotNull((Object)OPTION_RECURSE);
        Assertions.assertNotNull((Object)OPTION_SOLRURL);
        Assertions.assertNotNull((Object)OPTION_SOLRURL_DEPRECATED);
        Assertions.assertNotNull((Object)OPTION_VERBOSE);
        Assertions.assertNotNull((Object)OPTION_ZKHOST);
        Assertions.assertNotNull((Object)OPTION_ZKHOST_DEPRECATED);
        Assertions.assertNotNull((Object)ZK_HOST);
        Assertions.assertNotNull((Object)SolrCliTest.getDefaultSolrUrl());
    }
}

