/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class UnsynchronizedByteArrayInputStreamTest {
    UnsynchronizedByteArrayInputStreamTest() {
    }

    private UnsynchronizedByteArrayInputStream newStream(byte[] buffer) {
        try {
            return UnsynchronizedByteArrayInputStream.builder().setByteArray(buffer).get();
        }
        catch (IOException e) {
            Assertions.fail((String)"Should never happen because no conversion is needed.", (Throwable)e);
            return null;
        }
    }

    private UnsynchronizedByteArrayInputStream newStream(byte[] buffer, int offset) {
        try {
            return UnsynchronizedByteArrayInputStream.builder().setByteArray(buffer).setOffset(offset).get();
        }
        catch (IOException e) {
            Assertions.fail((String)"Should never happen because no conversion is needed.", (Throwable)e);
            return null;
        }
    }

    private UnsynchronizedByteArrayInputStream newStream(byte[] buffer, int offset, int length) {
        try {
            return UnsynchronizedByteArrayInputStream.builder().setByteArray(buffer).setOffset(offset).setLength(length).get();
        }
        catch (IOException e) {
            Assertions.fail((String)"Should never happen because no conversion is needed.", (Throwable)e);
            return null;
        }
    }

    @Test
    void testConstructor1() throws IOException {
        byte[] empty = IOUtils.EMPTY_BYTE_ARRAY;
        byte[] one = new byte[1];
        byte[] some = new byte[25];
        try (UnsynchronizedByteArrayInputStream is = this.newStream(empty);){
            Assertions.assertEquals((int)empty.length, (int)is.available());
        }
        is = this.newStream(one);
        try {
            Assertions.assertEquals((int)one.length, (int)is.available());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        is = this.newStream(some);
        try {
            Assertions.assertEquals((int)some.length, (int)is.available());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Test
    void testConstructor2() {
        byte[] empty = IOUtils.EMPTY_BYTE_ARRAY;
        byte[] one = new byte[1];
        byte[] some = new byte[25];
        UnsynchronizedByteArrayInputStream is = this.newStream(empty, 0);
        Assertions.assertEquals((int)empty.length, (int)is.available());
        is = this.newStream(empty, 1);
        Assertions.assertEquals((int)0, (int)is.available());
        is = this.newStream(one, 0);
        Assertions.assertEquals((int)one.length, (int)is.available());
        is = this.newStream(one, 1);
        Assertions.assertEquals((int)0, (int)is.available());
        is = this.newStream(one, 2);
        Assertions.assertEquals((int)0, (int)is.available());
        is = this.newStream(some, 0);
        Assertions.assertEquals((int)some.length, (int)is.available());
        is = this.newStream(some, 1);
        Assertions.assertEquals((int)(some.length - 1), (int)is.available());
        is = this.newStream(some, 10);
        Assertions.assertEquals((int)(some.length - 10), (int)is.available());
        is = this.newStream(some, some.length);
        Assertions.assertEquals((int)0, (int)is.available());
    }

    @Test
    void testConstructor3() {
        byte[] empty = IOUtils.EMPTY_BYTE_ARRAY;
        byte[] one = new byte[1];
        byte[] some = new byte[25];
        UnsynchronizedByteArrayInputStream is = this.newStream(empty, 0);
        Assertions.assertEquals((int)empty.length, (int)is.available());
        is = this.newStream(empty, 1);
        Assertions.assertEquals((int)0, (int)is.available());
        is = this.newStream(empty, 0, 1);
        Assertions.assertEquals((int)0, (int)is.available());
        is = this.newStream(empty, 1, 1);
        Assertions.assertEquals((int)0, (int)is.available());
        is = this.newStream(one, 0);
        Assertions.assertEquals((int)one.length, (int)is.available());
        is = this.newStream(one, 1);
        Assertions.assertEquals((int)(one.length - 1), (int)is.available());
        is = this.newStream(one, 2);
        Assertions.assertEquals((int)0, (int)is.available());
        is = this.newStream(one, 0, 1);
        Assertions.assertEquals((int)1, (int)is.available());
        is = this.newStream(one, 1, 1);
        Assertions.assertEquals((int)0, (int)is.available());
        is = this.newStream(one, 0, 2);
        Assertions.assertEquals((int)1, (int)is.available());
        is = this.newStream(one, 2, 1);
        Assertions.assertEquals((int)0, (int)is.available());
        is = this.newStream(one, 2, 2);
        Assertions.assertEquals((int)0, (int)is.available());
        is = this.newStream(some, 0);
        Assertions.assertEquals((int)some.length, (int)is.available());
        is = this.newStream(some, 1);
        Assertions.assertEquals((int)(some.length - 1), (int)is.available());
        is = this.newStream(some, 10);
        Assertions.assertEquals((int)(some.length - 10), (int)is.available());
        is = this.newStream(some, some.length);
        Assertions.assertEquals((int)0, (int)is.available());
        is = this.newStream(some, some.length, some.length);
        Assertions.assertEquals((int)0, (int)is.available());
        is = this.newStream(some, some.length - 1, some.length);
        Assertions.assertEquals((int)1, (int)is.available());
        is = this.newStream(some, 0, 7);
        Assertions.assertEquals((int)7, (int)is.available());
        is = this.newStream(some, 7, 7);
        Assertions.assertEquals((int)7, (int)is.available());
        is = this.newStream(some, 0, some.length * 2);
        Assertions.assertEquals((int)some.length, (int)is.available());
        is = this.newStream(some, some.length - 1, 7);
        Assertions.assertEquals((int)1, (int)is.available());
    }

    @Test
    void testInvalidConstructor2OffsetUnder() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.newStream(IOUtils.EMPTY_BYTE_ARRAY, -1));
    }

    @Test
    void testInvalidConstructor3LengthUnder() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.newStream(IOUtils.EMPTY_BYTE_ARRAY, 0, -1));
    }

    @Test
    void testInvalidConstructor3OffsetUnder() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.newStream(IOUtils.EMPTY_BYTE_ARRAY, -1, 1));
    }

    @Test
    void testInvalidReadArrayExplicitLenUnder() {
        byte[] buf = IOUtils.EMPTY_BYTE_ARRAY;
        UnsynchronizedByteArrayInputStream is = this.newStream(new byte[]{10, 11, 12});
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> is.read(buf, 0, -1));
    }

    @Test
    void testInvalidReadArrayExplicitOffsetUnder() {
        byte[] buf = IOUtils.EMPTY_BYTE_ARRAY;
        UnsynchronizedByteArrayInputStream is = this.newStream(new byte[]{10, 11, 12});
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> is.read(buf, -1, 1));
    }

    @Test
    void testInvalidReadArrayExplicitRangeOver() {
        byte[] buf = IOUtils.EMPTY_BYTE_ARRAY;
        UnsynchronizedByteArrayInputStream is = this.newStream(new byte[]{10, 11, 12});
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> is.read(buf, 0, 1));
    }

    @Test
    void testInvalidReadArrayNull() {
        byte[] buf = null;
        UnsynchronizedByteArrayInputStream is = this.newStream(new byte[]{10, 11, 12});
        Assertions.assertThrows(NullPointerException.class, () -> is.read(buf));
    }

    @Test
    void testInvalidSkipNUnder() {
        UnsynchronizedByteArrayInputStream is = this.newStream(new byte[]{10, 11, 12});
        Assertions.assertThrows(IllegalArgumentException.class, () -> is.skip(-1L));
    }

    @Test
    void testMarkReset() {
        UnsynchronizedByteArrayInputStream is = this.newStream(new byte[]{10, 11, 12});
        Assertions.assertTrue((boolean)is.markSupported());
        Assertions.assertEquals((int)10, (int)is.read());
        Assertions.assertTrue((boolean)is.markSupported());
        is.mark(10);
        Assertions.assertEquals((int)11, (int)is.read());
        Assertions.assertEquals((int)12, (int)is.read());
        is.reset();
        Assertions.assertEquals((int)11, (int)is.read());
        Assertions.assertEquals((int)12, (int)is.read());
        Assertions.assertEquals((int)-1, (int)is.read());
        is.reset();
        Assertions.assertEquals((int)11, (int)is.read());
        Assertions.assertEquals((int)12, (int)is.read());
        Assertions.assertEquals((int)-1, (int)is.read());
    }

    @Test
    void testReadArray() {
        byte[] buf = new byte[10];
        UnsynchronizedByteArrayInputStream is = this.newStream(IOUtils.EMPTY_BYTE_ARRAY);
        int read = is.read(buf);
        Assertions.assertEquals((int)-1, (int)read);
        Assertions.assertArrayEquals((byte[])new byte[10], (byte[])buf);
        buf = IOUtils.EMPTY_BYTE_ARRAY;
        is = this.newStream(new byte[]{10, 11, 12});
        read = is.read(buf);
        Assertions.assertEquals((int)0, (int)read);
        buf = new byte[10];
        is = this.newStream(new byte[]{10, 11, 12});
        read = is.read(buf);
        Assertions.assertEquals((int)3, (int)read);
        Assertions.assertEquals((int)10, (int)buf[0]);
        Assertions.assertEquals((int)11, (int)buf[1]);
        Assertions.assertEquals((int)12, (int)buf[2]);
        Assertions.assertEquals((int)0, (int)buf[3]);
        buf = new byte[2];
        is = this.newStream(new byte[]{10, 11, 12});
        read = is.read(buf);
        Assertions.assertEquals((int)2, (int)read);
        Assertions.assertEquals((int)10, (int)buf[0]);
        Assertions.assertEquals((int)11, (int)buf[1]);
        read = is.read(buf);
        Assertions.assertEquals((int)1, (int)read);
        Assertions.assertEquals((int)12, (int)buf[0]);
    }

    @Test
    void testReadArrayExplicit() {
        byte[] buf = new byte[10];
        UnsynchronizedByteArrayInputStream is = this.newStream(IOUtils.EMPTY_BYTE_ARRAY);
        int read = is.read(buf, 0, 10);
        Assertions.assertEquals((int)-1, (int)read);
        Assertions.assertArrayEquals((byte[])new byte[10], (byte[])buf);
        buf = new byte[10];
        is = this.newStream(IOUtils.EMPTY_BYTE_ARRAY);
        read = is.read(buf, 4, 2);
        Assertions.assertEquals((int)-1, (int)read);
        Assertions.assertArrayEquals((byte[])new byte[10], (byte[])buf);
        buf = new byte[10];
        is = this.newStream(IOUtils.EMPTY_BYTE_ARRAY);
        read = is.read(buf, 4, 6);
        Assertions.assertEquals((int)-1, (int)read);
        Assertions.assertArrayEquals((byte[])new byte[10], (byte[])buf);
        buf = IOUtils.EMPTY_BYTE_ARRAY;
        is = this.newStream(new byte[]{10, 11, 12});
        read = is.read(buf, 0, 0);
        Assertions.assertEquals((int)0, (int)read);
        buf = new byte[10];
        is = this.newStream(new byte[]{10, 11, 12});
        read = is.read(buf, 0, 2);
        Assertions.assertEquals((int)2, (int)read);
        Assertions.assertEquals((int)10, (int)buf[0]);
        Assertions.assertEquals((int)11, (int)buf[1]);
        Assertions.assertEquals((int)0, (int)buf[2]);
        read = is.read(buf, 0, 10);
        Assertions.assertEquals((int)1, (int)read);
        Assertions.assertEquals((int)12, (int)buf[0]);
    }

    @Test
    void testReadSingle() {
        UnsynchronizedByteArrayInputStream is = this.newStream(IOUtils.EMPTY_BYTE_ARRAY);
        Assertions.assertEquals((int)-1, (int)is.read());
        is = this.newStream(new byte[]{10, 11, 12});
        Assertions.assertEquals((int)10, (int)is.read());
        Assertions.assertEquals((int)11, (int)is.read());
        Assertions.assertEquals((int)12, (int)is.read());
        Assertions.assertEquals((int)-1, (int)is.read());
    }

    @Test
    void testSkip() {
        UnsynchronizedByteArrayInputStream is = this.newStream(new byte[]{10, 11, 12});
        Assertions.assertEquals((int)3, (int)is.available());
        is.skip(1L);
        Assertions.assertEquals((int)2, (int)is.available());
        Assertions.assertEquals((int)11, (int)is.read());
        is.skip(1L);
        Assertions.assertEquals((int)0, (int)is.available());
        Assertions.assertEquals((int)-1, (int)is.read());
        is = this.newStream(new byte[]{10, 11, 12});
        Assertions.assertEquals((int)3, (int)is.available());
        is.skip(0L);
        Assertions.assertEquals((int)3, (int)is.available());
        Assertions.assertEquals((int)10, (int)is.read());
        is = this.newStream(new byte[]{10, 11, 12});
        Assertions.assertEquals((int)3, (int)is.available());
        is.skip(2L);
        Assertions.assertEquals((int)1, (int)is.available());
        Assertions.assertEquals((int)12, (int)is.read());
        Assertions.assertEquals((int)-1, (int)is.read());
        is = this.newStream(new byte[]{10, 11, 12});
        Assertions.assertEquals((int)3, (int)is.available());
        is.skip(3L);
        Assertions.assertEquals((int)0, (int)is.available());
        Assertions.assertEquals((int)-1, (int)is.read());
        is = this.newStream(new byte[]{10, 11, 12});
        Assertions.assertEquals((int)3, (int)is.available());
        is.skip(999L);
        Assertions.assertEquals((int)0, (int)is.available());
        Assertions.assertEquals((int)-1, (int)is.read());
    }
}

