/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.protobuf;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.druid.data.input.protobuf.ProtobufBytesDecoder;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.parsers.ParseException;

public abstract class DescriptorBasedProtobufBytesDecoder
implements ProtobufBytesDecoder {
    private Descriptors.Descriptor descriptor;
    @Nullable
    private final String protoMessageType;

    public DescriptorBasedProtobufBytesDecoder(@Nullable String protoMessageType) {
        this.protoMessageType = protoMessageType;
    }

    @JsonProperty
    @Nullable
    public String getProtoMessageType() {
        return this.protoMessageType;
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.descriptor;
    }

    @VisibleForTesting
    void initializeDescriptor() {
        if (this.descriptor == null) {
            DescriptorProtos.FileDescriptorSet descriptorSet = this.loadFileDescriptorSet();
            this.descriptor = this.buildMessageDescriptor(descriptorSet);
        }
    }

    @Override
    public DynamicMessage parse(ByteBuffer bytes) {
        if (this.descriptor == null) {
            throw new IAE("Descriptor needs to be initialized before parsing", new Object[0]);
        }
        try {
            return DynamicMessage.parseFrom(this.descriptor, ByteString.copyFrom(bytes));
        }
        catch (Exception e) {
            throw new ParseException(null, (Throwable)e, "Failed to decode protobuf message with the provided descriptor [%s]", new Object[]{this.descriptor.getFullName()});
        }
    }

    protected abstract DescriptorProtos.FileDescriptorSet loadFileDescriptorSet();

    protected Descriptors.Descriptor buildMessageDescriptor(DescriptorProtos.FileDescriptorSet descriptorSet) {
        try {
            HashMap<String, Descriptors.FileDescriptor> allDescriptors = new HashMap<String, Descriptors.FileDescriptor>();
            for (DescriptorProtos.FileDescriptorProto fileProto : descriptorSet.getFileList()) {
                this.buildFileDescriptor(fileProto, descriptorSet, allDescriptors);
            }
            if (this.protoMessageType == null) {
                for (Descriptors.FileDescriptor fileDescriptor : allDescriptors.values()) {
                    if (fileDescriptor.getMessageTypes().isEmpty()) continue;
                    return fileDescriptor.getMessageTypes().get(0);
                }
                throw new ParseException(null, "No message types found in the descriptor set", new Object[0]);
            }
            for (Descriptors.FileDescriptor fileDescriptor : allDescriptors.values()) {
                Descriptors.Descriptor desc = this.findMessageByName(fileDescriptor, this.protoMessageType);
                if (desc == null) continue;
                return desc;
            }
            TreeSet<String> availableTypes = new TreeSet<String>();
            for (Descriptors.FileDescriptor fileDescriptor : allDescriptors.values()) {
                this.collectAvailableTypes(fileDescriptor, availableTypes);
            }
            throw new ParseException(null, "Protobuf message type [%s] not found in the descriptor set. Available types: %s", new Object[]{this.protoMessageType, availableTypes});
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new ParseException(null, (Throwable)e, "Invalid protobuf descriptor", new Object[0]);
        }
    }

    @Nullable
    private Descriptors.Descriptor findMessageByName(Descriptors.FileDescriptor fileDescriptor, String messageTypeName) {
        for (Descriptors.Descriptor messageType : fileDescriptor.getMessageTypes()) {
            if (messageType.getName().equals(messageTypeName) || messageType.getFullName().equals(messageTypeName)) {
                return messageType;
            }
            Descriptors.Descriptor nested = this.findNestedMessage(messageType, messageTypeName);
            if (nested == null) continue;
            return nested;
        }
        return null;
    }

    @Nullable
    private Descriptors.Descriptor findNestedMessage(Descriptors.Descriptor parent, String messageTypeName) {
        for (Descriptors.Descriptor nested : parent.getNestedTypes()) {
            if (nested.getName().equals(messageTypeName) || nested.getFullName().equals(messageTypeName) || (parent.getName() + "." + nested.getName()).equals(messageTypeName)) {
                return nested;
            }
            Descriptors.Descriptor deeperNested = this.findNestedMessage(nested, messageTypeName);
            if (deeperNested == null) continue;
            return deeperNested;
        }
        return null;
    }

    private Descriptors.FileDescriptor buildFileDescriptor(DescriptorProtos.FileDescriptorProto fileProto, DescriptorProtos.FileDescriptorSet descriptorSet, Map<String, Descriptors.FileDescriptor> builtDescriptors) throws Descriptors.DescriptorValidationException {
        if (builtDescriptors.containsKey(fileProto.getName())) {
            return builtDescriptors.get(fileProto.getName());
        }
        ArrayList<Descriptors.FileDescriptor> dependencies = new ArrayList<Descriptors.FileDescriptor>();
        block0: for (String dependencyName : fileProto.getDependencyList()) {
            for (DescriptorProtos.FileDescriptorProto depProto : descriptorSet.getFileList()) {
                if (!depProto.getName().equals(dependencyName)) continue;
                Descriptors.FileDescriptor depDescriptor = this.buildFileDescriptor(depProto, descriptorSet, builtDescriptors);
                dependencies.add(depDescriptor);
                continue block0;
            }
        }
        Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom(fileProto, dependencies.toArray(new Descriptors.FileDescriptor[0]));
        builtDescriptors.put(fileProto.getName(), fileDescriptor);
        return fileDescriptor;
    }

    private void collectAvailableTypes(Descriptors.FileDescriptor fileDescriptor, TreeSet<String> availableTypes) {
        for (Descriptors.Descriptor messageType : fileDescriptor.getMessageTypes()) {
            availableTypes.add(messageType.getName());
            availableTypes.add(messageType.getFullName());
            this.collectNestedTypes(messageType, availableTypes);
        }
    }

    private void collectNestedTypes(Descriptors.Descriptor parentDescriptor, TreeSet<String> availableTypes) {
        for (Descriptors.Descriptor nestedType : parentDescriptor.getNestedTypes()) {
            availableTypes.add(nestedType.getName());
            availableTypes.add(nestedType.getFullName());
            availableTypes.add(parentDescriptor.getName() + "." + nestedType.getName());
            this.collectNestedTypes(nestedType, availableTypes);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescriptorBasedProtobufBytesDecoder that = (DescriptorBasedProtobufBytesDecoder)o;
        return Objects.equals(this.getProtoMessageType(), that.getProtoMessageType());
    }

    public int hashCode() {
        return Objects.hash(this.getProtoMessageType());
    }
}

