/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1alpha1ServerStorageVersion;
import io.kubernetes.client.openapi.models.V1alpha1ServerStorageVersionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha1ServerStorageVersionFluentImpl<A extends V1alpha1ServerStorageVersionFluent<A>>
extends BaseFluent<A>
implements V1alpha1ServerStorageVersionFluent<A> {
    private String apiServerID;
    private List<String> decodableVersions;
    private String encodingVersion;

    public V1alpha1ServerStorageVersionFluentImpl() {
    }

    public V1alpha1ServerStorageVersionFluentImpl(V1alpha1ServerStorageVersion instance) {
        if (instance != null) {
            this.withApiServerID(instance.getApiServerID());
            this.withDecodableVersions(instance.getDecodableVersions());
            this.withEncodingVersion(instance.getEncodingVersion());
        }
    }

    @Override
    public String getApiServerID() {
        return this.apiServerID;
    }

    @Override
    public A withApiServerID(String apiServerID) {
        this.apiServerID = apiServerID;
        return (A)this;
    }

    @Override
    public Boolean hasApiServerID() {
        return this.apiServerID != null;
    }

    @Override
    public A addToDecodableVersions(int index, String item) {
        if (this.decodableVersions == null) {
            this.decodableVersions = new ArrayList<String>();
        }
        this.decodableVersions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDecodableVersions(int index, String item) {
        if (this.decodableVersions == null) {
            this.decodableVersions = new ArrayList<String>();
        }
        this.decodableVersions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDecodableVersions(String ... items) {
        if (this.decodableVersions == null) {
            this.decodableVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.decodableVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDecodableVersions(Collection<String> items) {
        if (this.decodableVersions == null) {
            this.decodableVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.decodableVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDecodableVersions(String ... items) {
        for (String item : items) {
            if (this.decodableVersions == null) continue;
            this.decodableVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDecodableVersions(Collection<String> items) {
        for (String item : items) {
            if (this.decodableVersions == null) continue;
            this.decodableVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDecodableVersions() {
        return this.decodableVersions;
    }

    @Override
    public String getDecodableVersion(int index) {
        return this.decodableVersions.get(index);
    }

    @Override
    public String getFirstDecodableVersion() {
        return this.decodableVersions.get(0);
    }

    @Override
    public String getLastDecodableVersion() {
        return this.decodableVersions.get(this.decodableVersions.size() - 1);
    }

    @Override
    public String getMatchingDecodableVersion(Predicate<String> predicate) {
        for (String item : this.decodableVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDecodableVersion(Predicate<String> predicate) {
        for (String item : this.decodableVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDecodableVersions(List<String> decodableVersions) {
        if (decodableVersions != null) {
            this.decodableVersions = new ArrayList<String>();
            for (String item : decodableVersions) {
                this.addToDecodableVersions(item);
            }
        } else {
            this.decodableVersions = null;
        }
        return (A)this;
    }

    @Override
    public A withDecodableVersions(String ... decodableVersions) {
        if (this.decodableVersions != null) {
            this.decodableVersions.clear();
            this._visitables.remove("decodableVersions");
        }
        if (decodableVersions != null) {
            for (String item : decodableVersions) {
                this.addToDecodableVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDecodableVersions() {
        return this.decodableVersions != null && !this.decodableVersions.isEmpty();
    }

    @Override
    public String getEncodingVersion() {
        return this.encodingVersion;
    }

    @Override
    public A withEncodingVersion(String encodingVersion) {
        this.encodingVersion = encodingVersion;
        return (A)this;
    }

    @Override
    public Boolean hasEncodingVersion() {
        return this.encodingVersion != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha1ServerStorageVersionFluentImpl that = (V1alpha1ServerStorageVersionFluentImpl)o;
        if (!Objects.equals(this.apiServerID, that.apiServerID)) {
            return false;
        }
        if (!Objects.equals(this.decodableVersions, that.decodableVersions)) {
            return false;
        }
        return Objects.equals(this.encodingVersion, that.encodingVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiServerID, this.decodableVersions, this.encodingVersion, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiServerID != null) {
            sb.append("apiServerID:");
            sb.append(this.apiServerID + ",");
        }
        if (this.decodableVersions != null && !this.decodableVersions.isEmpty()) {
            sb.append("decodableVersions:");
            sb.append(this.decodableVersions + ",");
        }
        if (this.encodingVersion != null) {
            sb.append("encodingVersion:");
            sb.append(this.encodingVersion);
        }
        sb.append("}");
        return sb.toString();
    }
}

