/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1NodeSelectorBuilder;
import io.kubernetes.client.openapi.models.V1NodeSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClass;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClassFluent;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClassParametersReference;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClassParametersReferenceBuilder;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClassParametersReferenceFluentImpl;
import java.util.Objects;

public class V1alpha2ResourceClassFluentImpl<A extends V1alpha2ResourceClassFluent<A>>
extends BaseFluent<A>
implements V1alpha2ResourceClassFluent<A> {
    private String apiVersion;
    private String driverName;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1alpha2ResourceClassParametersReferenceBuilder parametersRef;
    private V1NodeSelectorBuilder suitableNodes;

    public V1alpha2ResourceClassFluentImpl() {
    }

    public V1alpha2ResourceClassFluentImpl(V1alpha2ResourceClass instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDriverName(instance.getDriverName());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withParametersRef(instance.getParametersRef());
            this.withSuitableNodes(instance.getSuitableNodes());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public A withDriverName(String driverName) {
        this.driverName = driverName;
        return (A)this;
    }

    @Override
    public Boolean hasDriverName() {
        return this.driverName != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1alpha2ResourceClassFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1alpha2ResourceClassFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1alpha2ResourceClassFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1alpha2ResourceClassFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1alpha2ResourceClassFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public V1alpha2ResourceClassParametersReference getParametersRef() {
        return this.parametersRef != null ? this.parametersRef.build() : null;
    }

    @Override
    public V1alpha2ResourceClassParametersReference buildParametersRef() {
        return this.parametersRef != null ? this.parametersRef.build() : null;
    }

    @Override
    public A withParametersRef(V1alpha2ResourceClassParametersReference parametersRef) {
        this._visitables.get("parametersRef").remove(this.parametersRef);
        if (parametersRef != null) {
            this.parametersRef = new V1alpha2ResourceClassParametersReferenceBuilder(parametersRef);
            this._visitables.get("parametersRef").add(this.parametersRef);
        } else {
            this.parametersRef = null;
            this._visitables.get("parametersRef").remove(this.parametersRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasParametersRef() {
        return this.parametersRef != null;
    }

    @Override
    public V1alpha2ResourceClassFluent.ParametersRefNested<A> withNewParametersRef() {
        return new ParametersRefNestedImpl();
    }

    @Override
    public V1alpha2ResourceClassFluent.ParametersRefNested<A> withNewParametersRefLike(V1alpha2ResourceClassParametersReference item) {
        return new ParametersRefNestedImpl(item);
    }

    @Override
    public V1alpha2ResourceClassFluent.ParametersRefNested<A> editParametersRef() {
        return this.withNewParametersRefLike(this.getParametersRef());
    }

    @Override
    public V1alpha2ResourceClassFluent.ParametersRefNested<A> editOrNewParametersRef() {
        return this.withNewParametersRefLike(this.getParametersRef() != null ? this.getParametersRef() : new V1alpha2ResourceClassParametersReferenceBuilder().build());
    }

    @Override
    public V1alpha2ResourceClassFluent.ParametersRefNested<A> editOrNewParametersRefLike(V1alpha2ResourceClassParametersReference item) {
        return this.withNewParametersRefLike(this.getParametersRef() != null ? this.getParametersRef() : item);
    }

    @Override
    @Deprecated
    public V1NodeSelector getSuitableNodes() {
        return this.suitableNodes != null ? this.suitableNodes.build() : null;
    }

    @Override
    public V1NodeSelector buildSuitableNodes() {
        return this.suitableNodes != null ? this.suitableNodes.build() : null;
    }

    @Override
    public A withSuitableNodes(V1NodeSelector suitableNodes) {
        this._visitables.get("suitableNodes").remove(this.suitableNodes);
        if (suitableNodes != null) {
            this.suitableNodes = new V1NodeSelectorBuilder(suitableNodes);
            this._visitables.get("suitableNodes").add(this.suitableNodes);
        } else {
            this.suitableNodes = null;
            this._visitables.get("suitableNodes").remove(this.suitableNodes);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSuitableNodes() {
        return this.suitableNodes != null;
    }

    @Override
    public V1alpha2ResourceClassFluent.SuitableNodesNested<A> withNewSuitableNodes() {
        return new SuitableNodesNestedImpl();
    }

    @Override
    public V1alpha2ResourceClassFluent.SuitableNodesNested<A> withNewSuitableNodesLike(V1NodeSelector item) {
        return new SuitableNodesNestedImpl(item);
    }

    @Override
    public V1alpha2ResourceClassFluent.SuitableNodesNested<A> editSuitableNodes() {
        return this.withNewSuitableNodesLike(this.getSuitableNodes());
    }

    @Override
    public V1alpha2ResourceClassFluent.SuitableNodesNested<A> editOrNewSuitableNodes() {
        return this.withNewSuitableNodesLike(this.getSuitableNodes() != null ? this.getSuitableNodes() : new V1NodeSelectorBuilder().build());
    }

    @Override
    public V1alpha2ResourceClassFluent.SuitableNodesNested<A> editOrNewSuitableNodesLike(V1NodeSelector item) {
        return this.withNewSuitableNodesLike(this.getSuitableNodes() != null ? this.getSuitableNodes() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha2ResourceClassFluentImpl that = (V1alpha2ResourceClassFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.driverName, that.driverName)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.parametersRef, that.parametersRef)) {
            return false;
        }
        return Objects.equals(this.suitableNodes, that.suitableNodes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.driverName, this.kind, this.metadata, this.parametersRef, this.suitableNodes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.driverName != null) {
            sb.append("driverName:");
            sb.append(this.driverName + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.parametersRef != null) {
            sb.append("parametersRef:");
            sb.append(this.parametersRef + ",");
        }
        if (this.suitableNodes != null) {
            sb.append("suitableNodes:");
            sb.append(this.suitableNodes);
        }
        sb.append("}");
        return sb.toString();
    }

    class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1alpha2ResourceClassFluent.MetadataNested<N>>
    implements V1alpha2ResourceClassFluent.MetadataNested<N>,
    Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClassFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class ParametersRefNestedImpl<N>
    extends V1alpha2ResourceClassParametersReferenceFluentImpl<V1alpha2ResourceClassFluent.ParametersRefNested<N>>
    implements V1alpha2ResourceClassFluent.ParametersRefNested<N>,
    Nested<N> {
        V1alpha2ResourceClassParametersReferenceBuilder builder;

        ParametersRefNestedImpl(V1alpha2ResourceClassParametersReference item) {
            this.builder = new V1alpha2ResourceClassParametersReferenceBuilder(this, item);
        }

        ParametersRefNestedImpl() {
            this.builder = new V1alpha2ResourceClassParametersReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClassFluentImpl.this.withParametersRef(this.builder.build());
        }

        @Override
        public N endParametersRef() {
            return this.and();
        }
    }

    class SuitableNodesNestedImpl<N>
    extends V1NodeSelectorFluentImpl<V1alpha2ResourceClassFluent.SuitableNodesNested<N>>
    implements V1alpha2ResourceClassFluent.SuitableNodesNested<N>,
    Nested<N> {
        V1NodeSelectorBuilder builder;

        SuitableNodesNestedImpl(V1NodeSelector item) {
            this.builder = new V1NodeSelectorBuilder(this, item);
        }

        SuitableNodesNestedImpl() {
            this.builder = new V1NodeSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClassFluentImpl.this.withSuitableNodes(this.builder.build());
        }

        @Override
        public N endSuitableNodes() {
            return this.and();
        }
    }
}

