/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.azure.storage.blob.models.BlobStorageException;
import com.google.common.io.ByteSource;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.io.InputStream;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.AzureUtils;

public class AzureByteSource
extends ByteSource {
    private static final Logger log = new Logger(AzureByteSource.class);
    private final AzureStorage azureStorage;
    private final String containerName;
    private final String blobPath;

    @AssistedInject
    public AzureByteSource(@Assisted(value="azureStorage") AzureStorage azureStorage, @Assisted(value="containerName") String containerName, @Assisted(value="blobPath") String blobPath) {
        this.azureStorage = azureStorage;
        this.containerName = containerName;
        this.blobPath = blobPath;
    }

    public InputStream openStream() throws IOException {
        return this.openStream(0L);
    }

    public InputStream openStream(long offset) throws IOException {
        try {
            return this.azureStorage.getBlockBlobInputStream(offset, this.containerName, this.blobPath);
        }
        catch (BlobStorageException e) {
            if (AzureUtils.AZURE_RETRY.apply((Object)e)) {
                throw new IOException("Recoverable exception", e);
            }
            log.error("Exception when opening stream to azure resource, containerName: %s, blobPath: %s, Error: %s", new Object[]{this.containerName, this.blobPath, e.getMessage()});
            throw new RuntimeException(e);
        }
    }
}

