/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authentication;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.CredentialedHttpClient;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.auth.BasicCredentials;
import org.apache.druid.java.util.http.client.auth.Credentials;
import org.apache.druid.metadata.PasswordProvider;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Escalator;

@JsonTypeName(value="basic")
public class BasicHTTPEscalator
implements Escalator {
    private static final Logger LOG = new Logger(BasicHTTPEscalator.class);
    private final String internalClientUsername;
    private final PasswordProvider internalClientPassword;
    private final String authorizerName;

    @JsonCreator
    public BasicHTTPEscalator(@JsonProperty(value="authorizerName") String authorizerName, @JsonProperty(value="internalClientUsername") String internalClientUsername, @JsonProperty(value="internalClientPassword") PasswordProvider internalClientPassword) {
        this.authorizerName = authorizerName;
        this.internalClientUsername = internalClientUsername;
        this.internalClientPassword = internalClientPassword;
    }

    public HttpClient createEscalatedClient(HttpClient baseClient) {
        LOG.debug("----------- Creating escalated client", new Object[0]);
        return new CredentialedHttpClient((Credentials)new BasicCredentials(this.internalClientUsername, this.internalClientPassword.getPassword()), baseClient);
    }

    public AuthenticationResult createEscalatedAuthenticationResult() {
        LOG.debug("----------- Creating escalated authentication result. username: %s", new Object[]{this.internalClientUsername});
        return new AuthenticationResult(this.internalClientUsername, this.authorizerName, null, null);
    }
}

