/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.leaderelection.resourcelock;

import io.kubernetes.client.extended.leaderelection.LeaderElectionRecord;
import io.kubernetes.client.extended.leaderelection.Lock;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapLock
implements Lock {
    private static final Logger log = LoggerFactory.getLogger(ConfigMapLock.class);
    String LeaderElectionRecordAnnotationKey = "control-plane.alpha.kubernetes.io/leader";
    private final String namespace;
    private final String name;
    private final String identity;
    private CoreV1Api coreV1Client;
    private AtomicReference<V1ConfigMap> configMapRefer = new AtomicReference<Object>(null);

    public ConfigMapLock(String namespace, String name, String identity) {
        this(namespace, name, identity, Configuration.getDefaultApiClient());
    }

    public ConfigMapLock(String namespace, String name, String identity, ApiClient apiClient) {
        this.namespace = namespace;
        this.name = name;
        this.identity = identity;
        this.coreV1Client = new CoreV1Api(apiClient);
    }

    @Override
    public LeaderElectionRecord get() throws ApiException {
        String recordRawStringContent;
        V1ConfigMap configMap = this.coreV1Client.readNamespacedConfigMap(this.name, this.namespace, null);
        this.configMapRefer.set(configMap);
        Map annotations = configMap.getMetadata().getAnnotations();
        if (annotations == null || annotations.isEmpty()) {
            configMap.getMetadata().setAnnotations(new HashMap());
        }
        if (StringUtils.isEmpty((CharSequence)(recordRawStringContent = (String)configMap.getMetadata().getAnnotations().get(this.LeaderElectionRecordAnnotationKey)))) {
            return new LeaderElectionRecord();
        }
        LeaderElectionRecord record = (LeaderElectionRecord)this.coreV1Client.getApiClient().getJSON().deserialize(recordRawStringContent, LeaderElectionRecord.class);
        return record;
    }

    @Override
    public boolean create(LeaderElectionRecord record) {
        try {
            V1ConfigMap configMap = new V1ConfigMap();
            V1ObjectMeta objectMeta = new V1ObjectMeta();
            objectMeta.setName(this.name);
            objectMeta.setNamespace(this.namespace);
            HashMap<String, String> annotations = new HashMap<String, String>();
            annotations.put(this.LeaderElectionRecordAnnotationKey, this.coreV1Client.getApiClient().getJSON().serialize((Object)record));
            objectMeta.setAnnotations(annotations);
            if (record.getOwnerReference() != null) {
                objectMeta.setOwnerReferences(Collections.singletonList(record.getOwnerReference()));
            }
            configMap.setMetadata(objectMeta);
            V1ConfigMap createdConfigMap = this.coreV1Client.createNamespacedConfigMap(this.namespace, configMap, null, null, null, null);
            this.configMapRefer.set(createdConfigMap);
            return true;
        }
        catch (ApiException e) {
            if (e.getCode() == 409) {
                log.debug("received {} when creating configmap lock", (Object)e.getCode(), (Object)e);
            } else {
                log.error("received {} when creating configmap lock", (Object)e.getCode(), (Object)e);
            }
            return false;
        }
    }

    @Override
    public boolean update(LeaderElectionRecord record) {
        try {
            V1ConfigMap configMap = this.configMapRefer.get();
            configMap.getMetadata().putAnnotationsItem(this.LeaderElectionRecordAnnotationKey, this.coreV1Client.getApiClient().getJSON().serialize((Object)record));
            V1ConfigMap replacedConfigMap = this.coreV1Client.replaceNamespacedConfigMap(this.name, this.namespace, configMap, null, null, null, null);
            this.configMapRefer.set(replacedConfigMap);
            return true;
        }
        catch (ApiException e) {
            if (e.getCode() == 409) {
                log.debug("received {} when updating configmap lock", (Object)e.getCode(), (Object)e);
            } else {
                log.error("received {} when updating configmap lock", (Object)e.getCode(), (Object)e);
            }
            return false;
        }
    }

    @Override
    public String identity() {
        return this.identity;
    }

    @Override
    public String describe() {
        return this.namespace + "/" + this.name;
    }
}

