/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common.httpclient.okhttp;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;

public class DruidKubernetesOkHttpHttpClientConfig {
    @JsonProperty
    private boolean useCustomDispatcherExecutor = false;
    @JsonProperty
    @Nullable
    private Integer maxWorkerThreads = null;
    @JsonProperty
    @Min(value=1L)
    private @Min(value=1L) int coreWorkerThreads = 50;
    @JsonProperty
    private long workerThreadKeepAliveTime = 60L;

    public boolean isUseCustomDispatcherExecutor() {
        return this.useCustomDispatcherExecutor;
    }

    public int getMaxWorkerThreads() {
        if (this.maxWorkerThreads == null || this.maxWorkerThreads < this.coreWorkerThreads) {
            return this.coreWorkerThreads;
        }
        return this.maxWorkerThreads;
    }

    public int getCoreWorkerThreads() {
        return this.coreWorkerThreads;
    }

    public long getWorkerThreadKeepAliveTime() {
        return this.workerThreadKeepAliveTime;
    }
}

