/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

public enum DBCmpType {
    NONE,
    EQUAL,
    NOTEQUAL,
    LESSTHAN,
    MOREOREQUAL,
    GREATERTHAN,
    LESSOREQUAL,
    LIKE,
    NOTLIKE,
    NULL,
    NOTNULL,
    BETWEEN,
    NOTBETWEEN,
    IN,
    NOTIN,
    CONTAINS,
    NOTCONTAINS;


    public static DBCmpType getNullType(DBCmpType type) {
        switch (type) {
            case NOTEQUAL: 
            case MOREOREQUAL: 
            case LESSOREQUAL: 
            case NOTLIKE: 
            case NOTNULL: 
            case NOTBETWEEN: 
            case NOTIN: 
            case NOTCONTAINS: {
                return NOTNULL;
            }
        }
        return NULL;
    }

    public String toString() {
        switch (this) {
            case EQUAL: {
                return "=";
            }
            case NOTEQUAL: {
                return "<>";
            }
            case LESSTHAN: {
                return "<";
            }
            case MOREOREQUAL: {
                return ">=";
            }
            case GREATERTHAN: {
                return ">";
            }
            case LESSOREQUAL: {
                return "<=";
            }
            case LIKE: {
                return " LIKE ";
            }
            case NOTLIKE: {
                return " NOT LIKE ";
            }
            case NULL: {
                return " IS NULL";
            }
            case NOTNULL: {
                return " IS NOT NULL";
            }
            case BETWEEN: {
                return " BETWEEN ";
            }
            case NOTBETWEEN: {
                return " NOT BETWEEN ";
            }
            case IN: {
                return " IN ";
            }
            case NOTIN: {
                return " NOT IN ";
            }
        }
        return " ";
    }
}

