/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.join;

import java.util.HashSet;
import java.util.Set;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBJoinType;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.join.DBJoinExpr;

public class DBColumnJoinExpr
extends DBJoinExpr {
    protected DBColumnExpr left;
    protected DBColumnExpr right;
    public DBCompareExpr compExpr;

    public DBColumnJoinExpr(DBColumnExpr left, DBColumnExpr right, DBJoinType type, DBCompareExpr addlConstraint) {
        super(type);
        this.left = left;
        this.right = right;
        this.compExpr = addlConstraint;
    }

    public DBColumnJoinExpr(DBColumnExpr left, DBColumnExpr right, DBJoinType type) {
        this(left, right, type, null);
    }

    public DBColumnJoinExpr(DBColumnJoinExpr joinExpr, DBCompareExpr addlConstraint) {
        this(joinExpr.left, joinExpr.right, joinExpr.type, joinExpr.compExpr != null ? joinExpr.compExpr.and(addlConstraint) : addlConstraint);
    }

    public final DBDatabase getDatabase() {
        return this.left.getDatabase();
    }

    public DBColumnExpr getLeft() {
        return this.left;
    }

    public DBColumnExpr getRight() {
        return this.right;
    }

    @Override
    public DBRowSet getLeftTable() {
        return this.left.getRowSet();
    }

    @Override
    public DBRowSet getRightTable() {
        return this.right.getRowSet();
    }

    @Override
    public boolean isJoinOn(DBRowSet rowset) {
        if (rowset == null) {
            return false;
        }
        return rowset.equals(this.getLeftTable()) || rowset.equals(this.getRightTable());
    }

    @Override
    public boolean isJoinOn(DBColumn column) {
        if (column == null) {
            return false;
        }
        if (column.equals(this.left.getUpdateColumn()) || column.equals(this.right.getUpdateColumn())) {
            return true;
        }
        if (this.compExpr != null) {
            HashSet<DBColumn> set = new HashSet<DBColumn>();
            this.compExpr.addReferencedColumns(set);
            return set.contains(column);
        }
        return false;
    }

    @Override
    public DBRowSet getOuterTable() {
        switch (this.type) {
            case LEFT: {
                return this.getRightTable();
            }
            case RIGHT: {
                return this.getLeftTable();
            }
        }
        return null;
    }

    @Override
    public void reverse() {
        DBColumnExpr swap = this.left;
        this.left = this.right;
        this.right = swap;
        this.type = DBJoinType.reversed(this.type);
    }

    @Override
    public void prepareParams(DBCommand cmd, DBExpr parent) {
        if (this.compExpr != null) {
            this.compExpr.prepareParams(cmd, this);
        }
    }

    @Override
    public DBJoinExpr copy(DBCommand newCmd) {
        if (this.compExpr == null) {
            return this;
        }
        DBColumnJoinExpr join = new DBColumnJoinExpr(this.left, this.right, this.type, this.compExpr.copy(newCmd));
        return join;
    }

    public DBCompareExpr getWhere() {
        return this.compExpr;
    }

    public void where(DBCompareExpr expr) {
        this.compExpr = expr;
    }

    public DBColumnJoinExpr and(DBCompareExpr expr) {
        if (expr == null || expr.equals(this.compExpr)) {
            return this;
        }
        return new DBColumnJoinExpr(this, expr);
    }

    public DBColumnJoinExpr and(DBColumnExpr c1, DBColumnExpr c2) {
        return this.and(c1.is(c2));
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.left.addReferencedColumns(list);
        this.right.addReferencedColumns(list);
        if (this.compExpr != null) {
            this.compExpr.addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        if ((context & 1L) != 0L) {
            this.getLeftTable().addSQL(sql, 15L);
        }
        if ((context & 4L) != 0L) {
            switch (this.type) {
                case LEFT: {
                    sql.append(" LEFT JOIN ");
                    break;
                }
                case INNER: {
                    sql.append(" INNER JOIN ");
                    break;
                }
                case RIGHT: {
                    sql.append(" RIGHT JOIN ");
                    break;
                }
                case FULL: {
                    sql.append(" FULL JOIN ");
                    break;
                }
                default: {
                    sql.append(" JOIN ");
                }
            }
            this.getRightTable().addSQL(sql, 15L);
            sql.append(" ON ");
            this.right.addSQL(sql, 7L);
            sql.append(" = ");
            this.left.addSQL(sql, 7L);
            if (this.compExpr != null) {
                sql.append(" AND ");
                this.compExpr.addSQL(sql, 7L);
            }
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.left.toString());
        b.append("=");
        b.append(this.right.toString());
        if (this.compExpr != null) {
            b.append(" AND ");
            b.append(this.compExpr.toString());
        }
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DBColumnJoinExpr)) {
            return super.equals(obj);
        }
        DBColumnJoinExpr other = (DBColumnJoinExpr)obj;
        if (this.left.equals(other.left) && this.right.equals(other.right) && this.type == other.type) {
            return true;
        }
        return this.left.equals(other.right) && this.right.equals(other.left) && this.type == DBJoinType.reversed(other.type);
    }
}

