/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.service;

import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.creditbureau.domain.CreditBureauLoanProductMapping;
import org.apache.fineract.infrastructure.creditbureau.domain.CreditBureauLoanProductMappingRepository;
import org.apache.fineract.infrastructure.creditbureau.domain.OrganisationCreditBureau;
import org.apache.fineract.infrastructure.creditbureau.domain.OrganisationCreditBureauRepository;
import org.apache.fineract.infrastructure.creditbureau.serialization.CreditBureauLoanProductCommandFromApiJsonDeserializer;
import org.apache.fineract.infrastructure.creditbureau.service.CreditBureauLoanProductMappingWritePlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CreditBureauLoanProductMappingWritePlatformServiceImpl
implements CreditBureauLoanProductMappingWritePlatformService {
    private final PlatformSecurityContext context;
    private final CreditBureauLoanProductMappingRepository creditBureauLoanProductMappingRepository;
    private final OrganisationCreditBureauRepository organisationCreditBureauRepository;
    private final LoanProductRepository loanProductRepository;
    private final CreditBureauLoanProductCommandFromApiJsonDeserializer fromApiJsonDeserializer;

    @Autowired
    public CreditBureauLoanProductMappingWritePlatformServiceImpl(PlatformSecurityContext context, CreditBureauLoanProductMappingRepository creditBureauLoanProductMappingRepository, OrganisationCreditBureauRepository organisationCreditBureauRepository, LoanProductRepository loanProductRepository, CreditBureauLoanProductCommandFromApiJsonDeserializer fromApiJsonDeserializer) {
        this.context = context;
        this.creditBureauLoanProductMappingRepository = creditBureauLoanProductMappingRepository;
        this.organisationCreditBureauRepository = organisationCreditBureauRepository;
        this.loanProductRepository = loanProductRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
    }

    @Transactional
    public CommandProcessingResult addCreditBureauLoanProductMapping(Long organisationCreditBureauId, JsonCommand command) {
        this.context.authenticatedUser();
        this.fromApiJsonDeserializer.validateForCreate(command.json(), organisationCreditBureauId);
        long lpid = command.longValueOfParameterNamed("loanProductId");
        OrganisationCreditBureau orgcb = (OrganisationCreditBureau)this.organisationCreditBureauRepository.getReferenceById((Object)organisationCreditBureauId);
        LoanProduct lp = (LoanProduct)this.loanProductRepository.getReferenceById((Object)lpid);
        CreditBureauLoanProductMapping cb_lp = CreditBureauLoanProductMapping.fromJson((JsonCommand)command, (OrganisationCreditBureau)orgcb, (LoanProduct)lp);
        this.creditBureauLoanProductMappingRepository.saveAndFlush((Object)cb_lp);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)cb_lp.getId()).build();
    }

    public CommandProcessingResult updateCreditBureauLoanProductMapping(JsonCommand command) {
        this.context.authenticatedUser();
        this.fromApiJsonDeserializer.validateForUpdate(command.json());
        Long mappingid = command.longValueOfParameterNamed("creditbureauLoanProductMappingId");
        boolean active = command.booleanPrimitiveValueOfParameterNamed("active");
        CreditBureauLoanProductMapping cblpmapping = (CreditBureauLoanProductMapping)this.creditBureauLoanProductMappingRepository.getReferenceById((Object)mappingid);
        cblpmapping.setActive(active);
        this.creditBureauLoanProductMappingRepository.saveAndFlush((Object)cblpmapping);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)cblpmapping.getId()).build();
    }
}

