/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.service.serialization.serializer.loan;

import java.math.BigDecimal;
import java.util.List;
import lombok.Generated;
import org.apache.avro.generic.GenericContainer;
import org.apache.fineract.avro.generator.ByteBufferSerializable;
import org.apache.fineract.avro.generic.v1.CurrencyDataV1;
import org.apache.fineract.avro.loan.v1.LoanRepaymentDueDataV1;
import org.apache.fineract.avro.loan.v1.RepaymentDueDataV1;
import org.apache.fineract.avro.loan.v1.RepaymentPastDueDataV1;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.repayment.LoanRepaymentBusinessEvent;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.loan.LoanRepaymentPastDueDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.support.AvroDateTimeMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.AbstractBusinessEventWithCustomDataSerializer;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.ExternalEventCustomDataSerializer;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.portfolio.loanaccount.data.LoanRepaymentPastDueData;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.service.LoanCalculateRepaymentPastDueService;
import org.springframework.stereotype.Component;

@Component
public class LoanRepaymentBusinessEventSerializer
extends AbstractBusinessEventWithCustomDataSerializer<LoanRepaymentBusinessEvent> {
    private final AvroDateTimeMapper dataTimeMapper;
    private final LoanRepaymentPastDueDataMapper pastDueDataMapper;
    private final LoanCalculateRepaymentPastDueService pastDueService;
    private final List<ExternalEventCustomDataSerializer<LoanRepaymentBusinessEvent>> externalEventCustomDataSerializers;

    public <T> ByteBufferSerializable toAvroDTO(BusinessEvent<T> rawEvent) {
        LoanRepaymentBusinessEvent event = (LoanRepaymentBusinessEvent)rawEvent;
        LoanRepaymentScheduleInstallment repaymentInstallment = (LoanRepaymentScheduleInstallment)event.get();
        Loan loan = repaymentInstallment.getLoan();
        Long id = (Long)loan.getId();
        String accountNo = loan.getAccountNumber();
        String externalId = loan.getExternalId().getValue();
        MonetaryCurrency loanCurrency = loan.getCurrency();
        CurrencyDataV1 currency = CurrencyDataV1.newBuilder().setCode(loanCurrency.getCode()).setDecimalPlaces(Integer.valueOf(loanCurrency.getDigitsAfterDecimal())).setInMultiplesOf(loanCurrency.getInMultiplesOf()).build();
        RepaymentDueDataV1 repaymentDue = this.getRepaymentDueData(repaymentInstallment, loanCurrency);
        LoanRepaymentPastDueData pastDueData = this.pastDueService.retrieveLoanRepaymentPastDueAmountTillDate(loan);
        RepaymentPastDueDataV1 pastDue = this.pastDueDataMapper.map(pastDueData);
        LoanRepaymentDueDataV1 loanRepaymentDueDataV1 = LoanRepaymentDueDataV1.newBuilder().setLoanId((Object)id).setLoanAccountNo((Object)accountNo).setLoanExternalId(externalId).setCurrency(currency).setInstallment((Object)repaymentDue).setPastDueAmount(pastDue).build();
        loanRepaymentDueDataV1.setCustomData(this.collectCustomData((BusinessEvent)event));
        return loanRepaymentDueDataV1;
    }

    private RepaymentDueDataV1 getRepaymentDueData(LoanRepaymentScheduleInstallment repaymentInstallment, MonetaryCurrency loanCurrency) {
        Integer installmentNumber = repaymentInstallment.getInstallmentNumber();
        String dueDate = this.dataTimeMapper.mapLocalDate(repaymentInstallment.getDueDate());
        BigDecimal principalAmountDue = repaymentInstallment.getPrincipalOutstanding(loanCurrency).getAmount();
        BigDecimal interestAmountDue = repaymentInstallment.getInterestOutstanding(loanCurrency).getAmount();
        BigDecimal feeChargeAmountDue = repaymentInstallment.getFeeChargesOutstanding(loanCurrency).getAmount();
        BigDecimal penaltyChargeAmountDue = repaymentInstallment.getPenaltyChargesOutstanding(loanCurrency).getAmount();
        BigDecimal totalAmountDue = repaymentInstallment.getTotalOutstanding(loanCurrency).getAmount();
        RepaymentDueDataV1 repaymentDue = new RepaymentDueDataV1(installmentNumber, dueDate, principalAmountDue, interestAmountDue, feeChargeAmountDue, penaltyChargeAmountDue, totalAmountDue);
        return repaymentDue;
    }

    public <T> boolean canSerialize(BusinessEvent<T> event) {
        return event instanceof LoanRepaymentBusinessEvent;
    }

    public Class<? extends GenericContainer> getSupportedSchema() {
        return LoanRepaymentDueDataV1.class;
    }

    protected List<ExternalEventCustomDataSerializer<LoanRepaymentBusinessEvent>> getExternalEventCustomDataSerializers() {
        return this.externalEventCustomDataSerializers;
    }

    @Generated
    public LoanRepaymentBusinessEventSerializer(AvroDateTimeMapper dataTimeMapper, LoanRepaymentPastDueDataMapper pastDueDataMapper, LoanCalculateRepaymentPastDueService pastDueService, List<ExternalEventCustomDataSerializer<LoanRepaymentBusinessEvent>> externalEventCustomDataSerializers) {
        this.dataTimeMapper = dataTimeMapper;
        this.pastDueDataMapper = pastDueDataMapper;
        this.pastDueService = pastDueService;
        this.externalEventCustomDataSerializers = externalEventCustomDataSerializers;
    }
}

