/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.springbatch.messagehandler.jms;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"fineract.remote-job-message-handler.jms.enabled"}, havingValue="true")
public class JmsBrokerConfiguration {
    @Autowired
    private FineractProperties fineractProperties;
    private static final int PREFETCH_MESSAGE_NUMBER = 1;

    @Bean
    public ActiveMQConnectionFactory connectionFactory() {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
        connectionFactory.setBrokerURL(this.fineractProperties.getRemoteJobMessageHandler().getJms().getBrokerUrl());
        connectionFactory.setTrustAllPackages(true);
        ActiveMQPrefetchPolicy activeMQPrefetchPolicy = new ActiveMQPrefetchPolicy();
        activeMQPrefetchPolicy.setAll(1);
        connectionFactory.setPrefetchPolicy(activeMQPrefetchPolicy);
        FineractProperties.FineractRemoteJobMessageHandlerJmsProperties jmsProps = this.fineractProperties.getRemoteJobMessageHandler().getJms();
        if (jmsProps.isBrokerPasswordProtected()) {
            connectionFactory.setUserName(jmsProps.getBrokerUsername());
            connectionFactory.setPassword(jmsProps.getBrokerPassword());
        }
        return connectionFactory;
    }
}

