/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.handler;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import org.apache.fineract.commands.annotation.CommandType;
import org.apache.fineract.commands.handler.NewCommandSourceHandler;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.interoperation.domain.InteropIdentifierType;
import org.apache.fineract.interoperation.service.InteropService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@CommandType(entity="INTERID", action="CREATE")
public class CreateInteropIdentifierHandler
implements NewCommandSourceHandler {
    private final InteropService interopService;

    @Autowired
    public CreateInteropIdentifierHandler(InteropService interopService) {
        this.interopService = interopService;
    }

    @Transactional
    public CommandProcessingResult processCommand(JsonCommand command) {
        List split = Splitter.on((char)'/').splitToList((CharSequence)command.getUrl());
        int length = split.size();
        String subIdOrType = Strings.emptyToNull((String)StringUtils.trimWhitespace((String)((String)split.get(length - 1))));
        String idValue = (String)split.get(length - 2);
        InteropIdentifierType idType = InteropIdentifierType.valueOf((String)((String)split.get(length - 3)).toUpperCase());
        return this.interopService.registerAccountIdentifier(idType, idValue, subIdOrType, command);
    }
}

