/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.notification.starter;

import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.notification.eventandlistener.NotificationEventPublisher;
import org.apache.fineract.notification.service.NotificationDomainService;
import org.apache.fineract.notification.service.NotificationDomainServiceImpl;
import org.apache.fineract.notification.service.NotificationGeneratorReadRepositoryWrapper;
import org.apache.fineract.notification.service.NotificationGeneratorWritePlatformService;
import org.apache.fineract.notification.service.NotificationMapperWritePlatformService;
import org.apache.fineract.notification.service.NotificationReadPlatformService;
import org.apache.fineract.notification.service.NotificationReadPlatformServiceImpl;
import org.apache.fineract.notification.service.NotificationWritePlatformService;
import org.apache.fineract.notification.service.NotificationWritePlatformServiceImpl;
import org.apache.fineract.notification.service.UserNotificationService;
import org.apache.fineract.notification.service.UserNotificationServiceImpl;
import org.apache.fineract.useradministration.domain.AppUserRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class NotificationConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={NotificationDomainService.class})
    public NotificationDomainService notificationDomainService(BusinessEventNotifierService businessEventNotifierService, PlatformSecurityContext context, UserNotificationService userNotificationService) {
        return new NotificationDomainServiceImpl(businessEventNotifierService, context, userNotificationService);
    }

    @Bean
    @ConditionalOnMissingBean(value={NotificationReadPlatformService.class})
    public NotificationReadPlatformService notificationReadPlatformService(JdbcTemplate jdbcTemplate, PlatformSecurityContext context, ColumnValidator columnValidator, PaginationHelper paginationHelper, DatabaseSpecificSQLGenerator sqlGenerator) {
        return new NotificationReadPlatformServiceImpl(jdbcTemplate, context, columnValidator, paginationHelper, sqlGenerator);
    }

    @Bean
    @ConditionalOnMissingBean(value={NotificationWritePlatformService.class})
    public NotificationWritePlatformService notificationWritePlatformService(NotificationGeneratorWritePlatformService notificationGeneratorWritePlatformService, NotificationGeneratorReadRepositoryWrapper notificationGeneratorReadRepositoryWrapper, AppUserRepository appUserRepository, NotificationMapperWritePlatformService notificationMapperWritePlatformService) {
        return new NotificationWritePlatformServiceImpl(notificationGeneratorWritePlatformService, notificationGeneratorReadRepositoryWrapper, appUserRepository, notificationMapperWritePlatformService);
    }

    @Bean
    @ConditionalOnMissingBean(value={UserNotificationService.class})
    public UserNotificationService userNotificationService(NotificationEventPublisher notificationEventPublisher, AppUserRepository appUserRepository, FineractProperties fineractProperties, NotificationReadPlatformService notificationReadPlatformService, NotificationWritePlatformService notificationWritePlatformService) {
        return new UserNotificationServiceImpl(notificationEventPublisher, appUserRepository, fineractProperties, notificationReadPlatformService, notificationWritePlatformService);
    }
}

