/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.provisioning.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProvisioningCategoryDefinitionJsonDeserializer {
    public static final String CATEGORYNAME = "categoryname";
    public static final String CATEGORYDESCRIPTION = "categorydescription";
    public static final String PROVISIONINGCATEGORIES = "provisioningcategories";
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("categoryname", "categorydescription"));
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public ProvisioningCategoryDefinitionJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(PROVISIONINGCATEGORIES);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String name = this.fromApiJsonHelper.extractStringNamed(CATEGORYNAME, element);
        baseDataValidator.reset().parameter(CATEGORYNAME).value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(PROVISIONINGCATEGORIES);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists(CATEGORYNAME, element)) {
            String categoryName = this.fromApiJsonHelper.extractStringNamed(CATEGORYNAME, element);
            baseDataValidator.reset().parameter(CATEGORYNAME).value((Object)categoryName).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

