/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.portfolio.address.domain.Address;
import org.apache.fineract.portfolio.client.domain.Client;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_client_address")
public class ClientAddress
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne
    private Client client;
    @ManyToOne
    private Address address;
    @ManyToOne
    @JoinColumn(name="address_type_id")
    private CodeValue addressType;
    @Column(name="is_active")
    private boolean isActive;
    static final long serialVersionUID = 5487651624720636261L;

    private ClientAddress(Client client, Address address, CodeValue addressType, boolean isActive) {
        this.client = client;
        this.address = address;
        this.addressType = addressType;
        this.isActive = isActive;
    }

    public ClientAddress() {
    }

    public static ClientAddress fromJson(boolean isActive, Client client, Address address, CodeValue address_type) {
        return new ClientAddress(client, address, address_type, isActive);
    }

    public Client getClient() {
        return this._persistence_get_client();
    }

    public Address getAddress() {
        return this._persistence_get_address();
    }

    public CodeValue getAddressType() {
        return this._persistence_get_addressType();
    }

    public void setAddressType(CodeValue addressType) {
        this._persistence_set_addressType(addressType);
    }

    public boolean isIs_active() {
        return this._persistence_get_isActive();
    }

    public void setClient(Client client) {
        this._persistence_set_client(client);
    }

    public void setAddress(Address address) {
        this._persistence_set_address(address);
    }

    public void setIs_active(boolean isActive) {
        this._persistence_set_isActive(isActive);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ClientAddress(persistenceObject);
    }

    public ClientAddress(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "address") {
            return this.address;
        }
        if (string == "addressType") {
            return this.addressType;
        }
        if (string == "client") {
            return this.client;
        }
        if (string == "isActive") {
            return this.isActive;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "address") {
            this.address = (Address)object;
            return;
        }
        if (string == "addressType") {
            this.addressType = (CodeValue)object;
            return;
        }
        if (string == "client") {
            this.client = (Client)object;
            return;
        }
        if (string == "isActive") {
            this.isActive = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Address _persistence_get_address() {
        this._persistence_checkFetched("address");
        return this.address;
    }

    public void _persistence_set_address(Address address) {
        this._persistence_checkFetchedForSet("address");
        this._persistence_propertyChange("address", (Object)this.address, (Object)address);
        this.address = address;
    }

    public CodeValue _persistence_get_addressType() {
        this._persistence_checkFetched("addressType");
        return this.addressType;
    }

    public void _persistence_set_addressType(CodeValue codeValue) {
        this._persistence_checkFetchedForSet("addressType");
        this._persistence_propertyChange("addressType", (Object)this.addressType, (Object)codeValue);
        this.addressType = codeValue;
    }

    public Client _persistence_get_client() {
        this._persistence_checkFetched("client");
        return this.client;
    }

    public void _persistence_set_client(Client client) {
        this._persistence_checkFetchedForSet("client");
        this._persistence_propertyChange("client", (Object)this.client, (Object)client);
        this.client = client;
    }

    public boolean _persistence_get_isActive() {
        this._persistence_checkFetched("isActive");
        return this.isActive;
    }

    public void _persistence_set_isActive(boolean bl) {
        this._persistence_checkFetchedForSet("isActive");
        this._persistence_propertyChange("isActive", (Object)new Boolean(this.isActive), (Object)new Boolean(bl));
        this.isActive = bl;
    }
}

