/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.time.OffsetDateTime;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.portfolio.loanaccount.api.InternalLoanInformationApiResource;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanproduct.data.AdvancedPaymentData;
import org.apache.fineract.portfolio.loanproduct.mapper.AdvancedPaymentDataMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"test"})
@Component
@Path(value="/v1/internal/loan")
public class InternalLoanInformationApiResource
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalLoanInformationApiResource.class);
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final LoanTransactionRepository loanTransactionRepository;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final AdvancedPaymentDataMapper advancedPaymentDataMapper;

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void afterPropertiesSet() {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("Internal loan services mode is enabled");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
    }

    @GET
    @Path(value="{loanId}/audit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public AuditData getLoanAuditFields(@Context UriInfo uriInfo, @PathParam(value="loanId") Long loanId) {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("Fetching loan with {}", (Object)loanId);
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId);
        return new AuditData((Long)loan.getCreatedBy().orElse(null), (OffsetDateTime)loan.getCreatedDate().orElse(null), (Long)loan.getLastModifiedBy().orElse(null), (OffsetDateTime)loan.getLastModifiedDate().orElse(null));
    }

    @GET
    @Path(value="{loanId}/transaction/{transactionId}/audit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public AuditData getLoanTransactionAuditFields(@Context UriInfo uriInfo, @PathParam(value="loanId") Long loanId, @PathParam(value="transactionId") Long transactionId) {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("Fetching loan transaction with loanId {}, transactionId {}", (Object)loanId, (Object)transactionId);
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
        LoanTransaction transaction = (LoanTransaction)this.loanTransactionRepository.findById((Object)transactionId).orElseThrow();
        return new AuditData((Long)transaction.getCreatedBy().orElse(null), (OffsetDateTime)transaction.getCreatedDate().orElse(null), (Long)transaction.getLastModifiedBy().orElse(null), (OffsetDateTime)transaction.getLastModifiedDate().orElse(null));
    }

    @GET
    @Path(value="status/{statusId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public List<Long> getLoansByStatus(@Context UriInfo uriInfo, @PathParam(value="statusId") Integer statusId) {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("Fetching loans by status {}", (Object)statusId);
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
        return this.loanRepositoryWrapper.findLoanIdsByStatusId(statusId);
    }

    @GET
    @Path(value="{loanId}/advanced-payment-allocation-rules")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public List<AdvancedPaymentData> getAdvancedPaymentAllocationRulesOfLoan(@Context UriInfo uriInfo, @PathParam(value="loanId") Long loanId) {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("Fetching advanced payment allocation rules by loanId {}", (Object)loanId);
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId);
        return this.advancedPaymentDataMapper.mapLoanPaymentAllocationRule(loan.getPaymentAllocationRules());
    }

    @Generated
    public InternalLoanInformationApiResource(LoanRepositoryWrapper loanRepositoryWrapper, LoanTransactionRepository loanTransactionRepository, ApiRequestParameterHelper apiRequestParameterHelper, AdvancedPaymentDataMapper advancedPaymentDataMapper) {
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.loanTransactionRepository = loanTransactionRepository;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.advancedPaymentDataMapper = advancedPaymentDataMapper;
    }
}

