/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.guarantor.data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.data.CodeValueData;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.organisation.staff.data.StaffData;
import org.apache.fineract.portfolio.account.data.PortfolioAccountData;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.loanaccount.guarantor.data.GuarantorFundingData;
import org.apache.fineract.portfolio.loanaccount.guarantor.data.IGuarantor;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorType;
import org.apache.fineract.portfolio.loanaccount.guarantor.service.GuarantorEnumerations;

public class GuarantorData
implements IGuarantor {
    private static final long serialVersionUID = 1L;
    private final Long id;
    private final Long loanId;
    private final CodeValueData clientRelationshipType;
    private final EnumOptionData guarantorType;
    private final String firstname;
    private final String lastname;
    private final Long entityId;
    private final String externalId;
    private final String officeName;
    private final LocalDate joinedDate;
    private final String addressLine1;
    private final String addressLine2;
    private final String city;
    private final String state;
    private final String zip;
    private final String country;
    private final String mobileNumber;
    private final String housePhoneNumber;
    private final String comment;
    private final LocalDate dob;
    private final Collection<GuarantorFundingData> guarantorFundingDetails;
    private final boolean status;
    private final List<EnumOptionData> guarantorTypeOptions;
    private final Collection<CodeValueData> allowedClientRelationshipTypes;
    private final Collection<PortfolioAccountData> accountLinkingOptions;
    private Integer guarantorTypeId;
    private Integer clientRelationshipTypeId;
    private Integer savingsId;
    private BigDecimal amount;
    private transient Long accountId;
    private transient Integer rowIndex;
    private String dateFormat;
    private String locale;

    public static GuarantorData importInstance(Integer guarantorTypeId, Integer clientRelationshipTypeId, Long entityId, String firstname, String lastname, String addressLine1, String addressLine2, String city, LocalDate dob, String zip, Integer savingsId, BigDecimal amount, Integer rowIndex, Long accountId, String locale, String dateFormat) {
        return new GuarantorData(guarantorTypeId, clientRelationshipTypeId, entityId, firstname, lastname, addressLine1, addressLine2, city, dob, zip, savingsId, amount, rowIndex, accountId, locale, dateFormat);
    }

    private GuarantorData(Integer guarantorTypeId, Integer clientRelationshipTypeId, Long entityId, String firstname, String lastname, String addressLine1, String addressLine2, String city, LocalDate dob, String zip, Integer savingsId, BigDecimal amount, Integer rowIndex, Long accountId, String locale, String dateFormat) {
        this.rowIndex = rowIndex;
        this.firstname = firstname;
        this.lastname = lastname;
        this.entityId = entityId;
        this.addressLine1 = addressLine1;
        this.addressLine2 = addressLine2;
        this.city = city;
        this.zip = zip;
        this.dob = dob;
        this.guarantorTypeId = guarantorTypeId;
        this.clientRelationshipTypeId = clientRelationshipTypeId;
        this.savingsId = savingsId;
        this.amount = amount;
        this.accountId = accountId;
        this.dateFormat = dateFormat;
        this.locale = locale;
        this.clientRelationshipType = null;
        this.guarantorType = null;
        this.id = null;
        this.loanId = null;
        this.externalId = null;
        this.officeName = null;
        this.joinedDate = null;
        this.state = null;
        this.country = null;
        this.mobileNumber = null;
        this.housePhoneNumber = null;
        this.comment = null;
        this.guarantorFundingDetails = null;
        this.status = false;
        this.guarantorTypeOptions = null;
        this.allowedClientRelationshipTypes = null;
        this.accountLinkingOptions = null;
    }

    public static GuarantorData template(List<EnumOptionData> guarantorTypeOptions, Collection<CodeValueData> allowedClientRelationshipTypes, Collection<PortfolioAccountData> accountLinkingOptions) {
        Collection guarantorFundingDetails = null;
        boolean status = false;
        return new GuarantorData(null, null, null, null, GuarantorEnumerations.guarantorType((GuarantorType)GuarantorType.CUSTOMER), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, guarantorFundingDetails, guarantorTypeOptions, allowedClientRelationshipTypes, accountLinkingOptions);
    }

    public static GuarantorData templateOnTop(GuarantorData guarantorData, List<EnumOptionData> guarantorTypeOptions, Collection<CodeValueData> allowedClientRelationshipTypes, Collection<PortfolioAccountData> accountLinkingOptions) {
        return new GuarantorData(guarantorData.id, guarantorData.loanId, guarantorData.clientRelationshipType, guarantorData.entityId, guarantorData.guarantorType, guarantorData.firstname, guarantorData.lastname, guarantorData.dob, guarantorData.addressLine1, guarantorData.addressLine2, guarantorData.city, guarantorData.state, guarantorData.zip, guarantorData.country, guarantorData.mobileNumber, guarantorData.housePhoneNumber, guarantorData.comment, guarantorData.officeName, guarantorData.joinedDate, guarantorData.externalId, guarantorData.status, guarantorData.guarantorFundingDetails, guarantorTypeOptions, allowedClientRelationshipTypes, accountLinkingOptions);
    }

    public static GuarantorData mergeClientData(ClientData clientData, GuarantorData guarantorData) {
        return new GuarantorData(guarantorData.id, guarantorData.loanId, guarantorData.clientRelationshipType, guarantorData.entityId, guarantorData.guarantorType, clientData.getFirstname(), clientData.getLastname(), null, null, null, null, null, null, null, null, null, null, clientData.getOfficeName(), clientData.getActivationDate(), clientData.getExternalId().getValue(), guarantorData.status, guarantorData.guarantorFundingDetails, null, guarantorData.allowedClientRelationshipTypes, guarantorData.accountLinkingOptions);
    }

    public static GuarantorData mergeStaffData(StaffData staffData, GuarantorData guarantorData) {
        return new GuarantorData(guarantorData.id, guarantorData.loanId, guarantorData.clientRelationshipType, guarantorData.entityId, guarantorData.guarantorType, staffData.getFirstname(), staffData.getLastname(), null, null, null, null, null, null, null, null, null, null, staffData.getOfficeName(), null, null, guarantorData.status, guarantorData.guarantorFundingDetails, null, guarantorData.allowedClientRelationshipTypes, guarantorData.accountLinkingOptions);
    }

    public GuarantorData(Long id, Long loanId, CodeValueData clientRelationshipType, Long entityId, EnumOptionData guarantorType, String firstname, String lastname, LocalDate dob, String addressLine1, String addressLine2, String city, String state, String zip, String country, String mobileNumber, String housePhoneNumber, String comment, String officeName, LocalDate joinedDate, String externalId, boolean status, Collection<GuarantorFundingData> guarantorFundingDetails, List<EnumOptionData> guarantorTypeOptions, Collection<CodeValueData> allowedClientRelationshipTypes, Collection<PortfolioAccountData> accountLinkingOptions) {
        this.id = id;
        this.loanId = loanId;
        this.clientRelationshipType = clientRelationshipType;
        this.guarantorType = guarantorType;
        this.entityId = entityId;
        this.firstname = firstname;
        this.lastname = lastname;
        this.dob = dob;
        this.addressLine1 = addressLine1;
        this.addressLine2 = addressLine2;
        this.city = city;
        this.state = state;
        this.zip = zip;
        this.country = country;
        this.mobileNumber = mobileNumber;
        this.housePhoneNumber = housePhoneNumber;
        this.comment = comment;
        this.officeName = officeName;
        this.joinedDate = joinedDate;
        this.externalId = externalId;
        this.status = status;
        this.guarantorFundingDetails = guarantorFundingDetails;
        this.guarantorTypeOptions = guarantorTypeOptions;
        this.allowedClientRelationshipTypes = allowedClientRelationshipTypes;
        this.accountLinkingOptions = accountLinkingOptions;
    }

    public boolean isExternalGuarantor() {
        return GuarantorType.EXTERNAL.getValue().equals(((Long)this.guarantorType.getId()).intValue());
    }

    public boolean isExistingClient() {
        return GuarantorType.CUSTOMER.getValue().equals(((Long)this.guarantorType.getId()).intValue());
    }

    public boolean isStaffMember() {
        return GuarantorType.STAFF.getValue().equals(((Long)this.guarantorType.getId()).intValue());
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getLoanId() {
        return this.loanId;
    }

    @Generated
    public CodeValueData getClientRelationshipType() {
        return this.clientRelationshipType;
    }

    @Generated
    public EnumOptionData getGuarantorType() {
        return this.guarantorType;
    }

    @Generated
    public String getFirstname() {
        return this.firstname;
    }

    @Generated
    public String getLastname() {
        return this.lastname;
    }

    @Generated
    public Long getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getExternalId() {
        return this.externalId;
    }

    @Generated
    public String getOfficeName() {
        return this.officeName;
    }

    @Generated
    public LocalDate getJoinedDate() {
        return this.joinedDate;
    }

    @Generated
    public String getAddressLine1() {
        return this.addressLine1;
    }

    @Generated
    public String getAddressLine2() {
        return this.addressLine2;
    }

    @Generated
    public String getCity() {
        return this.city;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public String getZip() {
        return this.zip;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public String getMobileNumber() {
        return this.mobileNumber;
    }

    @Generated
    public String getHousePhoneNumber() {
        return this.housePhoneNumber;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public LocalDate getDob() {
        return this.dob;
    }

    @Generated
    public Collection<GuarantorFundingData> getGuarantorFundingDetails() {
        return this.guarantorFundingDetails;
    }

    @Generated
    public boolean isStatus() {
        return this.status;
    }

    @Generated
    public List<EnumOptionData> getGuarantorTypeOptions() {
        return this.guarantorTypeOptions;
    }

    @Generated
    public Collection<CodeValueData> getAllowedClientRelationshipTypes() {
        return this.allowedClientRelationshipTypes;
    }

    @Generated
    public Collection<PortfolioAccountData> getAccountLinkingOptions() {
        return this.accountLinkingOptions;
    }

    @Generated
    public Integer getGuarantorTypeId() {
        return this.guarantorTypeId;
    }

    @Generated
    public Integer getClientRelationshipTypeId() {
        return this.clientRelationshipTypeId;
    }

    @Generated
    public Integer getSavingsId() {
        return this.savingsId;
    }

    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAccountId() {
        return this.accountId;
    }

    @Generated
    public Integer getRowIndex() {
        return this.rowIndex;
    }

    @Generated
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }
}

