/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanproduct.productmix.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class ProductMixDataValidator {
    public static final String RESTRICTED_PRODUCTS = "restrictedProducts";
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(List.of("restrictedProducts"));
    public static final String PRODUCTMIX = "productmix";
    public static final String RESTRICTED_PRODUCT = "restrictedProduct";
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public ProductMixDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(PRODUCTMIX);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String[] restrictedProducts = this.fromApiJsonHelper.extractArrayNamed(RESTRICTED_PRODUCTS, element);
        baseDataValidator.reset().parameter(RESTRICTED_PRODUCTS).value((Object)restrictedProducts).arrayNotEmpty();
        if (restrictedProducts != null) {
            this.validateRestrictedProducts(restrictedProducts, baseDataValidator);
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void validateRestrictedProducts(String[] restrictedProducts, DataValidatorBuilder baseDataValidator) {
        for (String restrictedId : restrictedProducts) {
            baseDataValidator.reset().parameter(RESTRICTED_PRODUCT).value((Object)restrictedId).notBlank().longGreaterThanZero();
        }
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(PRODUCTMIX);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String[] restrictedProducts = this.fromApiJsonHelper.extractArrayNamed(RESTRICTED_PRODUCTS, element);
        this.validateRestrictedProducts(restrictedProducts, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }
}

