/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksReadService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.charge.util.ConvertChargeDataToSpecificChargeData;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.group.data.GroupGeneralData;
import org.apache.fineract.portfolio.group.service.GroupReadPlatformService;
import org.apache.fineract.portfolio.savings.data.SavingsAccountChargeData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountData;
import org.apache.fineract.portfolio.savings.service.SavingsAccountTemplateReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountTemplateReadPlatformServiceImpl;
import org.apache.fineract.portfolio.savings.service.SavingsDropdownReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsProductReadPlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

public class SavingsAccountTemplateReadPlatformServiceImpl
implements SavingsAccountTemplateReadPlatformService {
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private final ClientReadPlatformService clientReadPlatformService;
    private final GroupReadPlatformService groupReadPlatformService;
    private final SavingsProductReadPlatformService savingsProductReadPlatformService;
    private final StaffReadPlatformService staffReadPlatformService;
    private final SavingsDropdownReadPlatformService dropdownReadPlatformService;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final EntityDatatableChecksReadService entityDatatableChecksReadService;

    public SavingsAccountTemplateReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, ClientReadPlatformService clientReadPlatformService, GroupReadPlatformService groupReadPlatformService, SavingsProductReadPlatformService savingProductReadPlatformService, StaffReadPlatformService staffReadPlatformService, SavingsDropdownReadPlatformService dropdownReadPlatformService, ChargeReadPlatformService chargeReadPlatformService, EntityDatatableChecksReadService entityDatatableChecksReadService, ColumnValidator columnValidator) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.clientReadPlatformService = clientReadPlatformService;
        this.groupReadPlatformService = groupReadPlatformService;
        this.savingsProductReadPlatformService = savingProductReadPlatformService;
        this.staffReadPlatformService = staffReadPlatformService;
        this.dropdownReadPlatformService = dropdownReadPlatformService;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.entityDatatableChecksReadService = entityDatatableChecksReadService;
    }

    public SavingsAccountData retrieveTemplate(Long clientId, Long groupId, Long productId, boolean staffInSelectedOfficeOnly) {
        AppUser loggedInUser = this.context.authenticatedUser();
        Long officeId = (Long)loggedInUser.getOffice().getId();
        ClientData client = null;
        if (clientId != null) {
            client = this.clientReadPlatformService.retrieveOne(clientId);
            officeId = client.getOfficeId();
        }
        GroupGeneralData group = null;
        if (groupId != null) {
            group = this.groupReadPlatformService.retrieveOne(groupId);
            officeId = group.getOfficeId();
        }
        Collection productOptions = this.savingsProductReadPlatformService.retrieveAllForLookup();
        SavingsAccountData template = null;
        if (productId != null) {
            SavingAccountTemplateMapper mapper = new SavingAccountTemplateMapper(client, group);
            String sql = "select " + mapper.schema() + " where sp.id = ?";
            template = (SavingsAccountData)this.jdbcTemplate.queryForObject(sql, (RowMapper)mapper, new Object[]{productId});
            Collection interestCompoundingPeriodTypeOptions = this.dropdownReadPlatformService.retrieveCompoundingInterestPeriodTypeOptions();
            Collection interestPostingPeriodTypeOptions = this.dropdownReadPlatformService.retrieveInterestPostingPeriodTypeOptions();
            Collection interestCalculationTypeOptions = this.dropdownReadPlatformService.retrieveInterestCalculationTypeOptions();
            Collection interestCalculationDaysInYearTypeOptions = this.dropdownReadPlatformService.retrieveInterestCalculationDaysInYearTypeOptions();
            Collection lockinPeriodFrequencyTypeOptions = this.dropdownReadPlatformService.retrieveLockinPeriodFrequencyTypeOptions();
            Collection withdrawalFeeTypeOptions = this.dropdownReadPlatformService.retrievewithdrawalFeeTypeOptions();
            Collection transactions = null;
            List productCharges = this.chargeReadPlatformService.retrieveSavingsProductCharges(productId);
            Collection charges = this.fromChargesToSavingsCharges((Collection)productCharges);
            boolean feeChargesOnly = false;
            List chargeOptions = this.chargeReadPlatformService.retrieveSavingsProductApplicableCharges(false);
            ArrayList fieldOfficerOptions = null;
            if (officeId != null) {
                if (staffInSelectedOfficeOnly) {
                    List fieldOfficersInBranch = this.staffReadPlatformService.retrieveAllLoanOfficersInOfficeById(officeId);
                    if (!CollectionUtils.isEmpty((Collection)fieldOfficersInBranch)) {
                        fieldOfficerOptions = new ArrayList(fieldOfficersInBranch);
                    }
                } else {
                    boolean restrictToLoanOfficersOnly = true;
                    List loanOfficersInHierarchy = this.staffReadPlatformService.retrieveAllStaffInOfficeAndItsParentOfficeHierarchy(officeId, true);
                    if (!CollectionUtils.isEmpty((Collection)loanOfficersInHierarchy)) {
                        fieldOfficerOptions = new ArrayList(loanOfficersInHierarchy);
                    }
                }
            }
            template = SavingsAccountData.withTemplateOptions((SavingsAccountData)template, (Collection)productOptions, fieldOfficerOptions, (Collection)interestCompoundingPeriodTypeOptions, (Collection)interestPostingPeriodTypeOptions, (Collection)interestCalculationTypeOptions, (Collection)interestCalculationDaysInYearTypeOptions, (Collection)lockinPeriodFrequencyTypeOptions, (Collection)withdrawalFeeTypeOptions, transactions, (Collection)charges, (Collection)chargeOptions);
        } else {
            String clientName = null;
            if (client != null) {
                clientName = client.getDisplayName();
            }
            String groupName = null;
            if (group != null) {
                groupName = group.getName();
            }
            template = SavingsAccountData.withClientTemplate((Long)clientId, (String)clientName, (Long)groupId, (String)groupName);
            Collection fieldOfficerOptions = null;
            Collection interestCompoundingPeriodTypeOptions = null;
            Collection interestPostingPeriodTypeOptions = null;
            Collection interestCalculationTypeOptions = null;
            Collection interestCalculationDaysInYearTypeOptions = null;
            Collection lockinPeriodFrequencyTypeOptions = null;
            Collection withdrawalFeeTypeOptions = null;
            Collection transactions = null;
            Collection charges = null;
            boolean feeChargesOnly = false;
            List chargeOptions = this.chargeReadPlatformService.retrieveSavingsProductApplicableCharges(false);
            template = SavingsAccountData.withTemplateOptions((SavingsAccountData)template, (Collection)productOptions, fieldOfficerOptions, interestCompoundingPeriodTypeOptions, interestPostingPeriodTypeOptions, interestCalculationTypeOptions, interestCalculationDaysInYearTypeOptions, lockinPeriodFrequencyTypeOptions, withdrawalFeeTypeOptions, transactions, charges, (Collection)chargeOptions);
        }
        List datatableTemplates = this.entityDatatableChecksReadService.retrieveTemplates(StatusEnum.CREATE.getValue(), EntityTables.SAVINGS.getName(), productId);
        template.setDatatables(datatableTemplates);
        return template;
    }

    private Collection<SavingsAccountChargeData> fromChargesToSavingsCharges(Collection<ChargeData> productCharges) {
        ArrayList<SavingsAccountChargeData> savingsCharges = new ArrayList<SavingsAccountChargeData>();
        for (ChargeData chargeData : productCharges) {
            SavingsAccountChargeData savingsCharge = ConvertChargeDataToSpecificChargeData.toSavingsAccountChargeData((ChargeData)chargeData);
            savingsCharges.add(savingsCharge);
        }
        return savingsCharges;
    }
}

