/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.pockets.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.self.pockets.data.PocketDataValidator;
import org.apache.fineract.portfolio.self.pockets.domain.Pocket;
import org.apache.fineract.portfolio.self.pockets.domain.PocketAccountMapping;
import org.apache.fineract.portfolio.self.pockets.domain.PocketAccountMappingRepositoryWrapper;
import org.apache.fineract.portfolio.self.pockets.domain.PocketRepositoryWrapper;
import org.apache.fineract.portfolio.self.pockets.service.AccountEntityService;
import org.apache.fineract.portfolio.self.pockets.service.AccountEntityServiceFactory;
import org.apache.fineract.portfolio.self.pockets.service.PocketAccountMappingReadPlatformService;
import org.apache.fineract.portfolio.self.pockets.service.PocketWritePlatformService;
import org.springframework.transaction.annotation.Transactional;

public class PocketWritePlatformServiceImpl
implements PocketWritePlatformService {
    private final PlatformSecurityContext context;
    private final PocketDataValidator pocketDataValidator;
    private final AccountEntityServiceFactory accountEntityServiceFactory;
    private final PocketRepositoryWrapper pocketRepositoryWrapper;
    private final PocketAccountMappingRepositoryWrapper pocketAccountMappingRepositoryWrapper;
    private final PocketAccountMappingReadPlatformService pocketAccountMappingReadPlatformService;

    @Transactional
    public CommandProcessingResult linkAccounts(JsonCommand command) {
        this.pocketDataValidator.validateForLinkingAccounts(command.json());
        JsonArray accountsDetail = command.arrayOfParameterNamed("accountsDetail");
        Long pocketId = this.pocketRepositoryWrapper.findByAppUserId((Long)this.context.authenticatedUser().getId());
        if (pocketId == null) {
            Pocket pocket = Pocket.instance((Long)((Long)this.context.authenticatedUser().getId()));
            this.pocketRepositoryWrapper.saveAndFlush(pocket);
            pocketId = (Long)pocket.getId();
        }
        ArrayList<PocketAccountMapping> pocketAccounts = new ArrayList<PocketAccountMapping>();
        for (int i = 0; i < accountsDetail.size(); ++i) {
            JsonObject element = accountsDetail.get(i).getAsJsonObject();
            Long accountId = element.get("accountId").getAsLong();
            String accountType = element.get("accountType").getAsString();
            AccountEntityService accountEntityService = this.accountEntityServiceFactory.getAccountEntityService(accountType);
            accountEntityService.validateSelfUserAccountMapping(accountId);
            Integer accountTypeValue = EntityAccountType.valueOf((String)accountType).getValue();
            if (this.pocketAccountMappingReadPlatformService.validatePocketAndAccountMapping(pocketId, accountId, accountTypeValue)) {
                throw new PlatformDataIntegrityException("error.msg.one.or.more.accounts.are.already.mapped.to.pocket.", "One or more accounts are already mapped to pocket.", new Object[]{accountId, accountType});
            }
            String accountNumber = accountEntityService.retrieveAccountNumberByAccountId(accountId);
            pocketAccounts.add(PocketAccountMapping.instance((Long)pocketId, (Long)accountId, (Integer)accountTypeValue, (String)accountNumber));
        }
        this.pocketAccountMappingRepositoryWrapper.save(pocketAccounts);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(pocketId).build();
    }

    public CommandProcessingResult delinkAccounts(JsonCommand command) {
        this.pocketDataValidator.validateForDeLinkingAccounts(command.json());
        JsonArray pocketAccountMappingList = command.arrayOfParameterNamed("pocketAccountMappingIds");
        Long pocketId = this.pocketRepositoryWrapper.findByAppUserIdWithNotFoundDetection((Long)this.context.authenticatedUser().getId());
        ArrayList<PocketAccountMapping> pocketAccounts = new ArrayList<PocketAccountMapping>();
        for (JsonElement mapping : pocketAccountMappingList) {
            Long mappingId = mapping.getAsLong();
            PocketAccountMapping pocketAccountMapping = this.pocketAccountMappingRepositoryWrapper.findByIdAndPocketIdWithNotFoundException(mappingId, pocketId);
            if (pocketAccountMapping == null) continue;
            pocketAccounts.add(pocketAccountMapping);
        }
        this.pocketAccountMappingRepositoryWrapper.delete(pocketAccounts);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(pocketId).build();
    }

    @Generated
    public PocketWritePlatformServiceImpl(PlatformSecurityContext context, PocketDataValidator pocketDataValidator, AccountEntityServiceFactory accountEntityServiceFactory, PocketRepositoryWrapper pocketRepositoryWrapper, PocketAccountMappingRepositoryWrapper pocketAccountMappingRepositoryWrapper, PocketAccountMappingReadPlatformService pocketAccountMappingReadPlatformService) {
        this.context = context;
        this.pocketDataValidator = pocketDataValidator;
        this.accountEntityServiceFactory = accountEntityServiceFactory;
        this.pocketRepositoryWrapper = pocketRepositoryWrapper;
        this.pocketAccountMappingRepositoryWrapper = pocketAccountMappingRepositoryWrapper;
        this.pocketAccountMappingReadPlatformService = pocketAccountMappingReadPlatformService;
    }
}

