/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareproducts.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.accounting.common.AccountingDropdownReadPlatformService;
import org.apache.fineract.accounting.producttoaccountmapping.service.ProductToGLAccountMappingReadPlatformService;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.organisation.monetary.service.CurrencyReadPlatformService;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.products.data.ProductData;
import org.apache.fineract.portfolio.products.exception.ProductNotFoundException;
import org.apache.fineract.portfolio.products.service.ShareProductReadPlatformService;
import org.apache.fineract.portfolio.shareproducts.data.ShareProductData;
import org.apache.fineract.portfolio.shareproducts.service.ShareProductDropdownReadPlatformService;
import org.apache.fineract.portfolio.shareproducts.service.ShareProductReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ShareProductReadPlatformServiceImpl
implements ShareProductReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final CurrencyReadPlatformService currencyReadPlatformService;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final ShareProductDropdownReadPlatformService shareProductDropdownReadPlatformService;
    private final AccountingDropdownReadPlatformService accountingDropdownReadPlatformService;
    private final ProductToGLAccountMappingReadPlatformService accountMappingReadPlatformService;
    private final PaginationHelper shareProductDataPaginationHelper;
    private final DatabaseSpecificSQLGenerator sqlGenerator;

    public Page<ProductData> retrieveAllProducts(Integer offSet, Integer limit) {
        Collection shareMarketCollection = null;
        Collection charges = null;
        ShareProductRowMapper mapper = new ShareProductRowMapper(shareMarketCollection, charges);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(mapper.schema());
        if (limit != null) {
            sqlBuilder.append(" limit ").append(limit);
        }
        if (offSet != null) {
            sqlBuilder.append(" offset ").append(offSet);
        }
        Object[] whereClauseItemsitems = new Object[]{};
        return this.shareProductDataPaginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), whereClauseItemsitems, (RowMapper)mapper);
    }

    public ProductData retrieveOne(Long productId, boolean includeTemplate) {
        MarketPriceRowMapper marketRowMapper = new MarketPriceRowMapper();
        try {
            String sql1 = "select " + marketRowMapper.schema() + " where marketData.product_id = ?";
            List shareMarketCollection = this.jdbcTemplate.query(sql1, (RowMapper)marketRowMapper, new Object[]{productId});
            List charges = this.chargeReadPlatformService.retrieveShareProductCharges(productId);
            ShareProductRowMapper mapper = new ShareProductRowMapper((Collection)shareMarketCollection, (Collection)charges);
            String sql = "select " + mapper.schema() + " where shareproduct.id = ?";
            ShareProductData data = (ShareProductData)this.jdbcTemplate.queryForObject(sql, (RowMapper)mapper, new Object[]{productId});
            if (data.hasAccountingEnabled()) {
                Map accountingMappings = this.accountMappingReadPlatformService.fetchAccountMappingDetailsForShareProduct(productId, Integer.valueOf(data.accountingRuleTypeId()));
                List paymentChannelToFundSourceMappings = this.accountMappingReadPlatformService.fetchPaymentTypeToFundSourceMappingsForShareProduct(productId);
                List feeToGLAccountMappings = this.accountMappingReadPlatformService.fetchFeeToIncomeAccountMappingsForShareProduct(productId);
                data = ShareProductData.withAccountingDetails((ShareProductData)data, (Map)accountingMappings, (Collection)paymentChannelToFundSourceMappings, (Collection)feeToGLAccountMappings);
            }
            if (includeTemplate) {
                List chargeOptions = this.chargeReadPlatformService.retrieveSharesApplicableCharges();
                List currencyOptions = this.currencyReadPlatformService.retrieveAllowedCurrencies();
                Collection lockinPeriodFrequencyTypeOptions = this.shareProductDropdownReadPlatformService.retrieveLockinPeriodFrequencyTypeOptions();
                Collection minimumActivePeriodFrequencyTypeOptions = this.shareProductDropdownReadPlatformService.retrieveMinimumActivePeriodFrequencyTypeOptions();
                Map accountingMappingOptions = this.accountingDropdownReadPlatformService.retrieveAccountMappingOptionsForShareProducts();
                data = ShareProductData.template((ShareProductData)data, (Collection)currencyOptions, (Collection)chargeOptions, (Collection)minimumActivePeriodFrequencyTypeOptions, (Collection)lockinPeriodFrequencyTypeOptions, (Map)accountingMappingOptions);
            }
            return data;
        }
        catch (EmptyResultDataAccessException e) {
            throw new ProductNotFoundException(productId, "share", e);
        }
    }

    public ProductData retrieveTemplate() {
        List chargeOptions = this.chargeReadPlatformService.retrieveSharesApplicableCharges();
        List currencyOptions = this.currencyReadPlatformService.retrieveAllowedCurrencies();
        Collection lockinPeriodFrequencyTypeOptions = this.shareProductDropdownReadPlatformService.retrieveLockinPeriodFrequencyTypeOptions();
        Collection minimumActivePeriodFrequencyTypeOptions = this.shareProductDropdownReadPlatformService.retrieveMinimumActivePeriodFrequencyTypeOptions();
        Map accountingMappingOptions = this.accountingDropdownReadPlatformService.retrieveAccountMappingOptionsForShareProducts();
        return ShareProductData.template((Collection)currencyOptions, (Collection)chargeOptions, (Collection)minimumActivePeriodFrequencyTypeOptions, (Collection)lockinPeriodFrequencyTypeOptions, (Map)accountingMappingOptions);
    }

    public Collection<ProductData> retrieveAllForLookup() {
        AllShareProductRowMapper mapper = new AllShareProductRowMapper();
        String sql = "select " + mapper.schema();
        return this.jdbcTemplate.query(sql, (RowMapper)mapper);
    }

    public Set<String> getResponseDataParams() {
        return null;
    }

    @Generated
    public ShareProductReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, CurrencyReadPlatformService currencyReadPlatformService, ChargeReadPlatformService chargeReadPlatformService, ShareProductDropdownReadPlatformService shareProductDropdownReadPlatformService, AccountingDropdownReadPlatformService accountingDropdownReadPlatformService, ProductToGLAccountMappingReadPlatformService accountMappingReadPlatformService, PaginationHelper shareProductDataPaginationHelper, DatabaseSpecificSQLGenerator sqlGenerator) {
        this.jdbcTemplate = jdbcTemplate;
        this.currencyReadPlatformService = currencyReadPlatformService;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.shareProductDropdownReadPlatformService = shareProductDropdownReadPlatformService;
        this.accountingDropdownReadPlatformService = accountingDropdownReadPlatformService;
        this.accountMappingReadPlatformService = accountMappingReadPlatformService;
        this.shareProductDataPaginationHelper = shareProductDataPaginationHelper;
        this.sqlGenerator = sqlGenerator;
    }
}

