/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.useradministration.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookPopulatorService;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.UploadRequest;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.useradministration.api.UsersApiResourceSwagger;
import org.apache.fineract.useradministration.data.AppUserData;
import org.apache.fineract.useradministration.service.AppUserReadPlatformService;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;

@Path(value="/v1/users")
@Component
@Tag(name="Users", description="An API capability to support administration of application users.")
public class UsersApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "officeId", "officeName", "username", "firstname", "lastname", "email", "allowedOffices", "availableRoles", "selectedRoles", "staff"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "USER";
    private final PlatformSecurityContext context;
    private final AppUserReadPlatformService readPlatformService;
    private final OfficeReadPlatformService officeReadPlatformService;
    private final DefaultToApiJsonSerializer<AppUserData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService;
    private final BulkImportWorkbookService bulkImportWorkbookService;

    @GET
    @Operation(summary="Retrieve list of users", description="Example Requests:\n\nusers\n\n\nusers?fields=id,username,email,officeName")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UsersApiResourceSwagger.GetUsersResponse.class)))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveAll(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection users = this.readPlatformService.retrieveAllUsers();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, users, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{userId}")
    @Operation(summary="Retrieve a User", description="Example Requests:\n\nusers/1\n\n\nusers/1?template=true\n\n\nusers/1?fields=username,officeName")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=UsersApiResourceSwagger.GetUsersUserIdResponse.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveOne(@PathParam(value="userId") @Parameter(description="userId") Long userId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS, userId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        AppUserData user = this.readPlatformService.retrieveUser(userId);
        if (settings.isTemplate()) {
            Collection offices = this.officeReadPlatformService.retrieveAllOfficesForDropdown();
            user = AppUserData.template((AppUserData)user, (Collection)offices);
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)user, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="template")
    @Operation(summary="Retrieve User Details Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed description Lists\nExample Request:\n\nusers/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=UsersApiResourceSwagger.GetUsersTemplateResponse.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String template(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        AppUserData user = this.readPlatformService.retrieveNewUserDetails();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)user, RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Operation(summary="Create a User", description="Adds new application user.\n\nNote: Password information is not required (or processed). Password details at present are auto-generated and then sent to the email account given (which is why it can take a few seconds to complete).\n\nMandatory Fields: \nusername, firstname, lastname, email, officeId, roles, sendPasswordToEmail\n\nOptional Fields: \nstaffId,passwordNeverExpires,isSelfServiceUser,clients")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=UsersApiResourceSwagger.PostUsersRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=UsersApiResourceSwagger.PostUsersResponse.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String create(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createUser().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{userId}")
    @Operation(summary="Update a User", description="Updates the user")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=UsersApiResourceSwagger.PutUsersUserIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=UsersApiResourceSwagger.PutUsersUserIdResponse.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String update(@PathParam(value="userId") @Parameter(description="userId") Long userId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateUser(userId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{userId}/pwd")
    @Operation(summary="Change the password of a User", description="When updating a password you must provide the repeatPassword parameter also.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=UsersApiResourceSwagger.ChangePwdUsersUserIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=UsersApiResourceSwagger.ChangePwdUsersUserIdResponse.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String changePassword(@PathParam(value="userId") @Parameter(description="userId") Long userId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().changeUserPassword(userId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{userId}")
    @Operation(summary="Delete a User", description="Removes the user and the associated roles and permissions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=UsersApiResourceSwagger.DeleteUsersUserIdResponse.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String delete(@PathParam(value="userId") @Parameter(description="userId") Long userId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteUser(userId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getUserTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="staffId") Long staffId, @QueryParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.USERS.toString(), officeId, staffId, dateFormat);
    }

    @POST
    @Path(value="uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload users template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String postUsersTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat) {
        Long importDocumentId = this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.USERS.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
        return this.toApiJsonSerializer.serialize((Object)importDocumentId);
    }

    @Generated
    public UsersApiResource(PlatformSecurityContext context, AppUserReadPlatformService readPlatformService, OfficeReadPlatformService officeReadPlatformService, DefaultToApiJsonSerializer<AppUserData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService, BulkImportWorkbookService bulkImportWorkbookService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.officeReadPlatformService = officeReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.bulkImportWorkbookPopulatorService = bulkImportWorkbookPopulatorService;
        this.bulkImportWorkbookService = bulkImportWorkbookService;
    }
}

