/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.sharedbuffer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.cep.nfa.sharedbuffer.Lockable;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferEdge;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferNode;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferNodeSerializerSnapshotV2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

public class SharedBufferNodeSerializer
extends TypeSerializerSingleton<SharedBufferNode> {
    private static final long serialVersionUID = -6687780732295439832L;
    private final TypeSerializer<SharedBufferEdge> edgeSerializer;

    public SharedBufferNodeSerializer() {
        this.edgeSerializer = new SharedBufferEdge.SharedBufferEdgeSerializer();
    }

    SharedBufferNodeSerializer(TypeSerializer<SharedBufferEdge> edgeSerializer) {
        this.edgeSerializer = (TypeSerializer)Preconditions.checkNotNull(edgeSerializer);
    }

    public TypeSerializer<SharedBufferEdge> getEdgeSerializer() {
        return this.edgeSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public SharedBufferNode createInstance() {
        return new SharedBufferNode(new ArrayList<Lockable<SharedBufferEdge>>());
    }

    public SharedBufferNode copy(SharedBufferNode from) {
        return new SharedBufferNode(from.getEdges().stream().map(edge -> new Lockable<SharedBufferEdge>((SharedBufferEdge)this.edgeSerializer.copy((Object)((SharedBufferEdge)edge.getElement())), edge.getRefCounter())).collect(Collectors.toList()));
    }

    public SharedBufferNode copy(SharedBufferNode from, SharedBufferNode reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(SharedBufferNode record, DataOutputView target) throws IOException {
        List<Lockable<SharedBufferEdge>> edges = record.getEdges();
        target.writeInt(edges.size());
        for (Lockable<SharedBufferEdge> edge : edges) {
            target.writeInt(edge.getRefCounter());
            this.edgeSerializer.serialize((Object)edge.getElement(), target);
        }
    }

    public SharedBufferNode deserialize(DataInputView source) throws IOException {
        int length = source.readInt();
        ArrayList<Lockable<SharedBufferEdge>> edges = new ArrayList<Lockable<SharedBufferEdge>>();
        for (int i = 0; i < length; ++i) {
            int refCount = source.readInt();
            SharedBufferEdge edge = (SharedBufferEdge)this.edgeSerializer.deserialize(source);
            edges.add(new Lockable<SharedBufferEdge>(edge, refCount));
        }
        return new SharedBufferNode(edges);
    }

    public SharedBufferNode deserialize(SharedBufferNode reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        for (int i = 0; i < length; ++i) {
            target.writeInt(source.readInt());
            this.edgeSerializer.copy(source, target);
        }
    }

    public TypeSerializerSnapshot<SharedBufferNode> snapshotConfiguration() {
        return new SharedBufferNodeSerializerSnapshotV2(this);
    }
}

