/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.ml;

import java.util.Arrays;
import org.apache.flink.annotation.Experimental;

@Experimental
public enum TaskType {
    REGRESSION("regression"),
    CLUSTERING("clustering"),
    CLASSIFICATION("classification"),
    EMBEDDING("embedding"),
    TEXT_GENERATION("text_generation");

    private final String name;

    private TaskType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static TaskType fromName(String name) {
        return Arrays.stream(TaskType.values()).filter(taskType -> taskType.name.equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown task type: " + name));
    }

    public static boolean isValidTaskType(String name) {
        return Arrays.stream(TaskType.values()).anyMatch(taskType -> taskType.name.equals(name));
    }
}

