/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.operations.AbstractShowOperation;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.utils.ShowLikeOperator;

@Internal
public class ShowMaterializedTablesOperation
extends AbstractShowOperation {
    @Nullable
    private final String databaseName;

    public ShowMaterializedTablesOperation(@Nullable String catalogName, @Nullable String databaseName, @Nullable String preposition, @Nullable ShowLikeOperator likeOp) {
        super(catalogName, preposition, likeOp);
        this.databaseName = databaseName;
    }

    public ShowMaterializedTablesOperation(@Nullable String catalogName, @Nullable String databaseName, @Nullable ShowLikeOperator likeOp) {
        this(catalogName, databaseName, null, likeOp);
    }

    @Override
    protected Collection<String> retrieveDataForTableResult(ExecutableOperation.Context ctx) {
        CatalogManager catalogManager = ctx.getCatalogManager();
        String qualifiedCatalogName = catalogManager.qualifyCatalog(this.catalogName);
        String qualifiedDatabaseName = catalogManager.qualifyDatabase(this.databaseName);
        if (this.preposition == null) {
            return catalogManager.listMaterializedTables();
        }
        Catalog catalog = catalogManager.getCatalogOrThrowException(qualifiedCatalogName);
        if (catalog.databaseExists(qualifiedDatabaseName)) {
            return catalogManager.listMaterializedTables(qualifiedCatalogName, qualifiedDatabaseName);
        }
        throw new ValidationException(String.format("Database '%s'.'%s' doesn't exist.", qualifiedCatalogName, qualifiedDatabaseName));
    }

    @Override
    protected String getOperationName() {
        return "SHOW MATERIALIZED TABLES";
    }

    @Override
    protected String getColumnName() {
        return "materialized table";
    }

    @Override
    public String getPrepositionSummaryString() {
        if (this.databaseName == null) {
            return super.getPrepositionSummaryString();
        }
        return super.getPrepositionSummaryString() + "." + this.databaseName;
    }
}

