/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;

@Internal
public final class ReinterpretCastInputTypeStrategy
implements InputTypeStrategy {
    @Override
    public ArgumentCount getArgumentCount() {
        return ConstantArgumentCount.of(3);
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        if (!callContext.isArgumentLiteral(1) || !callContext.getArgumentValue(1, DataType.class).isPresent()) {
            return callContext.fail(throwOnFailure, "Expected type literal for the second argument.", new Object[0]);
        }
        if (!argumentDataTypes.get(2).getLogicalType().is(LogicalTypeRoot.BOOLEAN) || !callContext.isArgumentLiteral(2) || callContext.isArgumentNull(2)) {
            return callContext.fail(throwOnFailure, "Not null boolean literal expected for overflow.", new Object[0]);
        }
        LogicalType fromType = argumentDataTypes.get(0).getLogicalType();
        LogicalType toType = argumentDataTypes.get(1).getLogicalType();
        if (fromType instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes);
        }
        if (!LogicalTypeCasts.supportsReinterpretCast(fromType, toType)) {
            return callContext.fail(throwOnFailure, "Unsupported reinterpret cast from '%s' to '%s'.", fromType, toType);
        }
        return Optional.of(argumentDataTypes);
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return Collections.singletonList(Signature.of(Signature.Argument.ofGroup("ANY"), Signature.Argument.ofGroup("TYPE LITERAL"), Signature.Argument.ofGroup("TRUE | FALSE")));
    }
}

