/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils.print;

import java.io.PrintWriter;
import java.util.Iterator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.utils.print.RawContentStyle;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.table.utils.print.TableauStyle;
import org.apache.flink.util.Preconditions;

@Internal
public interface PrintStyle {
    public static final int DEFAULT_MAX_COLUMN_WIDTH = 30;
    public static final String NULL_VALUE = "<NULL>";

    public void print(Iterator<RowData> var1, PrintWriter var2);

    public static TableauStyle tableauWithTypeInferredColumnWidths(ResolvedSchema schema, RowDataToStringConverter converter, int maxColumnWidth, boolean printNullAsEmpty, boolean printRowKind) {
        Preconditions.checkArgument((maxColumnWidth > 0 ? 1 : 0) != 0, (Object)"maxColumnWidth should be greater than 0");
        return new TableauStyle(schema, converter, TableauStyle.columnWidthsByType(schema.getColumns(), maxColumnWidth, printNullAsEmpty, printRowKind), maxColumnWidth, printNullAsEmpty, printRowKind);
    }

    public static TableauStyle tableauWithDataInferredColumnWidths(ResolvedSchema schema, RowDataToStringConverter converter, int maxColumnWidth, boolean printNullAsEmpty, boolean printRowKind) {
        Preconditions.checkArgument((maxColumnWidth > 0 ? 1 : 0) != 0, (Object)"maxColumnWidth should be greater than 0");
        return new TableauStyle(schema, converter, null, maxColumnWidth, printNullAsEmpty, printRowKind);
    }

    public static TableauStyle tableauWithDataInferredColumnWidths(ResolvedSchema schema, RowDataToStringConverter converter) {
        return PrintStyle.tableauWithDataInferredColumnWidths(schema, converter, 30, false, false);
    }

    public static RawContentStyle rawContent(RowDataToStringConverter converter) {
        return new RawContentStyle(converter);
    }
}

