/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.utils.DateTimeUtils;

@Internal
public class ToTimestampLtzFunction
extends BuiltInScalarFunction {
    private static final int DEFAULT_PRECISION = 3;

    public ToTimestampLtzFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.TO_TIMESTAMP_LTZ, context);
    }

    @Nullable
    public TimestampData eval(Number epoch, Integer precision) {
        if (epoch == null || precision == null) {
            return null;
        }
        if (epoch instanceof Float || epoch instanceof Double) {
            return DateTimeUtils.toTimestampData((double)epoch.doubleValue(), (int)precision);
        }
        return DateTimeUtils.toTimestampData((long)epoch.longValue(), (int)precision);
    }

    @Nullable
    public TimestampData eval(DecimalData epoch, Integer precision) {
        if (epoch == null || precision == null) {
            return null;
        }
        return DateTimeUtils.toTimestampData((DecimalData)epoch, (int)precision);
    }

    @Nullable
    public TimestampData eval(Number epoch) {
        return this.eval(epoch, (Integer)3);
    }

    @Nullable
    public TimestampData eval(DecimalData epoch) {
        return this.eval(epoch, (Integer)3);
    }

    @Nullable
    public TimestampData eval(StringData timestamp) {
        if (timestamp == null) {
            return null;
        }
        return DateTimeUtils.parseTimestampData((String)timestamp.toString());
    }

    @Nullable
    public TimestampData eval(StringData timestamp, StringData format) {
        if (timestamp == null || format == null) {
            return null;
        }
        return DateTimeUtils.parseTimestampData((String)timestamp.toString(), (String)format.toString());
    }

    @Nullable
    public TimestampData eval(StringData dateStr, StringData format, StringData timezone) {
        if (dateStr == null || format == null || timezone == null) {
            return null;
        }
        TimestampData ts = DateTimeUtils.parseTimestampData((String)dateStr.toString(), (String)format.toString());
        if (ts == null) {
            return null;
        }
        try {
            ZonedDateTime zoneDate = ts.toLocalDateTime().atZone(ZoneId.of(timezone.toString()));
            return TimestampData.fromInstant((Instant)zoneDate.toInstant());
        }
        catch (DateTimeException e) {
            return null;
        }
    }
}

