/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.asyncwindow.combines;

import java.time.ZoneId;
import java.util.Iterator;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.runtime.dataview.UnsupportedStateDataViewStore;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.window.async.tvf.combines.AsyncStateRecordsCombiner;
import org.apache.flink.table.runtime.operators.window.async.tvf.state.WindowAsyncState;
import org.apache.flink.table.runtime.operators.window.async.tvf.state.WindowAsyncValueState;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowTimerService;
import org.apache.flink.table.runtime.util.TimeWindowUtil;

public class AsyncStateAggCombiner
implements AsyncStateRecordsCombiner {
    private final WindowTimerService<Long> timerService;
    private final WindowAsyncValueState<Long> accState;
    private final NamespaceAggsHandleFunction<Long> aggregator;
    private final boolean isEventTime;

    public AsyncStateAggCombiner(WindowTimerService<Long> timerService, WindowAsyncValueState<Long> accState, NamespaceAggsHandleFunction<Long> aggregator, boolean isEventTime) {
        this.timerService = timerService;
        this.accState = accState;
        this.aggregator = aggregator;
        this.isEventTime = isEventTime;
    }

    @Override
    public StateFuture<Void> asyncCombine(Long window, Iterator<RowData> records) throws Exception {
        StateFuture resultFuture = this.accState.asyncValue(window).thenCompose(acc -> {
            if (acc == null) {
                acc = this.aggregator.createAccumulators();
            }
            this.aggregator.setAccumulators(window, (RowData)acc);
            while (records.hasNext()) {
                RowData record = (RowData)records.next();
                if (RowDataUtil.isAccumulateMsg(record)) {
                    this.aggregator.accumulate(record);
                    continue;
                }
                this.aggregator.retract(record);
            }
            acc = this.aggregator.getAccumulators();
            return this.accState.asyncUpdate(window, (RowData)acc);
        });
        if (this.isEventTime) {
            long currentWatermark = this.timerService.currentWatermark();
            ZoneId shiftTimeZone = this.timerService.getShiftTimeZone();
            if (!TimeWindowUtil.isWindowFired(window, currentWatermark, shiftTimeZone)) {
                this.timerService.registerEventTimeWindowTimer(window);
            }
        }
        return resultFuture;
    }

    @Override
    public void close() throws Exception {
        this.aggregator.close();
    }

    public static final class Factory
    implements AsyncStateRecordsCombiner.Factory {
        private static final long serialVersionUID = 1L;
        private final GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler;

        public Factory(GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler) {
            this.genAggsHandler = genAggsHandler;
        }

        @Override
        public AsyncStateRecordsCombiner createRecordsCombiner(RuntimeContext runtimeContext, WindowTimerService<Long> timerService, WindowAsyncState<Long> windowState, boolean isEventTime) throws Exception {
            NamespaceAggsHandleFunction aggregator = (NamespaceAggsHandleFunction)this.genAggsHandler.newInstance(runtimeContext.getUserCodeClassLoader());
            aggregator.open(new UnsupportedStateDataViewStore(runtimeContext));
            WindowAsyncValueState windowValueState = (WindowAsyncValueState)windowState;
            return new AsyncStateAggCombiner(timerService, windowValueState, aggregator, isEventTime);
        }
    }
}

