/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup.keyordered;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueueEntry;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.util.Preconditions;

public class Epoch<OUT> {
    private final Deque<StreamElementQueueEntry<OUT>> outputQueue;
    private final Watermark watermark;
    private int ongoingRecordCount = 0;
    @Nullable
    private Consumer<StreamElementQueueEntry<OUT>> output = null;
    @Nullable
    private Runnable advanceWatermark = null;
    private EpochStatus status = EpochStatus.OPEN;

    public Epoch(Watermark watermark) {
        this.outputQueue = new LinkedList<StreamElementQueueEntry<OUT>>();
        this.watermark = watermark;
    }

    public void collect(StreamElementQueueEntry<OUT> resultFuture) {
        this.outputQueue.add(resultFuture);
    }

    public void setOutput(Consumer<StreamElementQueueEntry<OUT>> outputConsumer) {
        if (this.output == null) {
            this.output = outputConsumer;
        }
    }

    public void decrementCount() {
        Preconditions.checkState((this.ongoingRecordCount > 0 ? 1 : 0) != 0);
        --this.ongoingRecordCount;
    }

    public void incrementCount() {
        ++this.ongoingRecordCount;
    }

    public Watermark getWatermark() {
        return this.watermark;
    }

    boolean tryFinish() {
        if (this.status == EpochStatus.FINISHED) {
            return true;
        }
        while (!this.outputQueue.isEmpty()) {
            assert (this.output != null);
            this.output.accept(this.outputQueue.poll());
        }
        if (this.ongoingRecordCount == 0 && this.status == EpochStatus.CLOSED) {
            this.status = EpochStatus.FINISHED;
            if (this.advanceWatermark != null) {
                this.advanceWatermark.run();
            }
            return true;
        }
        return false;
    }

    public void close(Runnable advanceWatermark) {
        this.advanceWatermark = advanceWatermark;
        this.status = EpochStatus.CLOSED;
    }

    public void free() {
        this.outputQueue.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Epoch other = (Epoch)obj;
        return this.ongoingRecordCount == other.ongoingRecordCount && Objects.equals(this.watermark, other.watermark) && this.status == other.status;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.watermark.hashCode(), this.ongoingRecordCount, this.status});
    }

    public String toString() {
        return String.format("Epoch{watermark=%s, ongoingRecord=%d}", this.watermark, this.ongoingRecordCount);
    }

    @VisibleForTesting
    public int getOngoingRecordCount() {
        return this.ongoingRecordCount;
    }

    static enum EpochStatus {
        OPEN,
        CLOSED,
        FINISHED;

    }
}

